/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.bean;

import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.bean.Facility;
import com.clustercontrol.performance.bean.Node;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Scope
extends Facility {
    protected static Log m_log = LogFactory.getLog(Node.class);
    private TreeSet m_children = new TreeSet();
    private HashSet m_nodes = new HashSet();

    Scope(String facilityID, String faclityName) {
        super(facilityID, faclityName, "scope");
    }

    public void addChildren(Facility child) {
        this.m_children.add(child);
        if (child.getFacilityType().equals("node")) {
            this.m_nodes.add(child);
        }
    }

    public HashSet getNode(HashSet nodeSet) {
        Iterator itr = this.m_children.iterator();
        nodeSet.addAll(this.m_nodes);
        while (itr.hasNext()) {
            Facility child = (Facility)itr.next();
            if (!child.getFacilityType().equals("scope")) continue;
            ((Scope)child).getNode(nodeSet);
        }
        return nodeSet;
    }

    public int getNodeCount() {
        int count = 0;
        for (Facility child : this.m_children) {
            count += child.getNodeCount();
        }
        return count;
    }

    public double calcValue(CollectorItemInfo itemInfo) {
        double total = 0.0;
        int counter = 0;
        for (Facility child : this.m_children) {
            if (child.getNodeCount() == 0) continue;
            double childValue = child.calcValue(itemInfo);
            if (Double.isNaN(childValue)) {
                childValue = child.getCalcValueBuffer(itemInfo);
            }
            if (Double.isNaN(childValue)) continue;
            total += childValue;
            ++counter;
        }
        double returnValue = counter != 0 ? total / (double)counter : Double.NaN;
        if (!Double.isNaN(returnValue)) {
            this.setCalcValueBuffer(itemInfo, returnValue);
        }
        m_log.debug((Object)("calcValue() : " + this.getFacilityId() + " " + itemInfo.getItemCode() + " " + itemInfo.getDisplayName() + "  " + returnValue));
        return returnValue;
    }

    public String[] getChildrenID() {
        String[] facilityIDs = new String[this.m_children.size()];
        Iterator itr = this.m_children.iterator();
        int i = 0;
        while (itr.hasNext()) {
            facilityIDs[i] = ((Facility)itr.next()).getFacilityId();
            ++i;
        }
        return facilityIDs;
    }
}

