/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.MarshallingException;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.marshall.Region;
import org.jboss.cache.marshall.RegionManager;
import org.jgroups.blocks.MethodCall;

public class LegacyTreeCacheMarshaller
extends Marshaller {
    private Log log = LogFactory.getLog((Class)LegacyTreeCacheMarshaller.class);

    public LegacyTreeCacheMarshaller() {
    }

    public LegacyTreeCacheMarshaller(RegionManager manager, boolean defaultInactive, boolean useRegionBasedMarshalling) {
        this.init(manager, defaultInactive, useRegionBasedMarshalling);
    }

    public RegionManager getManager() {
        return this.regionManager;
    }

    public void setManager(RegionManager manager) {
        this.regionManager = manager;
    }

    public boolean isDefaultInactive() {
        return this.defaultInactive;
    }

    public void setDefaultInactive(boolean defaultInactive) {
        this.defaultInactive = defaultInactive;
    }

    public void objectToStream(Object o, ObjectOutputStream out) throws Exception {
        if (this.useRegionBasedMarshalling) {
            this.objectToStreamImpl(o, out);
        } else {
            out.writeObject(this.externMethodCall(o));
        }
    }

    public Object objectFromStream(ObjectInputStream in) throws Exception {
        Object result;
        Object object = result = this.useRegionBasedMarshalling ? this.objectFromStreamImpl(in) : in.readObject();
        if (result instanceof MethodCall) {
            result = this.internMethodCall((MethodCall)result);
        }
        return result;
    }

    private void objectToStreamImpl(Object o, ObjectOutputStream oos) throws Exception {
        JBCMethodCall call = null;
        String fqn = null;
        try {
            call = (JBCMethodCall)((Object)o);
            switch (call.getMethodId()) {
                case 13: {
                    fqn = this.extractFqnFromMethodCall(call);
                    break;
                }
                case 14: {
                    fqn = this.extractFqnFromListOfMethodCall(call);
                    break;
                }
                default: {
                    throw new IllegalStateException("LegacyTreeCacheMarshaller.objectToByteBuffer(): MethodCall name is either not  replicate or replicateAll but : " + call.getName());
                }
            }
        }
        catch (ClassCastException cce) {
            if (call == null) {
                this.log.debug((Object)("Received non-JBCMethodCall " + o + " -- cannot extract Fqn so using null"));
            }
            throw cce;
        }
        if (fqn == null) {
            fqn = "NULL";
        }
        oos.writeUTF(fqn);
        oos.writeObject(this.externMethodCall(o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object objectFromStreamImpl(ObjectInputStream ois) throws Exception {
        String fqn = ois.readUTF();
        ClassLoader oldTcl = null;
        Region region = null;
        if (fqn != null && !fqn.equals("NULL")) {
            region = this.getRegion(fqn);
            if (region != null) {
                if (region.getStatus() == 1) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("objectFromByteBuffer(): fqn: " + fqn + " is in the inactive default region"));
                    }
                    return MethodCallFactory.create(MethodDeclarations.notifyCallOnInactiveMethod, new Object[]{fqn});
                }
                ClassLoader cl = region.getClassLoader();
                if (cl != null) {
                    oldTcl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("objectFromByteBuffer(): fqn: " + fqn + " Will use customed class loader " + cl));
                    }
                }
            } else if (this.defaultInactive) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("objectFromByteBuffer(): fqn: " + fqn + " is in an inactive region"));
                }
                return MethodCallFactory.create(MethodDeclarations.notifyCallOnInactiveMethod, new Object[]{fqn});
            }
        }
        Object obj = null;
        try {
            obj = ois.readObject();
        }
        finally {
            if (oldTcl != null) {
                Thread.currentThread().setContextClassLoader(oldTcl);
            }
        }
        if (obj == null) {
            throw new MarshallingException("Read null object with fqn: " + fqn);
        }
        if (region != null && region.isQueueing()) {
            obj = MethodCallFactory.create(MethodDeclarations.enqueueMethodCallMethod, new Object[]{region.getFqn(), obj});
        }
        return obj;
    }

    String getColumnDump(byte[] buffer) {
        int col = 16;
        int length = buffer.length;
        int offs = 0;
        StringBuffer sb = new StringBuffer(length * 4);
        StringBuffer tx = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            byte b;
            if (i % col == 0) {
                sb.append(tx).append('\n');
                tx.setLength(0);
            }
            if (Character.isISOControl((char)(b = buffer[i + offs]))) {
                tx.append('.');
            } else {
                tx.append((char)b);
            }
            LegacyTreeCacheMarshaller.appendHex(sb, b);
            sb.append(' ');
        }
        int remain = col - length % col;
        if (remain != col) {
            for (int i = 0; i < remain * 3; ++i) {
                sb.append(' ');
            }
        }
        sb.append(tx);
        return sb.toString();
    }

    private static void appendHex(StringBuffer sb, byte b) {
        sb.append(Character.forDigit(b >> 4 & 0xF, 16));
        sb.append(Character.forDigit(b & 0xF, 16));
    }

    private JBCMethodCall internMethodCall(MethodCall call) {
        Object[] args = call.getArgs();
        JBCMethodCall result = MethodCallFactory.create(call.getMethod(), args);
        switch (result.getMethodId()) {
            case 13: 
            case 22: {
                args[0] = this.internMethodCall((MethodCall)args[0]);
                break;
            }
            case 14: {
                List mods0 = (List)args[0];
                ArrayList<JBCMethodCall> internMods0 = new ArrayList<JBCMethodCall>(mods0.size());
                Iterator iter = mods0.iterator();
                while (iter.hasNext()) {
                    internMods0.add(this.internMethodCall((MethodCall)iter.next()));
                }
                args[0] = internMods0;
                break;
            }
            case 10: 
            case 18: {
                List mods1 = (List)args[1];
                ArrayList<JBCMethodCall> internMods1 = new ArrayList<JBCMethodCall>(mods1.size());
                Iterator iter = mods1.iterator();
                while (iter.hasNext()) {
                    internMods1.add(this.internMethodCall((MethodCall)iter.next()));
                }
                args[1] = internMods1;
                break;
            }
            case 20: {
                args[1] = this.internMethodCall((MethodCall)args[1]);
                break;
            }
        }
        return result;
    }

    private Object externMethodCall(Object o) {
        Object toSerialize;
        block3: {
            block4: {
                block2: {
                    toSerialize = o;
                    if (!(o instanceof JBCMethodCall)) break block2;
                    JBCMethodCall call = (JBCMethodCall)o;
                    toSerialize = new MethodCall(call.getMethod(), (Object[])this.externMethodCall(call.getArgs()));
                    break block3;
                }
                if (!(o instanceof Object[])) break block4;
                Object[] orig = (Object[])o;
                toSerialize = new Object[orig.length];
                for (int i = 0; i < orig.length; ++i) {
                    ((Object[])toSerialize)[i] = this.externMethodCall(orig[i]);
                }
                break block3;
            }
            if (!(o instanceof List)) break block3;
            List orig = (List)o;
            toSerialize = new ArrayList(orig.size());
            for (int i = 0; i < orig.size(); ++i) {
                ((List)toSerialize).add(this.externMethodCall(orig.get(i)));
            }
        }
        return toSerialize;
    }
}

