/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
import java.util.Collections;
import java.util.Set;
import org.jboss.cache.lock.LockStrategy;
import org.jboss.cache.lock.OwnerNotExistedException;

public class LockMap {
    public static final int OWNER_ANY = 0;
    public static final int OWNER_READ = 1;
    public static final int OWNER_WRITE = 2;
    private Object writeOwner_ = null;
    private final Set readOwnerList_ = new CopyOnWriteArraySet();

    public boolean isOwner(Object caller, int ownership) {
        switch (ownership) {
            case 0: {
                return this.writeOwner_ != null && caller.equals(this.writeOwner_) || this.readOwnerList_.contains(caller);
            }
            case 1: {
                return this.readOwnerList_.contains(caller);
            }
            case 2: {
                return this.writeOwner_ != null && caller.equals(this.writeOwner_);
            }
        }
        return false;
    }

    public void addReader(Object owner) {
        this.readOwnerList_.add(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriterIfNotNull(Object owner) {
        LockMap lockMap = this;
        synchronized (lockMap) {
            if (this.writeOwner_ != null) {
                throw new IllegalStateException("there is already a writer holding the lock: " + this.writeOwner_);
            }
            this.writeOwner_ = owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object setWriter(Object owner) {
        Object old;
        LockMap lockMap = this;
        synchronized (lockMap) {
            old = this.writeOwner_;
            this.writeOwner_ = owner;
        }
        return old;
    }

    public boolean upgrade(Object owner) throws OwnerNotExistedException {
        boolean old_value = this.readOwnerList_.remove(owner);
        if (!old_value) {
            throw new OwnerNotExistedException("Can't upgrade lock. Read lock owner did not exist");
        }
        this.setWriter(owner);
        return true;
    }

    public Set readerOwners() {
        return Collections.unmodifiableSet(this.readOwnerList_);
    }

    public void releaseReaderOwners(LockStrategy lock) {
        int size = this.readOwnerList_.size();
        for (int i = 0; i < size; ++i) {
            lock.readLock().release();
        }
    }

    public Object writerOwner() {
        return this.writeOwner_;
    }

    public void removeReader(Object owner) {
        this.readOwnerList_.remove(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriter() {
        LockMap lockMap = this;
        synchronized (lockMap) {
            this.writeOwner_ = null;
        }
    }

    public void removeAll() {
        this.removeWriter();
        this.readOwnerList_.clear();
    }

    public String printInfo() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("Read lock owners: ").append(this.readOwnerList_).append('\n');
        buf.append("Write lock owner: ").append(this.writeOwner_).append('\n');
        return buf.toString();
    }

    public boolean isReadLocked() {
        return !this.readOwnerList_.isEmpty();
    }
}

