/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.benchmark;

import gnu.trove.benchmark.Operation;
import gnu.trove.benchmark.Result;
import gnu.trove.benchmark.Timer;

class Repeater
implements Timer {
    int _count;
    Operation _operation;

    Repeater(Operation o) {
        this._count = o.getIterationCount();
        this._operation = o;
    }

    public Result run() {
        long theirs = this.theirs();
        long ours = this.ours();
        Result r = new Result();
        r.setTheirs(theirs);
        r.setOurs(ours);
        r.setIterations(this._count);
        r.setDescription(this._operation.toString());
        return r;
    }

    public long theirs() {
        long then = System.currentTimeMillis();
        for (int i = 0; i < this._count; ++i) {
            this._operation.theirs();
        }
        long now = System.currentTimeMillis();
        return now - then;
    }

    public long ours() {
        long then = System.currentTimeMillis();
        for (int i = 0; i < this._count; ++i) {
            this._operation.ours();
        }
        long now = System.currentTimeMillis();
        return now - then;
    }

    public Operation getOperation() {
        return this._operation;
    }
}

