/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.ejb.session;

import com.clustercontrol.bean.Property;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;
import com.clustercontrol.jobmanagement.ejb.session.JobRunManagementLocal;
import com.clustercontrol.jobmanagement.ejb.session.JobRunManagementUtil;
import com.clustercontrol.jobmanagement.factory.JobOperationJudgment;
import com.clustercontrol.jobmanagement.factory.OperateMaintenanceOfJob;
import com.clustercontrol.jobmanagement.factory.OperateSkipOfJob;
import com.clustercontrol.jobmanagement.factory.OperateStartOfJob;
import com.clustercontrol.jobmanagement.factory.OperateStopOfJob;
import com.clustercontrol.jobmanagement.factory.OperateSuspendOfJob;
import com.clustercontrol.jobmanagement.factory.OperateWaitOfJob;
import com.clustercontrol.jobmanagement.factory.OperationJob;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import com.clustercontrol.quartzmanager.util.QuartzUtil;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

public abstract class JobRunManagementBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(JobRunManagementBean.class);
    public static final String GROUP_NAME = "JOB_MANAGEMENT";

    public void addQuartz(String cronString) throws NamingException, ParseException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.deleteSchedule("JobRunManagement", GROUP_NAME);
        }
        catch (SchedulerException e) {
            m_log.debug((Object)("addQuartz() : deleteJob error = " + e.getMessage()));
        }
        catch (RemoteException e) {
            // empty catch block
        }
        JobDetail job = new JobDetail("JobRunManagement", GROUP_NAME, EJBInvokerJob.class);
        String serverName = System.getProperty("jboss.server.name");
        if (serverName.equals("all")) {
            job.getJobDataMap().put("java.naming.provider.url", "jnp://localhost:1100");
        }
        job.setDurability(true);
        job.getJobDataMap().put("ejb", "JobRunManagement");
        job.getJobDataMap().put("method", "run");
        Object[] jdArgs = new Object[]{};
        job.getJobDataMap().put((Object)"args", (Object)jdArgs);
        CronTrigger cronTrigger = new CronTrigger("JobRunManagement", GROUP_NAME);
        cronTrigger.setMisfireInstruction(2);
        cronTrigger.setCronExpression(cronString);
        try {
            manager.addSchedule(job, (Trigger)cronTrigger);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void deleteQuartz() throws NamingException, ParseException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.deleteSchedule("JobRunManagement", GROUP_NAME);
        }
        catch (SchedulerException e) {
            m_log.debug((Object)("deleteQuartz() : deleteJob error = " + e.getMessage()));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void run() throws FinderException, NamingException {
        m_log.debug((Object)"run()");
        OperationJob operation = new OperationJob();
        operation.runJob();
        try {
            JobRunManagementLocal jobRunManagement = JobRunManagementUtil.getLocalHome().create();
            jobRunManagement.runWaitJob();
        }
        catch (FinderException e) {
            m_log.debug((Object)("run() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.debug((Object)("run() : " + e.getMessage()));
            throw e;
        }
        catch (CreateException e) {
            m_log.debug((Object)("run() : " + e.getMessage()));
        }
    }

    public void runWaitJob() throws NamingException, FinderException {
        m_log.debug((Object)"runWaitJob()");
        OperationJob operation = new OperationJob();
        operation.runWaitJob();
    }

    public void checkStoppingJob() throws NamingException, FinderException {
        m_log.debug((Object)"checkStoppingJob()");
        OperationJob operation = new OperationJob();
        operation.checkStoppingJob();
    }

    public void runJob(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("runJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        OperationJob operation = new OperationJob();
        operation.runJob(sessionId, jobId);
    }

    public void operationJob(Property property) throws FinderException, NamingException {
        m_log.debug((Object)"operationJob()");
        ArrayList values = PropertyUtil.getPropertyValue((Property)property, (String)"session");
        String sessionId = null;
        if (values.get(0) instanceof String && ((String)values.get(0)).length() > 0) {
            sessionId = (String)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"job");
        String jobId = null;
        if (values.get(0) instanceof String && ((String)values.get(0)).length() > 0) {
            jobId = (String)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"facility");
        String facilityId = null;
        if (values.size() > 0 && values.get(0) instanceof String && ((String)values.get(0)).length() > 0) {
            facilityId = (String)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"control");
        Integer control = null;
        if (values.get(0) instanceof String) {
            String controlString = (String)values.get(0);
            control = OperationConstant.stringToType(controlString);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"endValue");
        Integer endValue = null;
        if (values.size() > 0 && values.get(0) instanceof Integer) {
            endValue = (Integer)values.get(0);
        }
        int status = 0;
        int jobType = 0;
        try {
            JobSessionJobLocal sessionJob;
            if (facilityId != null && facilityId.length() > 0) {
                sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
                if (sessionJob.getJobInfo().getJob_type() == 3) {
                    jobId = jobId + "_" + facilityId;
                    facilityId = null;
                    JobSessionJobLocal childSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
                    status = childSessionJob.getStatus();
                    jobType = 0;
                } else {
                    JobSessionNodeLocal sessionNode = JobSessionNodeUtil.getLocalHome().findByPrimaryKey(new JobSessionNodePK(sessionId, jobId, facilityId));
                    status = sessionNode.getStatus();
                    jobType = 2;
                }
            } else {
                sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
                status = sessionJob.getStatus();
                jobType = sessionJob.getJobInfo().getJob_type() == 2 ? 1 : 0;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (JobOperationJudgment.judgment(control, jobType, status)) {
            AplLogger apllog;
            if (control == 1) {
                try {
                    new OperateStartOfJob().startJob(sessionId, jobId, facilityId);
                }
                catch (FinderException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId, facilityId};
                    apllog.put("SYS", "007", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
                catch (NamingException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId, facilityId};
                    apllog.put("SYS", "007", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
                catch (EJBException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId, facilityId};
                    apllog.put("SYS", "007", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
                catch (RemoveException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId, facilityId};
                    apllog.put("SYS", "007", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                }
            } else if (control == 3) {
                try {
                    new OperateSuspendOfJob().releaseSuspendJob(sessionId, jobId);
                }
                catch (FinderException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId};
                    apllog.put("SYS", "008", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
                catch (NamingException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId, facilityId};
                    apllog.put("SYS", "008", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
            } else if (control == 7) {
                try {
                    new OperateWaitOfJob().releaseWaitJob(sessionId, jobId);
                }
                catch (FinderException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId, facilityId};
                    apllog.put("SYS", "009", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
                catch (NamingException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId, facilityId};
                    apllog.put("SYS", "009", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
            } else if (control == 5) {
                try {
                    new OperateSkipOfJob().releaseSkipJob(sessionId, jobId);
                }
                catch (FinderException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId, facilityId};
                    apllog.put("SYS", "010", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
                catch (NamingException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId, facilityId};
                    apllog.put("SYS", "010", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
            } else if (control == 0) {
                try {
                    new OperateStopOfJob().stopJob(sessionId, jobId, facilityId);
                }
                catch (FinderException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId, facilityId};
                    apllog.put("SYS", "011", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
                catch (NamingException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId, facilityId};
                    apllog.put("SYS", "011", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
            } else if (control == 2) {
                try {
                    new OperateSuspendOfJob().suspendJob(sessionId, jobId);
                }
                catch (FinderException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId};
                    apllog.put("SYS", "012", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
                catch (NamingException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId};
                    apllog.put("SYS", "012", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
            } else if (control == 6) {
                try {
                    new OperateWaitOfJob().waitJob(sessionId, jobId);
                }
                catch (FinderException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId};
                    apllog.put("SYS", "012", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
                catch (NamingException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId};
                    apllog.put("SYS", "012", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
            } else if (control == 4) {
                if (endValue == null) {
                    throw new NullPointerException();
                }
                try {
                    new OperateSkipOfJob().skipJob(sessionId, jobId, endValue);
                }
                catch (FinderException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId};
                    apllog.put("SYS", "013", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
                catch (NamingException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId};
                    apllog.put("SYS", "013", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
            } else if (control == 8) {
                if (endValue == null) {
                    throw new NullPointerException();
                }
                try {
                    new OperateMaintenanceOfJob().maintenanceJob(sessionId, jobId, facilityId, endValue);
                }
                catch (FinderException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId, facilityId};
                    apllog.put("SYS", "014", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
                catch (NamingException e) {
                    apllog = new AplLogger("JOB", "job");
                    Object[] args = new String[]{sessionId, jobId, facilityId};
                    apllog.put("SYS", "014", args);
                    m_log.debug((Object)("operationJob() : " + e.getMessage()));
                    throw e;
                }
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public void endNode(RunResultInfo info) throws FinderException, NamingException {
        m_log.debug((Object)("endNode() : sessionId=" + info.getSessionId() + ", jobId=" + info.getJobId() + ", facilityId=" + info.getFacilityId()));
        OperationJob operation = new OperationJob();
        operation.endNode(info);
    }
}

