/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryCacheProperties {
    protected static Log m_log = LogFactory.getLog(RepositoryCacheProperties.class);
    public static final String FACILITY_IP_ADDRESS_KEY = "common.repository.cache.facility.ipaddress";
    public static final String FACILITY_NODE_NAME_KEY = "common.repository.cache.facility.nodename";
    public static final String FACILITY_TREE_FIND_ALL_KEY = "common.repository.cache.facilitytree.findall";
    public static final String FACILITY_TREE_FACILITY_ID_KEY = "common.repository.cache.facilitytree.facilityid";
    public static final String DEVICE_FACILITYID_KEY = "common.repository.cache.device.facilityid";
    public static final String FILESYSTEM_FACILITYID_KEY = "common.repository.cache.filesystem.facilityid";
    private static Properties m_properties;

    public static synchronized void init() {
        if (m_properties != null) {
            return;
        }
        m_properties = new Properties();
        try {
            String etcdir = System.getProperty("hinemos.manager.etc.dir");
            String propertyFile = etcdir + File.separator + "hinemos.properties";
            m_properties.load(new FileInputStream(propertyFile));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getProperties(String key) {
        if (m_properties == null) {
            RepositoryCacheProperties.init();
        }
        try {
            String property = m_properties.getProperty(key);
            if (property != null) {
                return Integer.parseInt(property);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }
}

