/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.factory;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyTreeItem;
import com.clustercontrol.repository.ejb.entity.DeviceInfoData;
import com.clustercontrol.repository.ejb.entity.DeviceInfoLocal;
import com.clustercontrol.repository.ejb.entity.DeviceInfoUtil;
import com.clustercontrol.repository.ejb.entity.FacilityData;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeUtil;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoData;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoLocal;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoUtil;
import com.clustercontrol.repository.factory.NodeProperty;
import com.clustercontrol.repository.util.ListSorter;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectFacility {
    protected static Log m_log = LogFactory.getLog(SelectFacility.class);
    public static final String SEPARATOR = ">";

    public Property getNodeProperty(FacilityData facilityData, Locale locale) throws CreateException, NamingException, FinderException {
        Property node = null;
        ArrayList propertyList = null;
        NodeProperty nodeProperty = new NodeProperty();
        node = nodeProperty.getProperty(2, locale);
        propertyList = PropertyUtil.getProperty((Property)node, (String)"facilityName");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getCn());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"characterSet");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getCharSet());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"createTimestamp");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getCreateTimestamp());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"creatorName");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getCreatorsName());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"description");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getDescription());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"dhcpClient");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getDhcpClient());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"facilityId");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getFacilityId());
        PropertyUtil.setPropertyValue((Property)node, (String)"hostName", (Object)facilityData.getHost());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"hostName");
        Property parentHost = (Property)((Property)propertyList.get(0)).getParent();
        if (facilityData.getHost() != null) {
            int index = PropertyUtil.getPropertyIndex((Property)parentHost, (Property)((Property)propertyList.get(0)));
            for (int i = 0; i < facilityData.getHost().size(); ++i) {
                if (i == 0) {
                    ((Property)propertyList.get(0)).setValue(facilityData.getHost().get(i));
                    continue;
                }
                Property copy = PropertyUtil.copy((Property)((Property)propertyList.get(0)));
                ((Property)propertyList.get(0)).setValue(facilityData.getHost().get(i));
                parentHost.addChildren((PropertyTreeItem)copy, index + i);
            }
        }
        propertyList = PropertyUtil.getProperty((Property)node, (String)"ipAddressVersion");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getIpProtocolNumber());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"ipAddressV4");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getIpNetworkNumber());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"ipAddressV6");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getIpNetworkNumberV6());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"ipAddressType");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getIpType());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"hardwareType");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getMachine());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"contact");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getManagerContact());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"administrator");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getManagerName());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"ModifierName");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getModifiersName());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"ModifyTime");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getModifyTimestamp());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"nodeName");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getNodeName());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"osName");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getOsName());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"osRelease");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getOsRelease());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"osVersion");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getOsVersion());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"platformFamilyName");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getPlatform());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"snmpPort");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getSnmpPort());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"snmpCommunity");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getSnmpCommunity());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"snmpVersion");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getSnmpVersion());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"valid");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getValid());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"snmpTimeout");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getSnmpTimeout());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"snmpRetries");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getSnmpRetries());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"snmpProxy");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getSnmpProxy());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"wbemUser");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getWbemUser());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"wbemUserPassword");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getWbemUserPassword());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"wbemPort");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getWbemPort());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"wbemProtocol");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getWbemProtocol());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"wbemTimeout");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getWbemTimeout());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"wbemRetries");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getWbemRetries());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"iconImage");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getIconImage());
        PropertyUtil.setPropertyValue((Property)node, (String)"note", (Object)facilityData.getNote());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"note");
        Property parentNote = (Property)((Property)propertyList.get(0)).getParent();
        if (facilityData.getNote() != null) {
            int index = PropertyUtil.getPropertyIndex((Property)parentNote, (Property)((Property)propertyList.get(0)));
            for (int i = 0; i < facilityData.getNote().size(); ++i) {
                if (i == 0) {
                    ((Property)propertyList.get(0)).setValue(facilityData.getNote().get(i));
                    continue;
                }
                Property copy = PropertyUtil.copy((Property)((Property)propertyList.get(0)));
                ((Property)propertyList.get(0)).setValue(facilityData.getNote().get(i));
                parentNote.addChildren((PropertyTreeItem)copy, index + i);
            }
        }
        propertyList = PropertyUtil.getProperty((Property)node, (String)"virtualizationNodeType");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getVirtNodeType());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"vMManagementNode");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getVMManagementNode());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"VMINDEX");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getVmIndex());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"VMName");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getVmName());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"virtualizationSolution");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getVirtSolution());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"vmId");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getVmId());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"vmUser");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getVmUser());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"vmUserPassword");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getVmUserpassword());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"vmProtocol");
        ((Property)propertyList.get(0)).setValue((Object)facilityData.getVmProtocol());
        propertyList = PropertyUtil.getProperty((Property)node, (String)"device");
        Property deviceProperty = (Property)propertyList.get(0);
        int index = PropertyUtil.getPropertyIndex((Property)node, (Property)deviceProperty);
        Collection deviceList = null;
        deviceList = facilityData.getDeviceInfo();
        if (deviceList != null) {
            Iterator itr = deviceList.iterator();
            int i = 0;
            while (itr.hasNext()) {
                DeviceInfoData d = (DeviceInfoData)itr.next();
                if (i == 0) {
                    deviceProperty.setValue((Object)d.getDisplayName());
                    propertyList = PropertyUtil.getProperty((Property)deviceProperty, (String)"deviceDisplayName");
                    if (d.getDisplayName() != null && d.getDisplayName().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)d.getDisplayName());
                    }
                    propertyList = PropertyUtil.getProperty((Property)deviceProperty, (String)"deviceName");
                    if (d.getDeviceName() != null && d.getDeviceName().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)d.getDeviceName());
                    }
                    propertyList = PropertyUtil.getProperty((Property)deviceProperty, (String)"deviceOID");
                    if (d.getSnmpOID() != null && d.getSnmpOID().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)d.getSnmpOID());
                    }
                    propertyList = PropertyUtil.getProperty((Property)deviceProperty, (String)"deviceIndex");
                    if (d.getDeviceIndex() != null) {
                        ((Property)propertyList.get(0)).setValue((Object)d.getDeviceIndex());
                    }
                    propertyList = PropertyUtil.getProperty((Property)deviceProperty, (String)"deviceType");
                    if (d.getDeviceType() != null && d.getDeviceType().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)d.getDeviceType());
                    }
                    propertyList = PropertyUtil.getProperty((Property)deviceProperty, (String)"deviceDescription");
                    if (d.getDescription() != null && d.getDescription().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)d.getDescription());
                    }
                    m_log.debug((Object)"i==0");
                    m_log.debug((Object)("d.getDisplayName() = " + d.getDisplayName()));
                    m_log.debug((Object)("d.getDeviceName() = " + d.getDeviceName()));
                    m_log.debug((Object)("d.getSnmpOID() = " + d.getSnmpOID()));
                    m_log.debug((Object)("d.getDeviceIndex() = " + d.getDeviceIndex()));
                    m_log.debug((Object)("d.getDeviceType() = " + d.getDeviceType()));
                    m_log.debug((Object)("d.getDescription() = " + d.getDescription()));
                    m_log.debug((Object)("d.getFacilityId() = " + d.getFacilityId()));
                    m_log.debug((Object)("d.getCn() = " + d.getCn()));
                    m_log.debug((Object)("d.getDn() = " + d.getDn()));
                } else {
                    Property copy = PropertyUtil.copy((Property)deviceProperty);
                    copy.setValue((Object)d.getDisplayName());
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"deviceDisplayName");
                    if (d.getDisplayName() != null && d.getDisplayName().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)d.getDisplayName());
                    }
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"deviceName");
                    if (d.getDeviceName() != null && d.getDeviceName().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)d.getDeviceName());
                    }
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"deviceOID");
                    if (d.getSnmpOID() != null && d.getSnmpOID().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)d.getSnmpOID());
                    }
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"deviceIndex");
                    if (d.getDeviceIndex() != null) {
                        ((Property)propertyList.get(0)).setValue((Object)d.getDeviceIndex());
                    }
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"deviceType");
                    if (d.getDeviceType() != null && d.getDeviceType().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)d.getDeviceType());
                    }
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"deviceDescription");
                    if (d.getDescription() != null && d.getDescription().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)d.getDescription());
                    }
                    node.addChildren((PropertyTreeItem)copy, index + i);
                    m_log.debug((Object)"i!=0");
                    m_log.debug((Object)("d.getDisplayName() = " + d.getDisplayName()));
                    m_log.debug((Object)("d.getDeviceName() = " + d.getDeviceName()));
                    m_log.debug((Object)("d.getSnmpOID() = " + d.getSnmpOID()));
                    m_log.debug((Object)("d.getDeviceIndex() = " + d.getDeviceIndex()));
                    m_log.debug((Object)("d.getDeviceType() = " + d.getDeviceType()));
                    m_log.debug((Object)("d.getDescription() = " + d.getDescription()));
                    m_log.debug((Object)("d.getFacilityId() = " + d.getFacilityId()));
                    m_log.debug((Object)("d.getCn() = " + d.getCn()));
                    m_log.debug((Object)("d.getDn() = " + d.getDn()));
                }
                ++i;
            }
        }
        propertyList = PropertyUtil.getProperty((Property)node, (String)"fileSystem");
        Property fileSystemProperty = (Property)propertyList.get(0);
        index = PropertyUtil.getPropertyIndex((Property)node, (Property)fileSystemProperty);
        Collection fileSystemList = null;
        fileSystemList = facilityData.getFileSystemInfo();
        if (fileSystemList != null) {
            Iterator itr = fileSystemList.iterator();
            int i = 0;
            while (itr.hasNext()) {
                FileSystemInfoData fs = (FileSystemInfoData)itr.next();
                if (i == 0) {
                    fileSystemProperty.setValue((Object)fs.getDisplayName());
                    propertyList = PropertyUtil.getProperty((Property)fileSystemProperty, (String)"fileSystemDisplayName");
                    if (fs.getDisplayName() != null && fs.getDisplayName().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)fs.getDisplayName());
                    }
                    propertyList = PropertyUtil.getProperty((Property)fileSystemProperty, (String)"fileSystemIndex");
                    if (fs.getCn() != null) {
                        ((Property)propertyList.get(0)).setValue((Object)fs.getCn());
                    }
                    propertyList = PropertyUtil.getProperty((Property)fileSystemProperty, (String)"fileSystemMountPoint");
                    if (fs.getFileSystemMountPoint() != null && fs.getFileSystemMountPoint().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)fs.getFileSystemMountPoint());
                    }
                    propertyList = PropertyUtil.getProperty((Property)fileSystemProperty, (String)"fileSystemOID");
                    if (fs.getSnmpOID() != null && fs.getSnmpOID().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)fs.getSnmpOID());
                    }
                    propertyList = PropertyUtil.getProperty((Property)fileSystemProperty, (String)"fileSystemType");
                    if (fs.getFileSystemType() != null && fs.getFileSystemType().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)fs.getFileSystemType());
                    }
                    propertyList = PropertyUtil.getProperty((Property)fileSystemProperty, (String)"fileSystemDescription");
                    if (fs.getDescription() != null && fs.getDescription().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)fs.getDescription());
                    }
                    m_log.info((Object)"i==0");
                    m_log.info((Object)("fs.getDisplayName() = " + fs.getDisplayName()));
                    m_log.info((Object)("fs.getCn() = " + fs.getCn()));
                    m_log.info((Object)("fs.getFileSystemMountPoint() = " + fs.getFileSystemMountPoint()));
                    m_log.info((Object)("fs.getSnmpOID() = " + fs.getSnmpOID()));
                    m_log.info((Object)("fs.getFileSystemType() = " + fs.getFileSystemType()));
                    m_log.info((Object)("fs.getDescription() = " + fs.getDescription()));
                    m_log.info((Object)("fs.getDn() = " + fs.getDn()));
                    m_log.info((Object)("fs.getFacilityId() = " + fs.getFacilityId()));
                } else {
                    Property copy = PropertyUtil.copy((Property)fileSystemProperty);
                    copy.setValue((Object)fs.getDisplayName());
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"fileSystemDisplayName");
                    if (fs.getDisplayName() != null && fs.getDisplayName().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)fs.getDisplayName());
                    }
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"fileSystemIndex");
                    if (fs.getCn() != null) {
                        ((Property)propertyList.get(0)).setValue((Object)fs.getCn());
                    }
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"fileSystemMountPoint");
                    if (fs.getFileSystemMountPoint() != null && fs.getFileSystemMountPoint().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)fs.getFileSystemMountPoint());
                    }
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"fileSystemOID");
                    if (fs.getSnmpOID() != null && fs.getSnmpOID().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)fs.getSnmpOID());
                    }
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"fileSystemType");
                    if (fs.getFileSystemType() != null && fs.getFileSystemType().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)fs.getFileSystemType());
                    }
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"fileSystemDescription");
                    if (fs.getDescription() != null && fs.getDescription().compareTo("") != 0) {
                        ((Property)propertyList.get(0)).setValue((Object)fs.getDescription());
                    }
                    node.addChildren((PropertyTreeItem)copy, index + i);
                    m_log.info((Object)"i!=0");
                    m_log.info((Object)("fs.getDisplayName() = " + fs.getDisplayName()));
                    m_log.info((Object)("fs.getCn() = " + fs.getCn()));
                    m_log.info((Object)("fs.getFileSystemMountPoint() = " + fs.getFileSystemMountPoint()));
                    m_log.info((Object)("fs.getSnmpOID() = " + fs.getSnmpOID()));
                    m_log.info((Object)("fs.getFileSystemType() = " + fs.getFileSystemType()));
                    m_log.info((Object)("fs.getDescription() = " + fs.getDescription()));
                    m_log.info((Object)("fs.getDn() = " + fs.getDn()));
                    m_log.info((Object)("fs.getFacilityId() = " + fs.getFacilityId()));
                }
                ++i;
            }
        }
        return node;
    }

    public FacilityData getNodeFacilityData(String facilityId) throws FinderException, NamingException {
        FacilityData data = null;
        try {
            FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
            data = new FacilityData();
            data.setType(facility.getType());
            data.setDn(facility.getDn());
            data.setAgentControl(facility.getAgentControl());
            data.setAgentWatch(facility.getAgentWatch());
            data.setAgentWatchStatus(facility.getAgentWatchStatus());
            data.setCharSet(facility.getCharSet());
            data.setCn(facility.getCn());
            data.setCreateTimestamp(facility.getCreateTimestamp());
            data.setCreatorsName(facility.getCreatorsName());
            data.setDescription(facility.getDescription());
            data.setDhcpClient(facility.getDhcpClient());
            data.setFacilityId(facility.getFacilityId());
            data.setHost(facility.getHost());
            data.setIpNetworkNumber(facility.getIpNetworkNumber());
            data.setIpNetworkNumberV6(facility.getIpNetworkNumberV6());
            data.setIpProtocolNumber(facility.getIpProtocolNumber());
            data.setIpType(facility.getIpType());
            data.setLogWatch(facility.getLogWatch());
            data.setMachine(facility.getMachine());
            data.setManagerContact(facility.getManagerContact());
            data.setManagerName(facility.getManagerName());
            data.setModifiersName(facility.getModifiersName());
            data.setModifyTimestamp(facility.getModifyTimestamp());
            data.setNodeName(facility.getNodeName());
            data.setOsName(facility.getOsName());
            data.setOsRelease(facility.getOsRelease());
            data.setOsVersion(facility.getOsVersion());
            data.setPingWatch(facility.getPingWatch());
            data.setPingWatchStatus(facility.getPingWatchStatus());
            data.setPlatform(facility.getPlatform());
            data.setStatusWatch(facility.getStatusWatch());
            data.setSnmpPort(facility.getSnmpPort());
            data.setSnmpCommunity(facility.getSnmpCommunity());
            data.setSnmpVersion(facility.getSnmpVersion());
            data.setSortValue(facility.getSortValue());
            data.setValid(facility.getValid());
            data.setSnmpTimeout(facility.getSnmpTimeout());
            data.setSnmpRetries(facility.getSnmpRetries());
            data.setSnmpProxy(facility.getSnmpProxy());
            data.setIconImage(facility.getIconImage());
            data.setNote(facility.getNote());
            data.setVirtNodeType(facility.getVirtNodeType());
            data.setVMManagementNode(facility.getVMManagementNode());
            data.setVmIndex(facility.getVmIndex());
            data.setVmName(facility.getVmName());
            data.setVirtSolution(facility.getVirtSolution());
            data.setVmId(facility.getVmId());
            data.setVmUser(facility.getVmUser());
            data.setVmUserpassword(facility.getVmUserpassword());
            data.setVmProtocol(facility.getVmProtocol());
            data.setWbemPort(facility.getWbemPort());
            data.setWbemProtocol(facility.getWbemProtocol());
            data.setWbemRetries(facility.getWbemRetries());
            data.setWbemTimeout(facility.getWbemTimeout());
            data.setWbemUser(facility.getWbemUser());
            data.setWbemUserPassword(facility.getWbemUserPassword());
            data.setDeviceInfo(this.getDeviceList(facilityId));
            data.setFileSystemInfo(this.getFileSystemList(facilityId));
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return data;
    }

    public ArrayList<FileSystemInfoData> getFileSystemList(String facilityId) throws FinderException, NamingException {
        ArrayList<FileSystemInfoData> list = null;
        try {
            Collection ct = FileSystemInfoUtil.getLocalHome().findByFacilityId(facilityId);
            list = new ArrayList<FileSystemInfoData>();
            for (FileSystemInfoLocal f : ct) {
                FileSystemInfoData data = new FileSystemInfoData(f.getDn(), f.getCn(), f.getFacilityId(), f.getDescription(), f.getFileSystemMountPoint(), f.getFileSystemType(), f.getSnmpOID(), f.getDisplayName());
                list.add(data);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public HashMap getNodeDetail(String facilityId, ArrayList attributes) throws FinderException, NamingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
            for (int i = 0; i < attributes.size(); ++i) {
                String attribute = (String)attributes.get(i);
                if (attribute.compareTo("ccFacilityId") == 0) {
                    map.put(attribute, facility.getFacilityId());
                    continue;
                }
                if (attribute.compareTo("cn") == 0) {
                    map.put(attribute, facility.getCn());
                    continue;
                }
                if (attribute.compareTo("description") == 0) {
                    map.put(attribute, facility.getDescription());
                    continue;
                }
                if (attribute.compareTo("ccAgentControl") == 0) {
                    map.put(attribute, facility.getAgentControl());
                    continue;
                }
                if (attribute.compareTo("ccAgentWatch") == 0) {
                    map.put(attribute, facility.getAgentWatch());
                    continue;
                }
                if (attribute.compareTo("ccAgentWatchStatus") == 0) {
                    map.put(attribute, facility.getAgentWatchStatus());
                    continue;
                }
                if (attribute.compareTo("ccCharSet") == 0) {
                    map.put(attribute, facility.getCharSet());
                    continue;
                }
                if (attribute.compareTo("ccCreateTimestamp") == 0) {
                    map.put(attribute, facility.getCreateTimestamp());
                    continue;
                }
                if (attribute.compareTo("ccCreatorsName") == 0) {
                    map.put(attribute, facility.getCreatorsName());
                    continue;
                }
                if (attribute.compareTo("ccDhcpClient") == 0) {
                    map.put(attribute, facility.getDhcpClient());
                    continue;
                }
                if (attribute.compareTo("host") == 0) {
                    map.put(attribute, facility.getHost());
                    continue;
                }
                if (attribute.compareTo("ipNetworkNumber") == 0) {
                    map.put(attribute, facility.getIpNetworkNumber());
                    continue;
                }
                if (attribute.compareTo("ccIpNetworkNumberV6") == 0) {
                    map.put(attribute, facility.getIpNetworkNumberV6());
                    continue;
                }
                if (attribute.compareTo("ipProtocolNumber") == 0) {
                    map.put(attribute, facility.getIpProtocolNumber());
                    continue;
                }
                if (attribute.compareTo("ccIpType") == 0) {
                    map.put(attribute, facility.getIpType());
                    continue;
                }
                if (attribute.compareTo("ccLogWatch") == 0) {
                    map.put(attribute, facility.getLogWatch());
                    continue;
                }
                if (attribute.compareTo("ccMachine") == 0) {
                    map.put(attribute, facility.getMachine());
                    continue;
                }
                if (attribute.compareTo("ccManagerContact") == 0) {
                    map.put(attribute, facility.getManagerContact());
                    continue;
                }
                if (attribute.compareTo("ccManagerName") == 0) {
                    map.put(attribute, facility.getManagerName());
                    continue;
                }
                if (attribute.compareTo("ccModifiersName") == 0) {
                    map.put(attribute, facility.getModifiersName());
                    continue;
                }
                if (attribute.compareTo("ccModifyTimestamp") == 0) {
                    map.put(attribute, facility.getModifyTimestamp());
                    continue;
                }
                if (attribute.compareTo("ccNodeName") == 0) {
                    map.put(attribute, facility.getNodeName());
                    continue;
                }
                if (attribute.compareTo("ccOsName") == 0) {
                    map.put(attribute, facility.getOsName());
                    continue;
                }
                if (attribute.compareTo("ccOsRelease") == 0) {
                    map.put(attribute, facility.getOsRelease());
                    continue;
                }
                if (attribute.compareTo("ccOsVersion") == 0) {
                    map.put(attribute, facility.getOsVersion());
                    continue;
                }
                if (attribute.compareTo("ccPingWatch") == 0) {
                    map.put(attribute, facility.getPingWatch());
                    continue;
                }
                if (attribute.compareTo("ccPingWatchStatus") == 0) {
                    map.put(attribute, facility.getPingWatchStatus());
                    continue;
                }
                if (attribute.compareTo("ccPlatform") == 0) {
                    map.put(attribute, facility.getPlatform());
                    continue;
                }
                if (attribute.compareTo("ccStatusWatch") == 0) {
                    map.put(attribute, facility.getStatusWatch());
                    continue;
                }
                if (attribute.compareTo("ccFacilitySortValue") == 0) {
                    map.put(attribute, facility.getSortValue());
                    continue;
                }
                if (attribute.compareTo("ccSnmpCommunity") == 0) {
                    map.put(attribute, facility.getSnmpCommunity());
                    continue;
                }
                if (attribute.compareTo("ccSnmpPort") == 0) {
                    map.put(attribute, facility.getSnmpPort());
                    continue;
                }
                if (attribute.compareTo("ccSnmpVersion") == 0) {
                    map.put(attribute, facility.getSnmpVersion());
                    continue;
                }
                if (attribute.compareTo("ccValid") == 0) {
                    map.put(attribute, facility.getValid());
                    continue;
                }
                if (attribute.compareTo("ccSnmpTimeout") == 0) {
                    map.put(attribute, facility.getSnmpTimeout());
                    continue;
                }
                if (attribute.compareTo("ccSnmpRetries") == 0) {
                    map.put(attribute, facility.getSnmpRetries());
                    continue;
                }
                if (attribute.compareTo("ccSnmpProxy") == 0) {
                    map.put(attribute, facility.getSnmpProxy());
                    continue;
                }
                if (attribute.compareTo("ccNote") == 0) {
                    map.put(attribute, facility.getNote());
                    continue;
                }
                if (attribute.compareTo("ccIconImage") == 0) {
                    map.put(attribute, facility.getIconImage());
                    continue;
                }
                if (attribute.compareTo("ccVirtualizationNodeType") == 0) {
                    map.put(attribute, facility.getVirtNodeType());
                    continue;
                }
                if (attribute.compareTo("ccVMManagementNode") == 0) {
                    map.put(attribute, facility.getVMManagementNode());
                    continue;
                }
                if (attribute.compareTo("ccVMINDEX") == 0) {
                    map.put(attribute, facility.getVmIndex());
                    continue;
                }
                if (attribute.compareTo("ccVMName") == 0) {
                    map.put(attribute, facility.getVmName());
                    continue;
                }
                if (attribute.compareTo("ccVirtualizationSolution") == 0) {
                    map.put(attribute, facility.getVirtSolution());
                    continue;
                }
                if (attribute.compareTo("ccVMId") == 0) {
                    map.put(attribute, facility.getVmId());
                    continue;
                }
                if (attribute.compareTo("ccVMUser") == 0) {
                    map.put(attribute, facility.getVmUser());
                    continue;
                }
                if (attribute.compareTo("ccVMUserPassword") == 0) {
                    map.put(attribute, facility.getVmUserpassword());
                    continue;
                }
                if (attribute.compareTo("ccVMProtocol") == 0) {
                    map.put(attribute, facility.getVmProtocol());
                    continue;
                }
                if (attribute.compareTo("ccWbemUser") == 0) {
                    map.put(attribute, facility.getWbemUser());
                    continue;
                }
                if (attribute.compareTo("ccWbemUserPassword") == 0) {
                    map.put(attribute, facility.getWbemUserPassword());
                    continue;
                }
                if (attribute.compareTo("ccWbemPort") == 0) {
                    map.put(attribute, facility.getWbemPort());
                    continue;
                }
                if (attribute.compareTo("ccWbemProtocol") == 0) {
                    map.put(attribute, facility.getWbemProtocol());
                    continue;
                }
                if (attribute.compareTo("ccWbemTimeout") == 0) {
                    map.put(attribute, facility.getWbemTimeout());
                    continue;
                }
                if (attribute.compareTo("ccWbemRetries") != 0) continue;
                map.put(attribute, facility.getWbemRetries());
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return map;
    }

    public HashMap getNodeDetail(ArrayList facilityIdList, ArrayList attributes) throws FinderException, NamingException {
        HashMap<String, HashMap> map = new HashMap<String, HashMap>();
        for (int i = 0; i < facilityIdList.size(); ++i) {
            String facilityId = (String)facilityIdList.get(i);
            HashMap detailMap = this.getNodeDetail(facilityId, attributes);
            map.put(facilityId, detailMap);
        }
        return map;
    }

    public ArrayList<DeviceInfoData> getDeviceList(String facilityId) throws FinderException, NamingException {
        ArrayList<DeviceInfoData> list = null;
        try {
            DeviceInfoData data;
            Collection ct = DeviceInfoUtil.getLocalHome().findByFacilityId(facilityId);
            list = new ArrayList<DeviceInfoData>();
            for (DeviceInfoLocal d : ct) {
                data = new DeviceInfoData(d.getDn(), d.getCn(), d.getFacilityId(), d.getDescription(), d.getDeviceIndex(), d.getDeviceName(), d.getDeviceType(), d.getSnmpOID(), d.getDisplayName());
                list.add(data);
            }
            ct = FileSystemInfoUtil.getLocalHome().findByFacilityId(facilityId);
            for (FileSystemInfoLocal f : ct) {
                data = new DeviceInfoData(f.getDn(), f.getCn().toString(), f.getFacilityId(), f.getDescription(), f.getCn(), f.getFileSystemMountPoint(), "filesystem", f.getSnmpOID(), f.getDisplayName());
                list.add(data);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getNodeList() throws FinderException, NamingException {
        ArrayList list = null;
        try {
            Collection ct = FacilityUtil.getLocalHome().findAllNode();
            list = new ArrayList();
            for (FacilityLocal ft : ct) {
                ArrayList<String> info = new ArrayList<String>();
                info.add(ft.getFacilityId());
                info.add(ft.getCn());
                info.add(ft.getDescription());
                list.add(info);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getNodeList(String parentFacilityId, int level) throws FinderException, NamingException {
        ArrayList list = null;
        try {
            Collection ct = null;
            ct = level == 0 ? FacilityTreeUtil.getLocalHome().findAllNode(parentFacilityId) : FacilityTreeUtil.getLocalHome().findOneLevelNode(parentFacilityId);
            HashMap<String, String> map = new HashMap<String, String>();
            list = new ArrayList();
            for (FacilityTreeLocal ft : ct) {
                if (map.get(ft.getFacilityId()) != null) continue;
                map.put(ft.getFacilityId(), "1");
                FacilityLocal facility = ft.getFacility();
                ArrayList<String> info = new ArrayList<String>();
                info.add(facility.getFacilityId());
                info.add(facility.getCn());
                info.add(facility.getDescription());
                list.add(info);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getNodeList(Property property) throws FinderException, NamingException {
        ArrayList list = null;
        try {
            ArrayList values = null;
            values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityId");
            String facilityId = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityName");
            String facilityName = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"description");
            String description = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressV4");
            String ipAddressV4 = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressV6");
            String ipAddressV6 = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"osName");
            String osName = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"osRelease");
            String osRelease = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"administrator");
            String managerName = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"contact");
            String managerContact = (String)values.get(0);
            Collection ct = FacilityUtil.getLocalHome().findNode(facilityId, facilityName, description, ipAddressV4, ipAddressV6, osName, osRelease, managerName, managerContact);
            list = new ArrayList();
            for (FacilityLocal ft : ct) {
                ArrayList<String> info = new ArrayList<String>();
                info.add(ft.getFacilityId());
                info.add(ft.getCn());
                info.add(ft.getDescription());
                list.add(info);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getFacilityIdList(String parentFacilityId, int level, boolean sort) throws FinderException, NamingException {
        ArrayList<String> list = null;
        try {
            Collection ct = null;
            ct = level == 0 ? FacilityTreeUtil.getLocalHome().findAll(parentFacilityId) : FacilityTreeUtil.getLocalHome().findOneLevel(parentFacilityId);
            HashMap<String, String> map = new HashMap<String, String>();
            list = new ArrayList<String>();
            Iterator itr = ct.iterator();
            int i = 0;
            while (itr.hasNext()) {
                FacilityTreeLocal ft;
                if (i == 0) {
                    if (i == 0 && parentFacilityId != null && parentFacilityId.compareTo("") != 0 && map.get(parentFacilityId) == null) {
                        map.put(parentFacilityId, "1");
                        list.add(parentFacilityId);
                    }
                    ++i;
                }
                if (map.get((ft = (FacilityTreeLocal)itr.next()).getFacilityId()) != null) continue;
                map.put(ft.getFacilityId(), "1");
                list.add(ft.getFacilityId());
            }
            if (sort) {
                ListSorter sorter = new ListSorter();
                sorter.sort(list);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getNodeFacilityIdList(String parentFacilityId, int level, boolean sort, Boolean valid) throws FinderException, NamingException {
        ArrayList<String> list = null;
        try {
            Collection ct = null;
            ct = level == 0 ? (valid == null ? FacilityTreeUtil.getLocalHome().findAllNode(parentFacilityId) : FacilityTreeUtil.getLocalHome().findAllNodeByValid(parentFacilityId, valid)) : (valid == null ? FacilityTreeUtil.getLocalHome().findOneLevelNode(parentFacilityId) : FacilityTreeUtil.getLocalHome().findOneLevelNodeByValid(parentFacilityId, valid));
            HashMap<String, String> map = new HashMap<String, String>();
            list = new ArrayList<String>();
            for (FacilityTreeLocal ft : ct) {
                if (map.get(ft.getFacilityId()) != null) continue;
                map.put(ft.getFacilityId(), "1");
                list.add(ft.getFacilityId());
            }
            if (sort) {
                ListSorter sorter = new ListSorter();
                sorter.sort(list);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getNodeFacilityIdList(boolean sort) throws FinderException, NamingException {
        ArrayList<String> list = null;
        try {
            Collection ct = FacilityUtil.getLocalHome().findAllNode();
            list = new ArrayList<String>();
            for (FacilityLocal ft : ct) {
                list.add(ft.getFacilityId());
            }
            if (sort) {
                ListSorter sorter = new ListSorter();
                sorter.sort(list);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getScopeList(String parentFacilityId) throws FinderException, NamingException {
        ArrayList list = null;
        try {
            Collection ct = FacilityTreeUtil.getLocalHome().findOneLevel(parentFacilityId);
            list = new ArrayList();
            for (FacilityTreeLocal ft : ct) {
                FacilityLocal facility = ft.getFacility();
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(facility.getFacilityId());
                info.add(facility.getCn());
                info.add(facility.getDescription());
                info.add(ft.getSortValue());
                list.add(info);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public FacilityLocal getFacility(String facilityId) throws FinderException, NamingException {
        FacilityLocal facility = null;
        try {
            facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return facility;
    }

    public ArrayList getNodeScopeList(String facilityId) throws FinderException, NamingException {
        ArrayList list = null;
        try {
            Collection ct = FacilityTreeUtil.getLocalHome().findByFacilityId(facilityId);
            FacilityTreeItem item = this.getFacilityTree(Locale.getDefault(), null);
            list = new ArrayList();
            for (FacilityTreeLocal ft : ct) {
                String[] dn = ft.getDn().split(",");
                StringBuffer path = new StringBuffer();
                for (int i = 1; i < dn.length - 1; ++i) {
                    String id = dn[i].replaceFirst("[\\s\\w]*=", "");
                    FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(id);
                    if (facility.getType() == 0) {
                        path.insert(0, SEPARATOR);
                    }
                    path.insert(0, facility.getCn());
                }
                ArrayList<String> info = new ArrayList<String>();
                info.add(path.toString());
                list.add(info);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public FacilityTreeItem getFacilityTree(Locale locale, Boolean valid) throws FinderException, NamingException {
        FacilityInfo info = new FacilityInfo();
        info.setFacilityName("");
        info.setType(2);
        FacilityTreeItem tree = new FacilityTreeItem(null, info);
        info = new FacilityInfo();
        info.setFacilityName(Messages.getString((String)"scope", (Locale)locale));
        info.setType(2);
        FacilityTreeItem item = new FacilityTreeItem(tree, info);
        try {
            Collection ct = FacilityTreeUtil.getLocalHome().findOneLevel();
            for (FacilityTreeLocal ft : ct) {
                this.createFacilityTree(ft, item, valid);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return tree;
    }

    public FacilityTreeItem getScopeFacilityTree(Locale locale) throws FinderException, NamingException {
        FacilityInfo info = new FacilityInfo();
        info.setFacilityName("");
        info.setType(2);
        FacilityTreeItem tree = new FacilityTreeItem(null, info);
        info = new FacilityInfo();
        info.setFacilityName(Messages.getString((String)"scope", (Locale)locale));
        info.setType(2);
        FacilityTreeItem item = new FacilityTreeItem(tree, info);
        try {
            Collection ct = FacilityTreeUtil.getLocalHome().findOneLevelScope(null);
            for (FacilityTreeLocal ft : ct) {
                this.createScopeFacilityTree(ft, item);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return tree;
    }

    protected void createFacilityTree(FacilityTreeLocal facilityTree, FacilityTreeItem parent, Boolean valid) {
        FacilityLocal facility = null;
        try {
            facility = facilityTree.getFacility();
        }
        catch (FinderException e) {
            return;
        }
        FacilityInfo info = null;
        FacilityTreeItem item = null;
        if (facility != null) {
            info = new FacilityInfo();
            info.setFacilityId(facility.getFacilityId());
            info.setFacilityName(facility.getCn());
            if (facility.getType() == 1) {
                m_log.debug((Object)("createFacilityTree() : facilityId = " + facility.getFacilityId() + ", facilityValid = " + facility.getValid() + ", valid = " + valid));
                if (valid != null && facility.getValid() ^ valid) {
                    return;
                }
                info.setType(1);
            } else {
                info.setType(0);
            }
            info.setSortOrder(facilityTree.getSortValue().intValue());
            info.setBuiltInFlg(facilityTree.isBuiltIn());
            info.setValid(facilityTree.getValid().booleanValue());
            item = new FacilityTreeItem(parent, info);
        }
        Collection collection = null;
        try {
            collection = facilityTree.getChildren();
        }
        catch (FinderException e) {
            // empty catch block
        }
        if (collection != null && collection.size() > 0) {
            for (FacilityTreeLocal children : collection) {
                this.createFacilityTree(children, item, valid);
            }
        }
    }

    protected void createScopeFacilityTree(FacilityTreeLocal facilityTree, FacilityTreeItem parent) {
        FacilityLocal facility = null;
        try {
            facility = facilityTree.getFacility();
        }
        catch (FinderException e) {
            return;
        }
        FacilityInfo info = null;
        FacilityTreeItem item = null;
        if (facility != null) {
            info = new FacilityInfo();
            info.setFacilityId(facility.getFacilityId());
            info.setFacilityName(facility.getCn());
            info.setSortOrder(facilityTree.getSortValue().intValue());
            if (facility.getType() == 0) {
                info.setType(0);
                item = new FacilityTreeItem(parent, info);
            } else {
                return;
            }
        }
        Collection collection = null;
        try {
            collection = facilityTree.getChildren();
        }
        catch (FinderException e) {
            // empty catch block
        }
        if (collection != null && collection.size() > 0) {
            for (FacilityTreeLocal children : collection) {
                this.createScopeFacilityTree(children, item);
            }
        }
    }

    public String getFacilityPath(String facilityId, String parentFacilityId) throws FinderException, NamingException {
        block12: {
            try {
                Collection ct = FacilityTreeUtil.getLocalHome().findByFacilityId(facilityId);
                if (ct == null) break block12;
                FacilityTreeLocal tree = null;
                Iterator itr = ct.iterator();
                if (itr.hasNext()) {
                    tree = (FacilityTreeLocal)itr.next();
                }
                if (tree == null) break block12;
                StringBuffer buffer = new StringBuffer();
                if (tree.getTreeType() == 0) {
                    if (parentFacilityId != null && parentFacilityId.length() > 0) {
                        for (FacilityTreeLocal parentTree = tree; parentTree != null; parentTree = parentTree.getParent()) {
                            FacilityLocal parent = parentTree.getFacility();
                            if (parentFacilityId.compareTo(parent.getFacilityId()) == 0) {
                                if (buffer.length() == 0) {
                                    buffer.insert(0, SEPARATOR);
                                }
                                break;
                            }
                            buffer.insert(0, SEPARATOR);
                            buffer.insert(0, parent.getCn());
                        }
                    } else {
                        for (FacilityTreeLocal parentTree = tree; parentTree != null; parentTree = parentTree.getParent()) {
                            FacilityLocal parent = parentTree.getFacility();
                            buffer.insert(0, SEPARATOR);
                            buffer.insert(0, parent.getCn());
                        }
                    }
                } else {
                    FacilityLocal facility = tree.getFacility();
                    buffer.append(facility.getCn());
                }
                return buffer.toString();
            }
            catch (FinderException e) {
                throw e;
            }
            catch (NamingException e) {
                throw e;
            }
        }
        return "";
    }

    public ArrayList getFacilityIdList(String hostName, String ipAddress) throws FinderException, NamingException {
        ArrayList<String> list = null;
        try {
            Collection ct;
            HashMap<String, String> map = new HashMap<String, String>();
            list = new ArrayList<String>();
            if (ipAddress != null && ipAddress.length() > 0) {
                ct = FacilityUtil.getLocalHome().findByIpAddress(ipAddress);
                for (FacilityLocal facility : ct) {
                    if (map.get(facility.getFacilityId()) != null) continue;
                    map.put(facility.getFacilityId(), "1");
                    list.add(facility.getFacilityId());
                }
            }
            if (hostName != null && hostName.length() > 0) {
                ct = FacilityUtil.getLocalHome().findByNodeName(hostName);
                for (FacilityLocal facility : ct) {
                    if (map.get(facility.getFacilityId()) != null) continue;
                    map.put(facility.getFacilityId(), "1");
                    list.add(facility.getFacilityId());
                }
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public boolean isNode(String facilityId) throws FinderException, NamingException {
        boolean node = false;
        try {
            FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
            if (facility.getType() == 1) {
                node = true;
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return node;
    }

    public ArrayList findByCondition(HashMap condition) throws FinderException, NamingException {
        m_log.debug((Object)"findByCondition() : start");
        ArrayList<String> list = null;
        try {
            Collection ct = FacilityUtil.getLocalHome().findByCondition(condition);
            list = new ArrayList<String>();
            for (FacilityLocal ft : ct) {
                m_log.debug((Object)("findByCondition() : hit facility id = " + ft.getFacilityId()));
                list.add(ft.getFacilityId());
            }
        }
        catch (FinderException e) {
            m_log.error((Object)"findByCondition() : FinderException", (Throwable)e);
            throw e;
        }
        catch (NamingException e) {
            m_log.error((Object)"findByCondition() : NamingException", (Throwable)e);
            throw e;
        }
        m_log.debug((Object)"findByCondition() : end");
        return list;
    }
}

