/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorItemDAO {
    protected static Log m_log = LogFactory.getLog(CollectorItemDAO.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertCollectorItem(CollectorItemInfo cinfo) throws EJBException {
        m_log.debug((Object)("insertCollectorItem() start :" + cinfo.getCollectorId() + " " + cinfo.getItemCode() + " " + cinfo.getDisplayName() + " "));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "INSERT INTO CC_COLLECTOR_ITEM (collectorid, item_code,display_name)values (?,?,?);";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, cinfo.getCollectorId());
                stmt.setString(2, cinfo.getItemCode());
                stmt.setString(3, cinfo.getDisplayName());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("insertCollectorItem() error :" + cinfo.toString() + " SQLException " + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("insertCollectorItem() error :" + cinfo.toString() + " SQLException "));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("insertCollectorItem() error :" + cinfo.toString() + " SQLException "));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("insertCollectorItem() end   :" + cinfo.toString()));
            throw throwable;
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("insertCollectorItem() error :" + cinfo.toString() + " SQLException "));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("insertCollectorItem() end   :" + cinfo.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<CollectorItemInfo> selectCollectorItemByCollectorID(String collectorID) throws EJBException {
        m_log.debug((Object)("selectCollectorItemByCollectorID() start :" + collectorID));
        ArrayList<CollectorItemInfo> ret = new ArrayList<CollectorItemInfo>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM CC_COLLECTOR_ITEM WHERE COLLECTORID=? ORDER BY ITEM_CODE, DISPLAY_NAME";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, collectorID);
                res = stmt.executeQuery();
                while (res.next()) {
                    CollectorItemInfo cinfo = new CollectorItemInfo(res.getString("COLLECTORID"), res.getString("ITEM_CODE"), res.getString("DISPLAY_NAME"));
                    ret.add(cinfo);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("selectCollectorItemByCollectorID() error :" + collectorID + " SQLException "));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("selectCollectorItemByCollectorID() error :" + collectorID + " SQLException "));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("selectCollectorItemByCollectorID() error :" + collectorID + " SQLException "));
            throw new EJBException(e1.getMessage());
        }
        if (res != null) {
            res.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("selectCollectorItemByCollectorID() end   :" + collectorID));
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteCollectorItemByCollectorID(String collectorID) {
        m_log.debug((Object)("deleteCollectorItemByCollectorID() start :" + collectorID));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM CC_COLLECTOR_ITEM WHERE COLLECTORID = ? ";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, collectorID);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                m_log.error((Object)("deleteCollectorItemByCollectorID() error :" + collectorID + " SQLException "));
                throw new EJBException(e.getMessage());
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("deleteCollectorItemByCollectorID() error :" + collectorID + " SQLException "));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("deleteCollectorItemByCollectorID() error :" + collectorID + " SQLException "));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("deleteCollectorItemByCollectorID() end   :" + collectorID));
    }
}

