/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.mail.ejb.session;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoData;
import com.clustercontrol.notify.mail.factory.AddMailTemplate;
import com.clustercontrol.notify.mail.factory.DeleteMailTemplate;
import com.clustercontrol.notify.mail.factory.ModifyMailTemplate;
import com.clustercontrol.notify.mail.factory.SelectMailTemplate;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MailTemplateControllerBean
implements SessionBean {
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public boolean addMailTemplate(MailTemplateInfoData data) throws CreateException, NamingException {
        Principal pri = this.m_context.getCallerPrincipal();
        AddMailTemplate mailTemplate = new AddMailTemplate();
        return mailTemplate.add(data, pri.getName());
    }

    public boolean modifyMailTemplate(MailTemplateInfoData data) throws FinderException, NamingException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyMailTemplate mailTemplate = new ModifyMailTemplate();
        return mailTemplate.modify(data, pri.getName());
    }

    public boolean deleteMailTemplate(String mailTemplateId) throws RemoveException, NamingException {
        DeleteMailTemplate mailTemplate = new DeleteMailTemplate();
        return mailTemplate.delete(mailTemplateId);
    }

    public MailTemplateInfoData getMailTemplateInfo(String mailTemplateId) throws FinderException, NamingException {
        SelectMailTemplate mailTemplate = new SelectMailTemplate();
        MailTemplateInfoData info = mailTemplate.getMailTemplateInfo(mailTemplateId);
        return info;
    }

    public ArrayList<String> getMailTemplateIdList() throws CreateException, FinderException, NamingException {
        SelectMailTemplate mailTemplate = new SelectMailTemplate();
        ArrayList<String> list = mailTemplate.getMailTemplateIdList();
        return list;
    }

    public ArrayList<ArrayList> getMailTemplateList() throws CreateException, FinderException, NamingException {
        SelectMailTemplate mailTemplate = new SelectMailTemplate();
        ArrayList list = mailTemplate.getMailTemplateList();
        return list;
    }

    public HashMap<String, MailTemplateInfoData> getMailTemplateMap() throws FinderException, NamingException {
        SelectMailTemplate mailTemplate = new SelectMailTemplate();
        HashMap<String, MailTemplateInfoData> map = mailTemplate.getMailTemplateMap();
        return map;
    }

    public ArrayList<TableColumnInfo> getMailTemplateListTableDefine(Locale locale) {
        SelectMailTemplate mailTemplate = new SelectMailTemplate();
        ArrayList<TableColumnInfo> tableDefine = mailTemplate.getMailTemplateListTableDefine(locale);
        return tableDefine;
    }
}

