/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.composite.TimeVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.util.Messages;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StartDelayComposite
extends Composite {
    protected Button m_sessionCondition = null;
    protected Text m_sessionValue = null;
    protected Button m_timeCondition = null;
    protected Text m_timeValue = null;
    protected Button m_andCondition = null;
    protected Button m_orCondition = null;
    protected Button m_notifyCondition = null;
    protected Combo m_notifyPriority = null;
    protected Button m_operationCondition = null;
    protected Group m_operationConditionGroup = null;
    protected Combo m_operationType = null;
    protected Text m_operationValue = null;
    protected Button m_startDelayCondition = null;
    protected Group m_startDelayConditionGroup = null;
    protected JobWaitRuleInfo m_waitRule = null;
    protected Shell m_shell = null;

    public StartDelayComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.m_shell = this.getShell();
    }

    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.fill = true;
        this.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        Label label = null;
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        composite.setLayout((Layout)rowLayout);
        this.m_startDelayCondition = new Button(composite, 32);
        this.m_startDelayCondition.setText(Messages.getString((String)"start.delay"));
        this.m_startDelayCondition.setLayoutData((Object)new RowData(200, 22));
        this.m_startDelayCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                StartDelayComposite.this.setStartDelayEnabled(check.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_startDelayConditionGroup = new Group(composite, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        this.m_startDelayConditionGroup.setLayout((Layout)rowLayout);
        Group group = new Group((Composite)this.m_startDelayConditionGroup, 0);
        group.setText(Messages.getString((String)"object.list"));
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        group.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_sessionCondition = new Button(composite, 32);
        this.m_sessionCondition.setText(String.valueOf(Messages.getString((String)"time.after.session.start")) + " : ");
        this.m_sessionCondition.setLayoutData((Object)new RowData(180, 22));
        this.m_sessionCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    StartDelayComposite.this.m_sessionValue.setEnabled(true);
                } else {
                    StartDelayComposite.this.m_sessionValue.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_sessionValue = new Text(composite, 2048);
        this.m_sessionValue.setLayoutData((Object)new RowData(100, 15));
        this.m_sessionValue.addVerifyListener((VerifyListener)new PositiveNumberVerifyListener(0, Short.MAX_VALUE));
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_timeCondition = new Button(composite, 32);
        this.m_timeCondition.setText(String.valueOf(Messages.getString((String)"wait.rule.time.example")) + " : ");
        this.m_timeCondition.setLayoutData((Object)new RowData(180, 22));
        this.m_timeCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    StartDelayComposite.this.m_timeValue.setEnabled(true);
                } else {
                    StartDelayComposite.this.m_timeValue.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_timeValue = new Text(composite, 2048);
        this.m_timeValue.setLayoutData((Object)new RowData(100, 15));
        this.m_timeValue.addVerifyListener((VerifyListener)new TimeVerifyListener());
        group = new Group((Composite)this.m_startDelayConditionGroup, 0);
        group.setText(Messages.getString((String)"condition.between.objects"));
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        group.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_andCondition = new Button(composite, 16);
        this.m_andCondition.setText(Messages.getString((String)"and"));
        this.m_andCondition.setLayoutData((Object)new RowData(100, 22));
        this.m_orCondition = new Button(composite, 16);
        this.m_orCondition.setText(Messages.getString((String)"or"));
        this.m_orCondition.setLayoutData((Object)new RowData(100, 22));
        label = new Label(composite, 0);
        label.setLayoutData((Object)new RowData(77, 15));
        composite = new Composite((Composite)this.m_startDelayConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        label = new Label(composite, 0);
        label.setLayoutData((Object)new RowData(5, 15));
        composite = new Composite((Composite)this.m_startDelayConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_notifyCondition = new Button(composite, 32);
        this.m_notifyCondition.setText(String.valueOf(Messages.getString((String)"notify.attribute")) + " : ");
        this.m_notifyCondition.setLayoutData((Object)new RowData(100, 22));
        this.m_notifyCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    StartDelayComposite.this.m_notifyPriority.setEnabled(true);
                } else {
                    StartDelayComposite.this.m_notifyPriority.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_notifyPriority = new Combo(composite, 0x1000008);
        this.m_notifyPriority.setLayoutData((Object)new RowData(100, 20));
        this.m_notifyPriority.add(PriorityConstant.STRING_INFO);
        this.m_notifyPriority.add(PriorityConstant.STRING_WARNING);
        this.m_notifyPriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_notifyPriority.add(PriorityConstant.STRING_UNKNOWN);
        composite = new Composite((Composite)this.m_startDelayConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_operationCondition = new Button(composite, 32);
        this.m_operationCondition.setText(Messages.getString((String)"operations"));
        this.m_operationCondition.setLayoutData((Object)new RowData(220, 22));
        this.m_operationCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    StartDelayComposite.this.m_operationType.setEnabled(true);
                    int type = StartDelayComposite.this.getSelectOperationName(StartDelayComposite.this.m_operationType);
                    if (type == 4) {
                        StartDelayComposite.this.m_operationValue.setEnabled(true);
                    } else if (type == 6) {
                        StartDelayComposite.this.m_operationValue.setEnabled(false);
                    }
                    StartDelayComposite.this.m_operationConditionGroup.setEnabled(true);
                } else {
                    StartDelayComposite.this.m_operationType.setEnabled(false);
                    StartDelayComposite.this.m_operationValue.setEnabled(false);
                    StartDelayComposite.this.m_operationConditionGroup.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_operationConditionGroup = new Group((Composite)this.m_startDelayConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        this.m_operationConditionGroup.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)this.m_operationConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        label = new Label(composite, 0);
        label.setText(String.valueOf(Messages.getString((String)"name")) + " : ");
        label.setLayoutData((Object)new RowData(100, 15));
        this.m_operationType = new Combo(composite, 0x1000008);
        this.m_operationType.setLayoutData((Object)new RowData(100, 20));
        this.m_operationType.add(OperationConstant.STRING_STOP_SKIP);
        this.m_operationType.add(OperationConstant.STRING_STOP_WAIT);
        this.m_operationType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Combo check = (Combo)e.getSource();
                int type = StartDelayComposite.this.getSelectOperationName(check);
                if (type == 4) {
                    StartDelayComposite.this.m_operationValue.setEnabled(true);
                } else if (type == 6) {
                    StartDelayComposite.this.m_operationValue.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        composite = new Composite((Composite)this.m_operationConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        label = new Label(composite, 0);
        label.setText(String.valueOf(Messages.getString((String)"end.value")) + " : ");
        label.setLayoutData((Object)new RowData(100, 15));
        this.m_operationValue = new Text(composite, 2048);
        this.m_operationValue.setLayoutData((Object)new RowData(100, 15));
        this.m_operationValue.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        label = new Label(composite, 0);
        label.setLayoutData((Object)new RowData(70, 15));
    }

    public void reflectWaitRuleInfo() {
        if (this.m_waitRule instanceof JobWaitRuleInfo) {
            this.m_startDelayCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getStart_delay()));
            this.m_sessionCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getStart_delay_session()));
            this.m_sessionValue.setText(String.valueOf(this.m_waitRule.getStart_delay_session_value()));
            this.m_timeCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getStart_delay_time()));
            if (this.m_waitRule.getStart_delay_time_value() instanceof Date) {
                SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
                this.m_timeValue.setText(formatter.format(this.m_waitRule.getStart_delay_time_value()));
            } else {
                this.m_timeValue.setText("");
            }
            if (this.m_waitRule.getStart_delay_condition_type() == 0) {
                this.m_andCondition.setSelection(true);
            } else {
                this.m_orCondition.setSelection(true);
            }
            this.m_notifyCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getStart_delay_notify()));
            this.setSelectPriority(this.m_notifyPriority, this.m_waitRule.getStart_delay_notify_priority());
            this.m_operationCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getStart_delay_operation()));
            this.setSelectOperationName(this.m_operationType, this.m_waitRule.getStart_delay_operation_type());
            this.m_operationValue.setText(String.valueOf(this.m_waitRule.getStart_delay_operation_end_value()));
        } else {
            this.m_startDelayCondition.setSelection(false);
            this.m_sessionCondition.setSelection(false);
            this.m_sessionValue.setText(String.valueOf(1));
            this.m_timeCondition.setSelection(false);
            this.m_andCondition.setSelection(true);
            this.m_notifyCondition.setSelection(false);
            this.m_notifyPriority.select(0);
            this.m_operationCondition.setSelection(false);
            this.m_operationType.select(0);
            this.m_operationValue.setText(String.valueOf(0));
        }
        this.setStartDelayEnabled(this.m_startDelayCondition.getSelection());
    }

    public void setWaitRuleInfo(JobWaitRuleInfo start) {
        this.m_waitRule = start;
    }

    public JobWaitRuleInfo getWaitRuleInfo() {
        return this.m_waitRule;
    }

    public ValidateResult createWaitRuleInfo() {
        ValidateResult result;
        block16: {
            result = null;
            if (this.m_waitRule == null) {
                this.m_waitRule = new JobWaitRuleInfo();
            }
            this.m_waitRule.setStart_delay(YesNoConstant.booleanToType((boolean)this.m_startDelayCondition.getSelection()));
            this.m_waitRule.setStart_delay_session(YesNoConstant.booleanToType((boolean)this.m_sessionCondition.getSelection()));
            try {
                this.m_waitRule.setStart_delay_session_value(Integer.parseInt(this.m_sessionValue.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                if (this.m_waitRule.getStart_delay_session() != 1) break block16;
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.52"));
                return result;
            }
        }
        this.m_waitRule.setStart_delay_time(YesNoConstant.booleanToType((boolean)this.m_timeCondition.getSelection()));
        if (this.m_waitRule.getStart_delay_time() == 1) {
            boolean check = false;
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Date from = null;
            Date to = null;
            Date date = null;
            try {
                from = formatter.parse("00:00:00");
                to = formatter.parse("23:59:59");
                date = formatter.parse(this.m_timeValue.getText());
                check = true;
            }
            catch (ParseException parseException) {
                formatter = new SimpleDateFormat("HH:mm");
                try {
                    date = formatter.parse(this.m_timeValue.getText());
                    check = true;
                }
                catch (ParseException parseException2) {}
            }
            if (check) {
                if (date.before(from) || date.after(to)) {
                    Object[] args = new String[]{formatter.format(from), formatter.format(to)};
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    result.setMessage(Messages.getString((String)"message.hinemos.8", (Object[])args));
                    return result;
                }
                this.m_waitRule.setStart_delay_time_value(date);
            } else {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.hinemos.6"));
                return result;
            }
        }
        if (this.m_andCondition.getSelection()) {
            this.m_waitRule.setStart_delay_condition_type(0);
        } else {
            this.m_waitRule.setStart_delay_condition_type(1);
        }
        this.m_waitRule.setStart_delay_notify(YesNoConstant.booleanToType((boolean)this.m_notifyCondition.getSelection()));
        this.m_waitRule.setStart_delay_notify_priority(this.getSelectPriority(this.m_notifyPriority));
        this.m_waitRule.setStart_delay_operation(YesNoConstant.booleanToType((boolean)this.m_operationCondition.getSelection()));
        this.m_waitRule.setStart_delay_operation_type(this.getSelectOperationName(this.m_operationType));
        try {
            if (this.m_waitRule.getStart_delay_operation() == 1 && this.m_waitRule.getStart_delay_operation() == 5) {
                this.m_waitRule.setStart_delay_operation_end_value(Integer.parseInt(this.m_operationValue.getText()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.21"));
            return result;
        }
        return null;
    }

    public void setStartDelayEnabled(boolean enabled) {
        if (enabled) {
            this.m_startDelayConditionGroup.setEnabled(true);
            this.m_sessionCondition.setEnabled(true);
            if (this.m_sessionCondition.getSelection()) {
                this.m_sessionValue.setEnabled(true);
            } else {
                this.m_sessionValue.setEnabled(false);
            }
            this.m_timeCondition.setEnabled(true);
            if (this.m_timeCondition.getSelection()) {
                this.m_timeValue.setEnabled(true);
            } else {
                this.m_timeValue.setEnabled(false);
            }
            this.m_andCondition.setEnabled(true);
            this.m_orCondition.setEnabled(true);
            this.m_notifyCondition.setEnabled(true);
            if (this.m_notifyCondition.getSelection()) {
                this.m_notifyPriority.setEnabled(true);
            } else {
                this.m_notifyPriority.setEnabled(false);
            }
            this.m_operationConditionGroup.setEnabled(true);
            this.m_operationCondition.setEnabled(true);
            if (this.m_operationCondition.getSelection()) {
                this.m_operationType.setEnabled(true);
                this.m_operationValue.setEnabled(false);
                int type = this.getSelectOperationName(this.m_operationType);
                if (type == 4) {
                    this.m_operationValue.setEnabled(true);
                } else if (type == 6) {
                    this.m_operationValue.setEnabled(false);
                }
            } else {
                this.m_operationType.setEnabled(false);
                this.m_operationValue.setEnabled(false);
            }
        } else {
            this.m_startDelayConditionGroup.setEnabled(false);
            this.m_sessionCondition.setEnabled(false);
            this.m_sessionValue.setEnabled(false);
            this.m_timeCondition.setEnabled(false);
            this.m_timeValue.setEnabled(false);
            this.m_andCondition.setEnabled(false);
            this.m_orCondition.setEnabled(false);
            this.m_notifyCondition.setEnabled(false);
            this.m_notifyPriority.setEnabled(false);
            this.m_operationCondition.setEnabled(false);
            this.m_operationType.setEnabled(false);
            this.m_operationValue.setEnabled(false);
            this.m_operationConditionGroup.setEnabled(false);
        }
    }

    public void setSelectPriority(Combo combo, int priority) {
        String select = "";
        if (priority == 0) {
            select = PriorityConstant.STRING_CRITICAL;
        } else if (priority == 2) {
            select = PriorityConstant.STRING_WARNING;
        } else if (priority == 3) {
            select = PriorityConstant.STRING_INFO;
        } else if (priority == 1) {
            select = PriorityConstant.STRING_UNKNOWN;
        } else if (priority == 4) {
            select = "";
        }
        combo.select(0);
        int i = 0;
        while (i < combo.getItemCount()) {
            if (select.equals(combo.getItem(i))) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    public int getSelectPriority(Combo combo) {
        String select = combo.getText();
        if (select.equals(PriorityConstant.STRING_CRITICAL)) {
            return 0;
        }
        if (select.equals(PriorityConstant.STRING_WARNING)) {
            return 2;
        }
        if (select.equals(PriorityConstant.STRING_INFO)) {
            return 3;
        }
        if (select.equals(PriorityConstant.STRING_UNKNOWN)) {
            return 1;
        }
        if (select.equals("")) {
            return 4;
        }
        return -1;
    }

    public void setSelectOperationName(Combo combo, int operation) {
        String select = "";
        if (operation == 4) {
            select = OperationConstant.STRING_STOP_SKIP;
        } else if (operation == 6) {
            select = OperationConstant.STRING_STOP_WAIT;
        }
        combo.select(0);
        int i = 0;
        while (i < combo.getItemCount()) {
            if (select.equals(combo.getItem(i))) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    public int getSelectOperationName(Combo combo) {
        String select = combo.getText();
        if (select.equals(OperationConstant.STRING_STOP_SKIP)) {
            return 4;
        }
        if (select.equals(OperationConstant.STRING_STOP_WAIT)) {
            return 6;
        }
        return -1;
    }
}

