/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.util.code;

import com.clustercontrol.performanceMGR.bean.DeviceData;
import com.clustercontrol.performanceMGR.util.code.CollectorItemCategoryInfo;
import com.clustercontrol.performanceMGR.util.code.CollectorItemCodeInfo;
import com.clustercontrol.performanceMGR.util.code.ICollectorItemInfo;
import java.io.Serializable;
import java.util.ArrayList;

public class CollectorItemTreeItem
implements Serializable {
    private CollectorItemCategoryInfo category = null;
    private CollectorItemTreeItem parent = null;
    private ICollectorItemInfo data = null;
    private ArrayList<CollectorItemTreeItem> childrens = null;
    private DeviceData deviceData = null;

    public CollectorItemTreeItem(CollectorItemTreeItem parent, ICollectorItemInfo data, DeviceData deviceData) {
        this.deviceData = deviceData;
        if (data instanceof CollectorItemCategoryInfo) {
            this.setCategory((CollectorItemCategoryInfo)data);
        } else if (data instanceof CollectorItemCodeInfo) {
            this.setCategory(parent.getCategory());
            this.category.addItem((CollectorItemCodeInfo)data);
        }
        this.setParent(parent);
        this.setData(data);
        if (parent != null) {
            parent.addChildren(this);
        }
        this.childrens = new ArrayList();
    }

    private void setParent(CollectorItemTreeItem parent) {
        this.parent = parent;
    }

    private void addChildren(CollectorItemTreeItem child) {
        child.setParent(this);
        this.childrens.add(child);
    }

    public String getItemCode() {
        if (this.data instanceof CollectorItemCodeInfo) {
            return ((CollectorItemCodeInfo)this.data).getItemCode();
        }
        return null;
    }

    public String getItemName() {
        if (this.data instanceof CollectorItemCodeInfo) {
            return ((CollectorItemCodeInfo)this.data).getItemName();
        }
        return null;
    }

    public boolean hasBreakdown() {
        return this.childrens.size() != 0;
    }

    public boolean isDeviceFlag() {
        if (this.data instanceof CollectorItemCodeInfo) {
            return ((CollectorItemCodeInfo)this.data).isDeviceFlag();
        }
        return false;
    }

    public String getDeviceType() {
        return ((CollectorItemCodeInfo)this.data).getDeviceType();
    }

    public boolean isRangeFixed() {
        if (this.data instanceof CollectorItemCodeInfo) {
            return ((CollectorItemCodeInfo)this.data).isRangeFixed();
        }
        return false;
    }

    public String getMeasure() {
        if (this.data instanceof CollectorItemCodeInfo) {
            return ((CollectorItemCodeInfo)this.data).getMeasure();
        }
        return null;
    }

    public CollectorItemCategoryInfo getCategory() {
        return this.category;
    }

    private void setCategory(CollectorItemCategoryInfo category) {
        this.category = category;
    }

    public ArrayList getChildrens() {
        return this.childrens;
    }

    public ICollectorItemInfo getData() {
        return this.data;
    }

    private void setData(ICollectorItemInfo data) {
        this.data = data;
    }

    public CollectorItemTreeItem getParent() {
        return this.parent;
    }

    public int size() {
        return this.childrens.size();
    }

    public DeviceData getDeviceData() {
        return this.deviceData;
    }
}

