/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.util;

import com.clustercontrol.repository.util.DataTable;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpNoSuchInstance;
import org.opennms.protocols.snmp.SnmpNoSuchObject;
import org.opennms.protocols.snmp.SnmpNull;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpUInt32;
import org.opennms.protocols.snmp.SnmpV2Error;
import org.opennms.protocols.snmp.SnmpVarBind;

public class SnmpPoller
implements SnmpHandler {
    protected static Log m_log = LogFactory.getLog(SnmpPoller.class);
    private String m_ipAddress;
    private String m_oidText;
    private SnmpObjectId m_startOid;
    private SnmpObjectId m_stopOid;
    private DataTable m_dataTable;
    private String m_message = null;
    boolean m_waitFlg;
    String lastOid;
    private int m_errorCode = 0;
    private final int Normal = 0;
    private final int TimeOutError = 1;
    private final int InternalError = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void polling(InetAddress ipAddress, int port, int version, String community, int retries, int timeout, List oidList, DataTable table) {
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("polling() start :" + ipAddress.toString()));
            m_log.debug((Object)("Port      : " + port));
            m_log.debug((Object)("Version   : " + version));
            m_log.debug((Object)("Community : " + community));
            m_log.debug((Object)("Retries   : " + retries));
            m_log.debug((Object)("Timeout   : " + timeout));
        }
        this.m_errorCode = 0;
        this.m_dataTable = table;
        this.m_ipAddress = ipAddress.toString();
        SnmpPeer peer = new SnmpPeer(ipAddress);
        if (port != -1) {
            peer.setPort(port);
        }
        if (timeout != -1) {
            peer.setTimeout(timeout);
        }
        if (retries != -1) {
            peer.setRetries(retries);
        }
        SnmpParameters parms = peer.getParameters();
        parms.setVersion(version);
        if (community != null) {
            parms.setReadCommunity(community);
        }
        SnmpSession session = null;
        try {
            session = new SnmpSession(peer);
        }
        catch (SocketException e) {
            m_log.error((Object)("polling() warning  :" + ipAddress.toString() + " SocketException creating the SNMP session"));
            this.m_errorCode = 2;
            return;
        }
        session.setDefaultHandler((SnmpHandler)this);
        try {
            for (String this.m_oidText : oidList) {
                this.m_startOid = new SnmpObjectId(this.m_oidText);
                SnmpObjectId id = new SnmpObjectId(this.m_oidText);
                int[] ids = id.getIdentifiers();
                int n = ids.length - 1;
                ids[n] = ids[n] + 1;
                id.setIdentifiers(ids);
                this.m_stopOid = id;
                SnmpPduRequest pdu = new SnmpPduRequest(this.m_oidText.endsWith(".0") ? 160 : 161);
                pdu.setRequestId(SnmpPduPacket.nextSequence());
                SnmpObjectId oId = new SnmpObjectId(this.m_oidText);
                pdu.addVarBind(new SnmpVarBind(oId));
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    this.m_waitFlg = true;
                    session.send((SnmpPduPacket)pdu);
                    if (this.m_waitFlg) {
                        session.wait();
                    }
                }
            }
        }
        catch (InterruptedException e) {
            m_log.error((Object)("polling() warning :" + ipAddress.toString() + " polling failed at InterruptedException"));
            this.m_errorCode = 2;
            return;
        }
        finally {
            session.close();
        }
        if (this.m_errorCode == 1 || this.m_errorCode == 2) {
            // empty if block
        }
        if (!m_log.isDebugEnabled()) return;
        m_log.debug((Object)("polling() end :" + ipAddress.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpReceivedPdu(SnmpSession session, int cmd, SnmpPduPacket pdu) {
        try {
            long time = System.currentTimeMillis();
            SnmpPduRequest req = null;
            if (!(pdu instanceof SnmpPduRequest)) {
                m_log.error((Object)("polling() error :" + session.toString() + " Received non-request pdu"));
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    this.m_errorCode = 2;
                    session.notify();
                }
                return;
            }
            req = (SnmpPduRequest)pdu;
            if (pdu.getCommand() != 162) {
                m_log.error((Object)("polling() error :" + session.toString() + "  Received non-response command " + pdu.getCommand()));
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    this.m_errorCode = 2;
                    session.notify();
                }
                return;
            }
            if (req.getErrorStatus() != 0) {
                m_log.error((Object)("polling() error :" + session.toString() + "  Error Status " + req.getErrorStatus()));
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    this.m_errorCode = 2;
                    session.notify();
                }
                return;
            }
            SnmpVarBind var = pdu.getVarBindAt(0);
            if (var.getValue().typeId() == -126 || this.m_stopOid != null && this.m_stopOid.compare(var.getName()) < 0) {
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    session.notify();
                }
                return;
            }
            SnmpPduRequest nxt = new SnmpPduRequest(161);
            nxt.setRequestId(SnmpPduPacket.nextSequence());
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)(this.m_ipAddress + " " + var.getName().toString() + " " + time + " " + var.getValue().getClass().getName() + " " + var.getValue().toString()));
            }
            if (this.m_startOid.isRootOf(var.getName())) {
                if (!(var.getValue() instanceof SnmpNoSuchInstance || var.getValue() instanceof SnmpNoSuchObject || var.getValue() instanceof SnmpV2Error || var.getValue() instanceof SnmpNull)) {
                    if (var.getValue() instanceof SnmpTimeTicks) {
                        if (m_log.isDebugEnabled()) {
                            m_log.debug((Object)(this.m_ipAddress + "," + var.getName().toString() + "," + time + "," + var.getValue().toString()));
                        }
                        long i = ((SnmpUInt32)var.getValue()).getValue();
                        this.m_dataTable.putValue(var.getName().toString(), time, String.valueOf(i));
                    } else {
                        if (m_log.isDebugEnabled()) {
                            m_log.debug((Object)(this.m_ipAddress + "," + var.getName().toString() + "," + time + "," + var.getValue().toString()));
                        }
                        this.m_dataTable.putValue(var.getName().toString(), time, var.getValue().toString());
                    }
                }
                nxt.addVarBind(new SnmpVarBind(var.getName()));
            }
            if (nxt.getLength() == 0) {
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    session.notify();
                }
                return;
            }
            session.send((SnmpPduPacket)nxt, (SnmpHandler)this);
        }
        catch (Exception e) {
            m_log.error((Object)e);
            SnmpSession snmpSession = session;
            synchronized (snmpSession) {
                this.m_errorCode = 2;
                session.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpInternalError(SnmpSession session, int err, SnmpSyntax pdu) {
        m_log.warn((Object)("snmpInternalError():" + session.toString() + " snmpInternalError. The error code is " + err));
        SnmpSession snmpSession = session;
        synchronized (snmpSession) {
            this.m_errorCode = 2;
            this.m_message = "InternalError. The error code is " + err + ". IP:" + this.m_ipAddress + " OID:" + this.m_oidText;
            this.removeTableValue();
            this.m_waitFlg = false;
            session.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpTimeoutError(SnmpSession session, SnmpSyntax pdu) {
        m_log.warn((Object)("snmpTimeoutError():" + session.getPeer().getPeer().toString() + " " + ((SnmpPduRequest)pdu).toVarBindArray()[0].getName() + " polling failed at TimeoutError"));
        SnmpSession snmpSession = session;
        synchronized (snmpSession) {
            this.m_errorCode = 1;
            this.m_message = "TimeoutError. IP:" + session.getPeer().getPeer().toString() + " OID:" + ((SnmpPduRequest)pdu).toVarBindArray()[0].getName();
            this.removeTableValue();
            session.notify();
        }
    }

    private void removeTableValue() {
        for (String fullOid : this.m_dataTable.keySet()) {
            if (!fullOid.startsWith(this.m_oidText)) continue;
            this.m_dataTable.removeValue(fullOid);
        }
    }
}

