/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.factory;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyTreeItem;
import com.clustercontrol.collectiverun.bean.ParameterTypeConstant;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionParamLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParameterProperty {
    protected static Log m_log = LogFactory.getLog(ParameterProperty.class);
    public static final String SCOPE = "scope";
    public static final String NAME = "name";

    public String getTypeId(String sessionId) {
        try {
            CRunSessionLocal session = CRunSessionUtil.getLocalHome().findByPrimaryKey(sessionId);
            CRunCmdMstLocal cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
            return cmd.getType_id();
        }
        catch (Exception e) {
            m_log.debug((Object)("getType() : \u30bb\u30c3\u30b7\u30e7\u30f3ID\u304b\u3089\u7a2e\u5225\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 : " + e.getMessage()));
            return null;
        }
    }

    public Property getPropertyBySessionId(String sessionId, Locale locale) {
        Property property = null;
        try {
            CRunSessionLocal session = CRunSessionUtil.getLocalHome().findByPrimaryKey(sessionId);
            CRunCmdMstLocal cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
            property = this.getParameterProperty(cmd.getType_id(), locale);
            if (property instanceof Property) {
                this.selectNameProperty(property, Messages.getString((String)cmd.getName_id(), (Locale)locale), locale);
                this.setPropertyValue(property, session, locale);
            }
        }
        catch (Exception e) {
            m_log.debug((Object)("getProperty() : \u30d7\u30ed\u30d1\u30c6\u30a3\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 sessionId=" + sessionId + " : " + e.getMessage()));
        }
        return property;
    }

    public Property getProperty(String typeId, Locale locale) {
        try {
            return this.getParameterProperty(typeId, locale);
        }
        catch (Exception e) {
            m_log.debug((Object)("getProperty() : \u30d7\u30ed\u30d1\u30c6\u30a3\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 typeId=" + typeId + " : " + e.getMessage()));
            return null;
        }
    }

    public Property getCommandParameterProperty(CRunCmdParamMstLocal cmdParam, Locale locale) throws FinderException, NamingException {
        Property parameter = null;
        if (cmdParam != null) {
            Collection paramSelectList;
            CRunParamMstLocal param = cmdParam.getParamMst();
            int paramType = param.getParam_type();
            parameter = new Property(param.getParam_id(), Messages.getString((String)param.getName_id(), (Locale)locale), ParameterTypeConstant.paramTypeToEditor(paramType));
            if (paramType == 0 || paramType == 1) {
                parameter.setStringUpperValue(4096);
            }
            parameter.setModify(1);
            parameter.setValue((Object)"");
            if (paramType == 2 && (paramSelectList = param.getParamSelectMst()) != null && paramSelectList.size() > 0) {
                Object[][] selectValues = new Object[][]{new Object[paramSelectList.size()], new Object[paramSelectList.size()]};
                for (CRunParamSelectMstLocal paramSelect : paramSelectList) {
                    int index = paramSelect.getOrder_no();
                    selectValues[1][index] = Messages.getString((String)paramSelect.getName_id(), (Locale)locale);
                    selectValues[0][index] = Messages.getString((String)paramSelect.getName_id(), (Locale)locale);
                }
                parameter.setSelectValues(selectValues);
                parameter.setValue(selectValues[0][0]);
            }
        }
        return parameter;
    }

    public Property getParameterProperty(String typeId, Locale locale) throws FinderException, NamingException {
        Property scope = new Property(SCOPE, Messages.getString((String)SCOPE, (Locale)locale), "com.clustercontrol.composite.ScopePropertyDefine");
        scope.setModify(1);
        Property name = new Property(NAME, Messages.getString((String)NAME, (Locale)locale), "com.clustercontrol.composite.ComboPropertyDefine");
        name.setModify(1);
        CRunTypeMstLocal type = CRunTypeMstUtil.getLocalHome().findByPrimaryKey(typeId);
        HashMap<String, Property> propertyMap = new HashMap<String, Property>();
        Collection cmdList = type.getCmdMst();
        if (cmdList != null && cmdList.size() > 0) {
            Object[][] nameValues = new Object[][]{new Object[cmdList.size()], new Object[cmdList.size()]};
            for (CRunCmdMstLocal cmd : cmdList) {
                int index = cmd.getOrder_no();
                ArrayList<Object> list = new ArrayList<Object>();
                Collection cmdParamList = CRunCmdParamMstUtil.getLocalHome().findByCommandId(cmd.getCommand_id());
                if (cmdParamList != null && cmdParamList.size() > 0) {
                    for (CRunCmdParamMstLocal cmdParam : cmdParamList) {
                        Property parameter = this.getCommandParameterProperty(cmdParam, locale);
                        if (propertyMap.get(cmdParam.getParam_id()) == null) {
                            list.add(parameter);
                            propertyMap.put(cmdParam.getParam_id(), parameter);
                            continue;
                        }
                        list.add(propertyMap.get(cmdParam.getParam_id()));
                    }
                }
                nameValues[0][index] = Messages.getString((String)cmd.getName_id(), (Locale)locale);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("value", Messages.getString((String)cmd.getName_id(), (Locale)locale));
                map.put("property", list);
                nameValues[1][index] = map;
            }
            name.setSelectValues(nameValues);
            name.setValue(nameValues[1][0]);
        }
        Property property = new Property(null, null, "");
        property.removeChildren();
        property.addChildren((PropertyTreeItem)scope);
        property.addChildren((PropertyTreeItem)name);
        Object[][] nameValues = name.getSelectValues();
        this.selectNameProperty(property, (String)nameValues[0][0], locale);
        return property;
    }

    public void selectNameProperty(Property property, String dispText, Locale locale) {
        int index = 0;
        Property name = null;
        ArrayList properties = null;
        properties = PropertyUtil.getProperty((Property)property, (String)NAME);
        if (properties instanceof ArrayList) {
            name = (Property)properties.get(0);
        }
        if (name instanceof Property) {
            Object[][] nameValues = name.getSelectValues();
            if (dispText != null) {
                for (int i = 0; i < nameValues[0].length; ++i) {
                    if (dispText.compareTo((String)nameValues[0][i]) != 0) continue;
                    index = i;
                    break;
                }
            }
            if (nameValues[1][index] instanceof HashMap) {
                HashMap map = (HashMap)nameValues[1][index];
                name.setValue(map.get("value"));
                ArrayList propertyList = (ArrayList)map.get("property");
                if (propertyList instanceof ArrayList) {
                    name.removeChildren();
                    for (int i = 0; i < propertyList.size(); ++i) {
                        name.addChildren((PropertyTreeItem)((Property)propertyList.get(i)));
                    }
                }
            } else {
                name.removeChildren();
                Object select = nameValues[1][index];
                name.setValue(select);
            }
        }
    }

    public void setPropertyValue(Property property, CRunSessionLocal session, Locale locale) {
        ArrayList properties = PropertyUtil.getProperty((Property)property, (String)SCOPE);
        ((Property)properties.get(0)).setValue((Object)"");
        try {
            FacilityTreeItem item = null;
            FacilityInfo info = new FacilityInfo();
            info.setFacilityId(session.getFacility_id());
            info.setFacilityName(session.getScope_text());
            item = new FacilityTreeItem(null, info);
            ((Property)properties.get(0)).setValue((Object)item);
        }
        catch (Exception e) {
            m_log.debug((Object)("setPropertyValue() : \u30d5\u30a1\u30b7\u30ea\u30c6\u30a3\u53d6\u5f97\u30a8\u30e9\u30fc FacilityId=" + session.getFacility_id() + " : " + e.getMessage()));
        }
        Collection collection = session.getSessionParam();
        if (collection != null && collection.size() > 0) {
            for (CRunSessionParamLocal sessionParam : collection) {
                properties = PropertyUtil.getProperty((Property)property, (String)sessionParam.getParam_id());
                ((Property)properties.get(0)).setValue((Object)"");
                try {
                    CRunParamMstLocal param = CRunParamMstUtil.getLocalHome().findByPrimaryKey(sessionParam.getParam_id());
                    if (sessionParam.getParam_value() == null) continue;
                    if (param.getParam_type() == 2) {
                        ((Property)properties.get(0)).setValue((Object)this.getParamValue(sessionParam.getParam_id(), sessionParam.getParam_value(), locale));
                        continue;
                    }
                    ((Property)properties.get(0)).setValue((Object)sessionParam.getParam_value());
                }
                catch (Exception e) {
                    m_log.debug((Object)("setPropertyValue() : \u30d1\u30e9\u30e1\u30fc\u30bf\u53d6\u5f97\u30a8\u30e9\u30fc ParamId=" + sessionParam.getParam_id() + " : " + e.getMessage()));
                }
            }
        }
    }

    public static ArrayList getFacilityTreeItem(FacilityTreeItem item, String facilityId) {
        ArrayList list = new ArrayList();
        ParameterProperty.getFacilityTreeItem(item, facilityId, list);
        return list;
    }

    public static void getFacilityTreeItem(FacilityTreeItem item, String facilityId, ArrayList list) {
        if (facilityId != null && item.getData().getFacilityId() != null && facilityId.compareTo(item.getData().getFacilityId()) == 0) {
            list.add(item);
        }
        FacilityTreeItem[] childrens = item.getChildren();
        for (int i = 0; i < childrens.length; ++i) {
            FacilityTreeItem children1 = childrens[i];
            ParameterProperty.getFacilityTreeItem(children1, facilityId, list);
        }
    }

    protected String getParamValue(String paramId, String value, Locale locale) throws FinderException, NamingException {
        m_log.debug((Object)("getParamValue() : paramId=" + paramId + ", value=" + value));
        String name = null;
        Collection paramSelectList = CRunParamSelectMstUtil.getLocalHome().findByParamId(paramId);
        if (paramSelectList != null && paramSelectList.size() > 0) {
            for (CRunParamSelectMstLocal paramSelect : paramSelectList) {
                if (!paramSelect.getParam_value().equals(value)) continue;
                name = Messages.getString((String)paramSelect.getName_id(), (Locale)locale);
                break;
            }
        }
        return name;
    }
}

