/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Timestamp;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifyOidMaster {
    protected static Log m_log = LogFactory.getLog(ModifyOidMaster.class);
    protected SnmpTrapMasterInfo m_OidData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean modify(SnmpTrapMasterInfo oidData, String user) throws CreateException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, InvalidTransactionException, NamingException, FinderException {
        AccessLock.lock((String)"MONITOR_SNMPTRAP");
        this.m_OidData = oidData;
        TransactionManager tm = null;
        Transaction tx = null;
        Transaction oldTx = null;
        boolean result = false;
        try {
            InitialContext context = new InitialContext();
            tm = (TransactionManager)context.lookup("java:/TransactionManager");
            if (tm.getTransaction() != null) {
                oldTx = tm.suspend();
            }
            try {
                if (tm.getTransaction() == null) {
                    tm.begin();
                    tx = tm.getTransaction();
                }
                if (result = this.modifyOIDMaster(user)) {
                    tx.commit();
                }
            }
            catch (NotSupportedException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            catch (RollbackException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            catch (HeuristicMixedException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            catch (HeuristicRollbackException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            finally {
                if (tx != null) {
                    if (!result) {
                        tx.rollback();
                    }
                    tx = null;
                }
            }
            if (oldTx == null) return result;
        }
        catch (Throwable throwable) {
            if (oldTx == null) throw throwable;
            try {
                tm.resume(oldTx);
                throw throwable;
            }
            catch (InvalidTransactionException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            catch (IllegalStateException e) {
                this.outputLog(e, "add()");
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
        }
        try {
            tm.resume(oldTx);
            return result;
        }
        catch (InvalidTransactionException e) {
            this.outputLog((Exception)((Object)e), "add()");
            throw e;
        }
        catch (IllegalStateException e) {
            this.outputLog(e, "add()");
            throw e;
        }
        catch (SystemException e) {
            this.outputLog((Exception)((Object)e), "add()");
            throw e;
        }
    }

    public boolean modifyOIDMaster(String user) throws NamingException, FinderException {
        boolean result = false;
        try {
            Timestamp now = new Timestamp(new Date().getTime());
            SnmpTrapMasterLocal OIDMaster = SnmpTrapMasterUtil.getLocalHome().findByPrimaryKey(new SnmpTrapMasterPK(this.m_OidData.getMib(), this.m_OidData.getTrapOid(), this.m_OidData.getGenericId(), this.m_OidData.getSpecificId()));
            OIDMaster.setUei(this.m_OidData.getUei());
            OIDMaster.setPriority(this.m_OidData.getPriority());
            OIDMaster.setLogmsg(this.m_OidData.getLogmsg());
            OIDMaster.setDescr(this.m_OidData.getDescr());
            result = true;
        }
        catch (NamingException e) {
            this.outputLog(e, "addOIDMaster()");
            throw e;
        }
        return result;
    }

    private void outputLog(Exception e, String method) {
        AplLogger apllog = new AplLogger("TRAP", "trap");
        Object[] args = new String[]{this.m_OidData.getMib(), this.m_OidData.getTrapOid(), Integer.toString(this.m_OidData.getGenericId()), Integer.toString(this.m_OidData.getSpecificId())};
        apllog.put("SYS", "001", args);
        m_log.debug((Object)(method + ":" + e.getMessage()));
    }
}

