/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.ejb.mdb;

import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.monitor.message.LogOutputJobRunInfo;
import com.clustercontrol.monitor.message.LogOutputNotifyInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.factory.SelectMonitorInfo;
import com.clustercontrol.snmptrap.factory.TrapSnmp;
import com.clustercontrol.snmptrap.message.SnmpTrapMessageInfo;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotifySnmpTrapBean
implements MessageDrivenBean,
MessageListener {
    protected static Log m_log = LogFactory.getLog(NotifySnmpTrapBean.class);
    private MessageDrivenContext messageContext = null;

    public void setMessageDrivenContext(MessageDrivenContext messageContext) throws EJBException {
        this.messageContext = messageContext;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
        this.messageContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void onMessage(Message message) {
        NotifySnmpTrapBean.m_log.debug((Object)"onMessage() : start");
        if (message instanceof ObjectMessage) {
            objectMessage = (ObjectMessage)message;
            obj = null;
            try {
                obj = objectMessage.getObject();
            }
            catch (JMSException e) {
                return;
            }
            if (obj instanceof SnmpTrapMessageInfo) {
                repository = null;
                try {
                    repository = RepositoryControllerUtil.getLocalHome().create();
                    info = (SnmpTrapMessageInfo)obj;
                    monitorId = info.getMonitorId();
                    facilityId = info.getFacilityId();
                    facilityPath = info.getFacilityId().equals("UNREGISTERED") != false ? info.getAgentAdder() : repository.getFacilityPath(facilityId, null);
                    trapOid = info.getTrapOid();
                    genericId = info.getGenericId();
                    specificId = info.getSpecificId();
                    NotifySnmpTrapBean.m_log.debug((Object)("onMessage() : received trap :" + trapOid + ":" + genericId + ":" + specificId));
                    select = new SelectMonitorInfo();
                    snmpTrapInfo = select.getMonitorInfo(monitorId);
                    if (snmpTrapInfo.getCheckMode() == 1) {
                        NotifySnmpTrapBean.m_log.debug((Object)"onMessage() : checkmode ALL_OID : search from masterdb. ");
                        master = select.findMasterInfo(trapOid, genericId, specificId);
                        if (master != null && master.getMib() != null) {
                            msg = master.getLogmsg();
                            msgOrg = master.getDescr();
                            priority = master.getPriority();
                            this.sendMassage(msg, msgOrg, info, master, priority, snmpTrapInfo, facilityPath);
                            NotifySnmpTrapBean.m_log.debug((Object)"onMessage() : sendmessage ");
                        }
                        master = select.findMasterInfo(TrapSnmp.GENERIC_TRAPS.get(genericId).toString(), genericId, specificId);
                        if (master == null || master.getMib() == null) ** GOTO lbl95
                        msg = master.getLogmsg();
                        msgOrg = master.getDescr();
                        priority = master.getPriority();
                        this.sendMassage(msg, msgOrg, info, master, priority, snmpTrapInfo, facilityPath);
                        NotifySnmpTrapBean.m_log.debug((Object)"onMessage() : sendmessage( change to generic trap ) ");
                    }
                    if (snmpTrapInfo.getCheckMode() == 2) {
                        NotifySnmpTrapBean.m_log.debug((Object)"onMessage() : unregisterd trap  ");
                        if (genericId != 6 || (master = select.findMasterInfo(trapOid, genericId, specificId)) == null || master.getMib() != null) ** GOTO lbl95
                        msg = "oid  : " + trapOid + " specificId : " + specificId + " generic_id : " + genericId;
                        msgOrg = "";
                        priority = 1;
                        this.sendMassage(msg, msgOrg, info, master, priority, snmpTrapInfo, facilityPath);
                        NotifySnmpTrapBean.m_log.debug((Object)"onMessage() : sendmessage ");
                    }
                    NotifySnmpTrapBean.m_log.debug((Object)"onMessage() : search from monitors. ");
                    oidList = snmpTrapInfo.getOidInfos();
                    matched = 0;
                    for (i = 0; i < oidList.size(); ++i) {
                        oidInfo = oidList.get(i);
                        if (!trapOid.equals(oidInfo.getTrapOid()) || genericId != oidInfo.getGenericId() || specificId != oidInfo.getSpecificId()) continue;
                        mib = oidInfo.getMib();
                        priority = oidInfo.getPriority();
                        msg = oidInfo.getLogmsg();
                        msgOrg = oidInfo.getDescr();
                        pk = new SnmpTrapMasterPK(mib, trapOid, genericId, specificId);
                        master = select.getMasterInfo(pk);
                        this.sendMassage(msg, msgOrg, info, master, priority, snmpTrapInfo, facilityPath);
                        ++matched;
                        NotifySnmpTrapBean.m_log.debug((Object)"onMessage() : sendmessage ");
                        break;
                    }
                    if (matched != 0 || genericId == 6) ** GOTO lbl95
                    NotifySnmpTrapBean.m_log.debug((Object)"onMessage() : re-search generic trap");
                    for (i = 0; i < oidList.size(); ++i) {
                        oidInfo = oidList.get(i);
                        if (!oidInfo.getTrapOid().equals(TrapSnmp.GENERIC_TRAPS.get(genericId).toString())) continue;
                        mib = oidInfo.getMib();
                        priority = oidInfo.getPriority();
                        msg = oidInfo.getLogmsg();
                        msgOrg = oidInfo.getDescr();
                        pk = new SnmpTrapMasterPK(mib, TrapSnmp.GENERIC_TRAPS.get(genericId).toString(), genericId, specificId);
                        master = select.getMasterInfo(pk);
                        this.sendMassage(msg, msgOrg, info, master, priority, snmpTrapInfo, facilityPath);
                        NotifySnmpTrapBean.m_log.debug((Object)"onMessage() : sendmessage ");
                    }
                }
                catch (EJBException e) {
                }
                catch (Exception e) {
                }
                finally {
                    if (repository != null) {
                        try {
                            repository.remove();
                        }
                        catch (Exception e) {}
                    }
                    repository = null;
                }
            } else {
                NotifySnmpTrapBean.m_log.debug((Object)("onMessage(): ObjectMessage is not an expected instance. " + obj.toString()));
            }
        }
lbl95:
        // 13 sources

        NotifySnmpTrapBean.m_log.debug((Object)"onMessage() : end ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMassage(String msg, String msgOrg, SnmpTrapMessageInfo info, SnmpTrapMasterInfo master, int priority, MonitorSnmpTrapInfo snmpTrapInfo, String facilityPath) {
        String regex;
        int j;
        String[] values;
        m_log.debug((Object)("sendMassage() start:" + info.getMonitorId() + " " + info.getFacilityId() + " " + info.getTrapOid()));
        SendQueue sendQueue = null;
        try {
            sendQueue = new SendQueue("queue/clustercontrol/Monitor/EventLog");
        }
        catch (NamingException e1) {
            m_log.error((Object)("sendMassage()" + e1.getMessage()));
        }
        catch (JMSException e1) {
            m_log.error((Object)("sendMassage()" + e1.getMessage()));
        }
        if (msg != null && !"".equals(msg)) {
            values = info.getVarBindValue();
            for (j = 0; j < values.length; ++j) {
                regex = "%parm\\[#" + Integer.toString(j + 1) + "\\]%";
                msg = msg.replaceAll(regex, values[j]);
            }
        } else {
            msg = "";
        }
        if (msgOrg == null || "".equals(msgOrg)) {
            msgOrg = master.getDescr();
        }
        if (msgOrg != null && !"".equals(msgOrg)) {
            values = info.getVarBindValue();
            for (j = 0; j < values.length; ++j) {
                regex = "%parm\\[#" + Integer.toString(j + 1) + "\\]%";
                msgOrg = msgOrg.replaceAll(regex, values[j]);
            }
        } else {
            msgOrg = "";
        }
        LogOutputNotifyInfo notifyInfo = new LogOutputNotifyInfo();
        notifyInfo.setMonitorId(info.getMonitorId());
        notifyInfo.setPluginId("SNMPTRAP");
        notifyInfo.setPriority(priority);
        notifyInfo.setNotifyId(snmpTrapInfo.getNotifyId());
        notifyInfo.setApplication(snmpTrapInfo.getApplication());
        notifyInfo.setFacilityId(info.getFacilityId());
        notifyInfo.setScopeText(facilityPath);
        notifyInfo.setGenerationDate(info.getTrapDate());
        String messageId = null;
        messageId = priority == 3 ? "001" : (priority == 2 ? "002" : (priority == 0 ? "003" : "004"));
        notifyInfo.setMessageId(messageId);
        m_log.debug((Object)("sendMassage() : message length " + Integer.toString(msg.length())));
        if (msg.length() > 255) {
            notifyInfo.setMessage(msg.substring(0, 255));
        } else {
            notifyInfo.setMessage(msg);
        }
        Object[] args = new String[]{info.getTrapOid(), master.getUei()};
        notifyInfo.setMessageOrg(Messages.getString((String)"message.snmptrap.3", (Object[])args) + "\n" + msgOrg);
        if (snmpTrapInfo.getJobRun() == 1 && !info.getFacilityId().equals("UNREGISTERED")) {
            for (MonitorNumericValueInfo mnvi : snmpTrapInfo.getJudgementInfo()) {
                if (mnvi.getPriority() != notifyInfo.getPriority() || mnvi.getJobRun() != 1) continue;
                LogOutputJobRunInfo jobRunInfo = new LogOutputJobRunInfo();
                jobRunInfo.setJobRun(mnvi.getJobRun());
                jobRunInfo.setJobId(mnvi.getJobId());
                jobRunInfo.setJobInhibitionFlg(mnvi.getJobInhibitionFlg());
                jobRunInfo.setJobFailurePriority(mnvi.getJobFailurePriority());
                notifyInfo.setJobRun(jobRunInfo);
            }
        }
        try {
            sendQueue.put((Serializable)notifyInfo);
        }
        catch (Exception e) {
            m_log.error((Object)("onMessage() : \u76e3\u8996\u7ba1\u7406\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
        }
        finally {
            if (sendQueue != null) {
                try {
                    sendQueue.terminate();
                }
                catch (JMSException e) {
                    m_log.error((Object)("Terminate SendQueue Failed : " + e.getMessage()));
                }
            }
        }
    }
}

