/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorStatusBean;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorStatusDAO;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorStatusPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollectorStatusDAOImpl
implements CollectorStatusDAO {
    protected static Log m_log = LogFactory.getLog(CollectorStatusDAO.class);

    public void init() {
        m_log.trace((Object)"init CollectorStatusDAO");
    }

    public void load(CollectorStatusPK pk, CollectorStatusBean ejb) throws EJBException {
        block15: {
            m_log.debug((Object)("load() start : " + pk.getCollectorID()));
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM COLLECTOR_STATUS WHERE COLLECTORID = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.collectorID);
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setCollectorID(res.getString("COLLECTORID"));
                    ejb.setRunStatus(res.getShort("RUN_STATUS"));
                    ejb.setErrorStatus(res.getShort("ERROR_STATUS"));
                    ejb.setEndStatus(res.getShort("END_STATUS"));
                    ejb.setCount(res.getInt("COUNT"));
                    Timestamp timestamp = res.getTimestamp("LAST_COLLECT_DATE");
                    if (timestamp != null) {
                        ejb.setLastCollectDate(new Date(timestamp.getTime()));
                    } else {
                        ejb.setLastCollectDate(null);
                    }
                    break block15;
                }
                String msg = "CollectorStatus data is not found.";
                m_log.error((Object)("load() error : " + pk.getCollectorID() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.getCollectorID() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (res != null) {
                        res.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.getCollectorID() + " SQLException"));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end   : " + pk.getCollectorID()));
    }

    public void store(CollectorStatusBean ejb) throws EJBException {
        m_log.debug((Object)("store() start :" + ejb.getCollectorID()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "UPDATE COLLECTOR_STATUS SET RUN_STATUS = ?,ERROR_STATUS = ?,END_STATUS = ?,COUNT = ?,LAST_COLLECT_DATE = ? WHERE COLLECTORID = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setShort(1, (short)ejb.getRunStatus());
            stmt.setShort(2, (short)ejb.getErrorStatus());
            stmt.setShort(3, (short)ejb.getEndStatus());
            stmt.setInt(4, ejb.getCount());
            Date lastCollectDate = ejb.getLastCollectDate();
            if (lastCollectDate != null) {
                stmt.setTimestamp(5, new Timestamp(lastCollectDate.getTime()));
            } else {
                stmt.setTimestamp(5, null);
            }
            stmt.setString(6, ejb.getCollectorID());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("store() error : " + ejb.getCollectorID() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("store() error : " + ejb.getCollectorID() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getCollectorID() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("store() end   :" + ejb.getCollectorID()));
    }

    public void remove(CollectorStatusPK pk) throws EJBException {
        m_log.debug((Object)("remove()  start: " + pk.getCollectorID()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM COLLECTOR_STATUS WHERE COLLECTORID = ? ";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.collectorID);
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.getCollectorID()));
    }

    public CollectorStatusPK create(CollectorStatusBean ejb) throws CreateException, EJBException, DuplicateKeyException {
        CollectorStatusPK pk;
        block13: {
            m_log.debug((Object)("create() start : " + ejb.getCollectorID()));
            Connection conn = null;
            pk = new CollectorStatusPK();
            Statement stmt = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "INSERT INTO COLLECTOR_STATUS (COLLECTORID, RUN_STATUS,ERROR_STATUS,END_STATUS,COUNT,LAST_COLLECT_DATE)values (?,?,?,?,?,?);";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, ejb.getCollectorID());
                stmt.setShort(2, (short)ejb.getRunStatus());
                stmt.setShort(3, (short)ejb.getErrorStatus());
                stmt.setShort(4, (short)ejb.getEndStatus());
                stmt.setInt(5, ejb.getCount());
                stmt.setTimestamp(6, null);
                int row = stmt.executeUpdate();
                if (row == 1) {
                    pk = new CollectorStatusPK(ejb.getCollectorID());
                    break block13;
                }
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getCollectorID() + " SQLException"));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("23505")) {
                    m_log.error((Object)("create() error : " + ejb.getCollectorID() + "DuplicateKeyException "));
                    throw new DuplicateKeyException(e.getMessage());
                }
                m_log.error((Object)("create() error :" + ejb.toString() + " EJBException "));
                throw new CreateException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("create() error : " + ejb.getCollectorID() + " SQLException"));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getCollectorID()));
        return pk;
    }

    public CollectorStatusPK findByPrimaryKey(CollectorStatusPK pk) throws FinderException, EJBException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findbyPK() start : " + pk.getCollectorID()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM COLLECTOR_STATUS WHERE COLLECTORID = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.collectorID);
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            CollectorStatusPK collectorStatusPK = pk;
            Object var8_9 = null;
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findbyPK() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findbyPK() end : " + pk.getCollectorID()));
            return collectorStatusPK;
        }
        try {
            try {
                String msg = "id " + pk.getCollectorID() + " not found.";
                m_log.error((Object)("findbyPK() error : " + pk.toString() + " SQLException"));
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("findbyPK() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findbyPK() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findbyPK() end : " + pk.getCollectorID()));
            throw throwable;
        }
    }
}

