/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.bean;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QuartzConstant {
    private static Log m_log = LogFactory.getLog(QuartzConstant.class);
    public static final String GROUP_COLLECT = "PERF_COLLECT";
    public static final String GROUP_MONITOR = "PERF_MONITOR";
    public static final String JNDI_NAME = "CollectorLocal";
    public static final String QUARTZ_NAME = QuartzConstant.getQuartzName();
    public static final String JNDI_NAME_PERF_MNG = "CollectorRunController";
    public static final String METHOD_NAME_PERF_MNG = "managePresavePeriod";
    private static int delayTimeUnder1min = -1;
    private static int delayTimeOver1min = -1;

    public static String getQuartzName() {
        try {
            Properties properties = QuartzConstant.getProperties();
            return properties.getProperty("QuartzJndiName");
        }
        catch (Exception e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static int getDelayTimeUnder1min() {
        if (delayTimeUnder1min == -1) {
            try {
                Properties properties = QuartzConstant.getProperties();
                String time = properties.getProperty("performance.delaytime.under1min");
                delayTimeUnder1min = Integer.parseInt(time);
            }
            catch (Exception e) {
                delayTimeUnder1min = 3;
            }
        }
        return delayTimeUnder1min;
    }

    public static int getDelayTimeOver1min() {
        if (delayTimeOver1min == -1) {
            try {
                Properties properties = QuartzConstant.getProperties();
                String time = properties.getProperty("performance.delaytime.over1min");
                delayTimeOver1min = Integer.parseInt(time);
            }
            catch (Exception e) {
                delayTimeOver1min = 10;
            }
        }
        return delayTimeOver1min;
    }

    private static Properties getProperties() throws IOException, FileNotFoundException {
        Properties properties = new Properties();
        Locale locale = Locale.getDefault();
        String homeDir = System.getProperty("jboss.server.home.dir");
        String confDir = homeDir + File.separator + "conf" + File.separator;
        String propertyFile = locale.getLanguage().equals("ja") ? confDir + "performance_ja.properties" : confDir + "performance.properties";
        properties.load(new FileInputStream(propertyFile));
        return properties;
    }
}

