/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPlatformEnvironment;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.Assert;
import org.eclipse.update.internal.core.FileFragment;
import org.eclipse.update.internal.core.FragmentEntry;
import org.eclipse.update.internal.core.IWritable;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.Response;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateCore;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

public class UpdateManagerUtils {
    private static boolean OS_UNIX = "hpux".equals(Platform.getOS()) || "aix".equals(Platform.getOS()) || "linux".equals(Platform.getOS()) || "solaris".equals(Platform.getOS());
    private static FragmentEntry[] noFragments = new FragmentEntry[0];
    private static Map table = new HashMap();
    private static Writer writer;
    private static Map urlFileMap;
    private static Map localFileFragmentMap;
    private static Stack bufferPool;
    private static final int BUFFER_SIZE = 4096;
    private static final int INCREMENT_SIZE = 10240;

    static {
        table.put("compatible", new Integer(3));
        table.put("perfect", new Integer(1));
        table.put("equivalent", new Integer(2));
        table.put("greaterOrEqual", new Integer(4));
    }

    public static URL getURL(URL rootURL, String urlString, String defaultURL) throws MalformedURLException {
        URL url = null;
        if (urlString == null || urlString.trim().equals("")) {
            if (defaultURL == null || defaultURL.trim().equals("")) {
                return null;
            }
            urlString = defaultURL;
        }
        if (urlString.startsWith("/") && urlString.length() > 1) {
            urlString = urlString.substring(1);
        }
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            url = new URL(rootURL, urlString);
        }
        return url;
    }

    public static String getURLAsString(URL rootURL, URL url) {
        String result = null;
        if (rootURL == null) {
            return url == null ? null : url.toString();
        }
        if (url != null) {
            String urlFileString;
            int index;
            result = url.toExternalForm();
            if (rootURL.getHost() != null && !rootURL.getHost().equals(url.getHost())) {
                return result;
            }
            if (rootURL.getProtocol() != null && !rootURL.getProtocol().equals(url.getProtocol())) {
                return result;
            }
            if (rootURL.getPort() != url.getPort()) {
                return result;
            }
            String rootURLFileString = rootURL.getFile();
            if (!(rootURLFileString = rootURLFileString.replace(File.separatorChar, '/')).endsWith("/") && (index = rootURLFileString.lastIndexOf(47)) != -1) {
                rootURLFileString = rootURLFileString.substring(0, index);
            }
            if ((urlFileString = url.getFile()).startsWith(rootURLFileString)) {
                result = urlFileString.substring(rootURLFileString.length());
                result = result.replace(File.separatorChar, '/');
            } else {
                if ("file".equalsIgnoreCase(url.getProtocol())) {
                    File urlFile;
                    File rootFile = new File(rootURLFileString);
                    File relativePath = urlFile = new File(urlFileString);
                    while (relativePath != null && !rootFile.equals(relativePath.getParentFile())) {
                        relativePath = relativePath.getParentFile();
                    }
                    if (relativePath == null) {
                        UpdateCore.warn("Cannot calculate relative path");
                        return url.toString();
                    }
                    String relativeRootString = relativePath.getParentFile().getAbsolutePath();
                    String fullString = urlFile.getAbsolutePath();
                    if (!fullString.startsWith(relativeRootString)) {
                        UpdateCore.warn("Full path:" + fullString + " does not start with " + relativeRootString);
                        return url.toString();
                    }
                    String returnString = fullString.substring(relativeRootString.length() + 1);
                    if (urlFile.isDirectory()) {
                        returnString = String.valueOf(returnString) + File.separator;
                    }
                    returnString = returnString.replace(File.separatorChar, '/');
                    return returnString;
                }
                result = url.toString();
            }
        }
        return result;
    }

    public static String getResourceString(String infoURL, ResourceBundle bundle) {
        String result = null;
        if (infoURL != null) {
            result = Platform.getResourceString((Bundle)UpdateCore.getPlugin().getBundle(), (String)infoURL, (ResourceBundle)bundle);
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL copyToLocal(InputStream sourceContentReferenceStream, String localName, InstallMonitor monitor) throws MalformedURLException, IOException, InstallAbortedException {
        File dir;
        URL result = null;
        File localFile = new File(localName);
        int index = localFile.getPath().lastIndexOf(File.separator);
        if (index != -1 && !(dir = new File(localFile.getPath().substring(0, index))).exists()) {
            dir.mkdirs();
        }
        if (localFile.isDirectory()) return localFile.toURL();
        FileOutputStream localContentReferenceStream = new FileOutputStream(localFile);
        try {
            Utilities.copy(sourceContentReferenceStream, localContentReferenceStream, monitor);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                ((OutputStream)localContentReferenceStream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException iOException) {}
        ((OutputStream)localContentReferenceStream).close();
        return localFile.toURL();
    }

    public static void checkPermissions(ContentReference ref, String filePath) {
        if (ref.getPermission() != 0) {
            UpdateCore.warn("Change permission for " + filePath + " to " + ref.getPermission());
        }
        if (filePath != null && OS_UNIX && ref.getPermission() != 0) {
            try {
                Process pr = Runtime.getRuntime().exec(new String[]{"chmod", "a+x", filePath});
                StreamConsumer chmodOutput = new StreamConsumer(pr.getInputStream());
                chmodOutput.setName("chmod output reader");
                chmodOutput.start();
                StreamConsumer chmodError = new StreamConsumer(pr.getErrorStream());
                chmodError.setName("chmod error reader");
                chmodError.start();
            }
            catch (IOException iOException) {}
        }
    }

    public static String getLocalRandomIdentifier(String remotePath, Date date) {
        String ext;
        int dotIndex = remotePath.lastIndexOf(".");
        int fileIndex = remotePath.lastIndexOf(File.separator);
        String string = ext = dotIndex != -1 && fileIndex < dotIndex ? remotePath.substring(dotIndex) : "";
        if (fileIndex == -1) {
            fileIndex = 0;
        }
        if (dotIndex == -1) {
            dotIndex = remotePath.length();
        }
        String name = fileIndex < dotIndex ? remotePath.substring(fileIndex, dotIndex) : "Eclipse_Update_TMP_";
        String result = String.valueOf(name) + date.getTime() + ext;
        return result;
    }

    public static void removeFromFileSystem(File file) {
        String[] files;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.list()) != null) {
            int i = 0;
            while (i < files.length) {
                UpdateManagerUtils.removeFromFileSystem(new File(file, files[i]));
                ++i;
            }
        }
        if (!file.delete()) {
            String msg = NLS.bind((String)Messages.UpdateManagerUtils_UnableToRemoveFile, (Object[])new String[]{file.getAbsolutePath()});
            UpdateCore.log(msg, new Exception());
        }
    }

    public static void removeEmptyDirectoriesFromFileSystem(File file) {
        if (!file.isDirectory()) {
            return;
        }
        String[] files = file.list();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                UpdateManagerUtils.removeEmptyDirectoriesFromFileSystem(new File(file, files[i]));
                ++i;
            }
        }
        if (!file.delete()) {
            String msg = NLS.bind((String)Messages.UpdateManagerUtils_UnableToRemoveFile, (Object[])new String[]{file.getAbsolutePath()});
            UpdateCore.log(msg, new Exception());
        }
    }

    public static IPluginEntry[] diff(IPluginEntry[] sourceArray, IPluginEntry[] targetArray) {
        if (sourceArray == null || sourceArray.length == 0) {
            return new IPluginEntry[0];
        }
        if (targetArray == null || targetArray.length == 0) {
            return sourceArray;
        }
        List<IPluginEntry> list1 = Arrays.asList(targetArray);
        ArrayList<IPluginEntry> result = new ArrayList<IPluginEntry>(0);
        int i = 0;
        while (i < sourceArray.length) {
            if (!list1.contains(sourceArray[i])) {
                result.add(sourceArray[i]);
            }
            ++i;
        }
        IPluginEntry[] resultEntry = new IPluginEntry[result.size()];
        if (result.size() > 0) {
            result.toArray(resultEntry);
        }
        return resultEntry;
    }

    public static URL getParent(URL url) {
        String file = url.getFile();
        int len = file.length();
        if (len == 0 || len == 1 && file.charAt(0) == '/') {
            return null;
        }
        int lastSlashIndex = -1;
        int i = len - 2;
        while (lastSlashIndex == -1 && i >= 0) {
            if (file.charAt(i) == '/') {
                lastSlashIndex = i;
            }
            --i;
        }
        file = lastSlashIndex == -1 ? "" : file.substring(0, lastSlashIndex + 1);
        try {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
        }
        catch (MalformedURLException e) {
            Assert.isTrue(false, e.getMessage());
        }
        return url;
    }

    public static URL asDirectoryURL(URL url) throws MalformedURLException {
        String path = url.getFile();
        if (!path.endsWith("/")) {
            int index = path.lastIndexOf(47);
            if (index != -1) {
                path = path.substring(0, index + 1);
            }
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
        }
        return url;
    }

    public static boolean sameURL(URL url1, URL url2) {
        if (url1 == null || url2 == null) {
            return false;
        }
        if (url1 == url2) {
            return true;
        }
        if (url1.equals(url2)) {
            return true;
        }
        if (!"file".equalsIgnoreCase(url1.getProtocol())) {
            return false;
        }
        if (!"file".equalsIgnoreCase(url2.getProtocol())) {
            return false;
        }
        File file1 = UpdateManagerUtils.getFileFor(url1);
        File file2 = UpdateManagerUtils.getFileFor(url2);
        if (file1 == null) {
            return false;
        }
        return file1.equals(file2);
    }

    private static File getFileFor(URL url1) {
        if (urlFileMap == null) {
            urlFileMap = new HashMap();
        }
        if (urlFileMap.get(url1) != null) {
            return (File)urlFileMap.get(url1);
        }
        File newFile = new File(url1.getFile());
        urlFileMap.put(url1, newFile);
        return newFile;
    }

    public static IFeatureReference[] getParentFeatures(IFeature childFeature, IFeatureReference[] possiblesParent, boolean onlyOptional) throws CoreException {
        if (childFeature == null) {
            return new IFeatureReference[0];
        }
        ArrayList<IFeatureReference> parentList = new ArrayList<IFeatureReference>();
        IIncludedFeatureReference[] children = null;
        IFeature compareFeature = null;
        int i = 0;
        while (i < possiblesParent.length) {
            block13: {
                try {
                    IFeature possibleParentFeature = possiblesParent[i].getFeature(null);
                    if (possibleParentFeature == null) break block13;
                    children = possibleParentFeature.getIncludedFeatureReferences();
                    int j = 0;
                    while (j < children.length) {
                        try {
                            compareFeature = children[j].getFeature(null);
                        }
                        catch (CoreException e) {
                            UpdateCore.warn("", e);
                        }
                        if (childFeature.equals(compareFeature)) {
                            if (onlyOptional) {
                                if (UpdateManagerUtils.isOptional(children[j])) {
                                    parentList.add(possiblesParent[i]);
                                } else {
                                    UpdateCore.warn("Feature :" + children[j] + " not optional. Not included in parents list.");
                                }
                            } else {
                                parentList.add(possiblesParent[i]);
                            }
                        }
                        ++j;
                    }
                }
                catch (CoreException e) {
                    UpdateCore.warn("", e);
                }
            }
            ++i;
        }
        IFeatureReference[] parents = new IFeatureReference[]{};
        if (parentList.size() > 0) {
            parents = new IFeatureReference[parentList.size()];
            parentList.toArray(parents);
        }
        return parents;
    }

    public static IFeatureReference[] getParentFeatures(IFeatureReference child, IFeatureReference[] possiblesParent, boolean onlyOptional) throws CoreException {
        if (child == null) {
            return new IFeatureReference[0];
        }
        IFeature childFeature = null;
        try {
            childFeature = child.getFeature(null);
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
        }
        if (childFeature == null) {
            return new IFeatureReference[0];
        }
        return UpdateManagerUtils.getParentFeatures(childFeature, possiblesParent, onlyOptional);
    }

    public static void checkConnectionResult(Response response, URL url) throws IOException {
        int result = response.getStatusCode();
        if (result != 200) {
            String serverMsg = response.getStatusMessage();
            throw new IOException(NLS.bind((String)Messages.ContentReference_HttpNok, (Object[])new Object[]{new Integer(result), serverMsg, url}));
        }
    }

    public static IFeatureReference[] optionalChildrenToInstall(IFeatureReference[] children, IFeatureReference[] optionalfeatures) {
        ArrayList<IFeatureReference> optionalChildrenToInstall = new ArrayList<IFeatureReference>();
        int i = 0;
        while (i < children.length) {
            IFeatureReference optionalFeature = children[i];
            if (!UpdateManagerUtils.isOptional(optionalFeature)) {
                optionalChildrenToInstall.add(optionalFeature);
            } else {
                int j = 0;
                while (j < optionalfeatures.length) {
                    if (optionalFeature.equals(optionalfeatures[j])) {
                        optionalChildrenToInstall.add(optionalFeature);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        IFeatureReference[] result = new IFeatureReference[optionalChildrenToInstall.size()];
        if (optionalChildrenToInstall.size() > 0) {
            optionalChildrenToInstall.toArray(result);
        }
        return result;
    }

    public static int getMatchingRule(String rule) {
        if (rule == null) {
            return 1;
        }
        int ruleInt = (Integer)table.get(rule);
        if (ruleInt == 0) {
            return 1;
        }
        return ruleInt;
    }

    public static int getMatchingIdRule(String rule) {
        if (rule != null && rule.equalsIgnoreCase("prefix")) {
            return 1;
        }
        return 1;
    }

    public static boolean isOptional(IFeatureReference featureReference) {
        if (featureReference == null) {
            return false;
        }
        if (featureReference instanceof IIncludedFeatureReference) {
            return ((IIncludedFeatureReference)featureReference).isOptional();
        }
        return false;
    }

    public static boolean isValidEnvironment(IPlatformEnvironment candidate) {
        if (candidate == null) {
            return false;
        }
        String os = candidate.getOS();
        String ws = candidate.getWS();
        String arch = candidate.getOSArch();
        String nl = candidate.getNL();
        if (os != null && !UpdateManagerUtils.isMatching(os, SiteManager.getOS())) {
            return false;
        }
        if (ws != null && !UpdateManagerUtils.isMatching(ws, SiteManager.getWS())) {
            return false;
        }
        if (arch != null && !UpdateManagerUtils.isMatching(arch, SiteManager.getOSArch())) {
            return false;
        }
        return nl == null || UpdateManagerUtils.isMatchingLocale(nl, SiteManager.getNL());
    }

    private static boolean isMatching(String candidateValues, String siteValues) {
        if (siteValues == null) {
            return false;
        }
        if ("*".equals(candidateValues)) {
            return true;
        }
        if ("".equals(candidateValues)) {
            return true;
        }
        StringTokenizer siteTokens = new StringTokenizer(siteValues, ",");
        while (siteTokens.hasMoreTokens()) {
            StringTokenizer candidateTokens = new StringTokenizer(candidateValues, ",");
            String siteValue = siteTokens.nextToken();
            while (candidateTokens.hasMoreTokens()) {
                if (!siteValue.equalsIgnoreCase(candidateTokens.nextToken())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isMatchingLocale(String candidateValues, String locale) {
        if (locale == null) {
            return false;
        }
        if ("*".equals(candidateValues)) {
            return true;
        }
        if ("".equals(candidateValues)) {
            return true;
        }
        locale = locale.toUpperCase();
        candidateValues = candidateValues.toUpperCase();
        StringTokenizer stok = new StringTokenizer(candidateValues, ",");
        while (stok.hasMoreTokens()) {
            String candidate = stok.nextToken();
            if (locale.indexOf(candidate) == 0) {
                return true;
            }
            if (candidate.indexOf(locale) != 0) continue;
            return true;
        }
        return false;
    }

    public static Writer getWriter(File file, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        if (writer == null) {
            writer = new Writer();
        }
        writer.init(file, encoding);
        return writer;
    }

    public static boolean isSameTimestamp(URL url, long timestamp) {
        try {
            URL resolvedURL = URLEncoder.encode(url);
            Response response = UpdateCore.getPlugin().get(resolvedURL);
            long remoteLastModified = response.getLastModified();
            return Math.abs(remoteLastModified - timestamp) / 1000L <= 2L;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static synchronized void mapLocalFileFragment(String key, FileFragment temp) {
        if (key != null) {
            if (localFileFragmentMap == null) {
                localFileFragmentMap = new HashMap();
            }
            localFileFragmentMap.put(key, temp);
        }
    }

    public static synchronized void unMapLocalFileFragment(String key) {
        if (key != null && localFileFragmentMap != null) {
            localFileFragmentMap.remove(key);
        }
    }

    public static synchronized FileFragment lookupLocalFileFragment(String key) {
        if (localFileFragmentMap == null) {
            return null;
        }
        return (FileFragment)localFileFragmentMap.get(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long copy(InputStream is, OutputStream os, InstallMonitor monitor, long expectedLength) {
        byte[] buf;
        block11: {
            long l;
            block10: {
                buf = UpdateManagerUtils.getBuffer();
                long offset = 0L;
                try {
                    try {
                        int len = is.read(buf);
                        int nextIncrement = 0;
                        while (len != -1) {
                            os.write(buf, 0, len);
                            offset += (long)len;
                            if (monitor != null) {
                                if ((nextIncrement += len) >= 10240) {
                                    monitor.incrementCount(nextIncrement);
                                    nextIncrement = 0;
                                }
                                if (monitor.isCanceled()) {
                                    l = offset;
                                    Object var10_11 = null;
                                    break block10;
                                }
                            }
                            if (expectedLength > 0L && offset == expectedLength) break;
                            len = is.read(buf);
                        }
                        if (nextIncrement > 0 && monitor != null) {
                            monitor.incrementCount(nextIncrement);
                        }
                        if (expectedLength > 0L && offset != expectedLength) {
                            throw new IOException(NLS.bind((String)Messages.UpdateManagerUtils_inputStreamEnded, (Object[])new String[]{String.valueOf(offset), String.valueOf(expectedLength)}));
                        }
                        break block11;
                    }
                    catch (IOException e) {
                        UpdateCore.log(String.valueOf(Messages.UpdateManagerUtils_copy) + offset, e);
                        long l2 = offset;
                        Object var10_13 = null;
                        UpdateManagerUtils.freeBuffer(buf);
                        return l2;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    UpdateManagerUtils.freeBuffer(buf);
                    throw throwable;
                }
            }
            UpdateManagerUtils.freeBuffer(buf);
            return l;
        }
        Object var10_12 = null;
        UpdateManagerUtils.freeBuffer(buf);
        return -1L;
    }

    private static synchronized byte[] getBuffer() {
        if (bufferPool == null) {
            return new byte[4096];
        }
        try {
            return (byte[])bufferPool.pop();
        }
        catch (EmptyStackException emptyStackException) {
            return new byte[4096];
        }
    }

    private static synchronized void freeBuffer(byte[] buf) {
        if (bufferPool == null) {
            bufferPool = new Stack();
        }
        bufferPool.push(buf);
    }

    public static FragmentEntry[] getFragments(Bundle bundle) {
        PackageAdmin pkgAdmin = UpdateCore.getPlugin().getPackageAdmin();
        Bundle[] fragmentBundles = pkgAdmin.getFragments(bundle);
        if (fragmentBundles == null) {
            return noFragments;
        }
        FragmentEntry[] fragments = new FragmentEntry[fragmentBundles.length];
        int i = 0;
        while (i < fragments.length) {
            fragments[i] = new FragmentEntry((String)fragmentBundles[i].getHeaders().get("Bundle-SymbolicName"), (String)fragmentBundles[i].getHeaders().get("Bundle-Version"), Platform.getResourceString((Bundle)fragmentBundles[i], (String)((String)fragmentBundles[i].getHeaders().get("Bundle-Version"))), fragmentBundles[i].getLocation());
            ++i;
        }
        return fragments;
    }

    public static String getWritableXMLString(String value) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static class StreamConsumer
    extends Thread {
        InputStream is;
        byte[] buf;

        public StreamConsumer(InputStream inputStream) {
            this.setDaemon(true);
            this.is = inputStream;
            this.buf = new byte[512];
        }

        public void run() {
            try {
                int n = 0;
                while (n >= 0) {
                    n = this.is.read(this.buf);
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static class Writer {
        private PrintWriter w;
        private OutputStream out;
        private OutputStreamWriter outWriter;
        private BufferedWriter buffWriter;
        private String encoding;

        private Writer() {
        }

        public void init(File file, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
            this.encoding = encoding;
            this.out = new FileOutputStream(file);
            this.outWriter = new OutputStreamWriter(this.out, encoding);
            this.buffWriter = new BufferedWriter(this.outWriter);
            this.w = new PrintWriter(this.buffWriter);
        }

        public void write(IWritable element) {
            this.w.println("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
            this.w.println("");
            this.w.println("<!-- File written by Update manager 2.0 -->");
            this.w.println("<!-- comments in this file are not preserved -->");
            this.w.println("");
            element.write(0, this.w);
            this.close();
        }

        public void close() {
            this.w.close();
        }

        private static void appendEscapedChar(StringBuffer buffer, char c) {
            String replacement = Writer.getReplacement(c);
            if (replacement != null) {
                buffer.append('&');
                buffer.append(replacement);
                buffer.append(';');
            } else if (c >= ' ' && c <= '~' || c == '\n' || c == '\r' || c == '\t') {
                buffer.append(c);
            } else {
                buffer.append("&#");
                buffer.append(Integer.toString(c));
                buffer.append(';');
            }
        }

        public static String xmlSafe(String s) {
            StringBuffer result = new StringBuffer(s.length() + 10);
            int i = 0;
            while (i < s.length()) {
                Writer.appendEscapedChar(result, s.charAt(i));
                ++i;
            }
            return result.toString();
        }

        private static String getReplacement(char c) {
            switch (c) {
                case '<': {
                    return "lt";
                }
                case '>': {
                    return "gt";
                }
                case '\"': {
                    return "quot";
                }
                case '\'': {
                    return "apos";
                }
                case '&': {
                    return "amp";
                }
            }
            return null;
        }
    }

    public static class CopyException
    extends Exception {
        private static final long serialVersionUID = 1L;
        Exception rootException;
        int bytesCopied;

        public CopyException(Exception rootException, int bytesCopied) {
            this.rootException = rootException;
            this.bytesCopied = bytesCopied;
        }

        public Exception getRootException() {
            return this.rootException;
        }

        public int getBytesCopied() {
            return this.bytesCopied;
        }
    }
}

