/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureFactory;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.FeatureModel;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.ErrorRecoveryLog;
import org.eclipse.update.internal.core.FeatureTypeFactory;
import org.eclipse.update.internal.core.ISiteContentConsumer;
import org.eclipse.update.internal.core.InstallHandlerProxy;
import org.eclipse.update.internal.core.InstallRegistry;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.SiteFileContentConsumer;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteFile
extends Site {
    private List pluginEntries = new ArrayList(0);

    public ISiteContentConsumer createSiteContentConsumer(IFeature targetFeature) throws CoreException {
        SiteFileContentConsumer consumer = new SiteFileContentConsumer(targetFeature);
        consumer.setSite(this);
        return consumer;
    }

    public String getDefaultPackagedFeatureType() {
        return "org.eclipse.update.core.installed";
    }

    public IFeatureReference install(IFeature sourceFeature, IVerificationListener verificationListener, IProgressMonitor progress) throws CoreException {
        return this.install(sourceFeature, null, verificationListener, progress);
    }

    public IFeatureReference install(IFeature sourceFeature, IFeatureReference[] optionalfeatures, IVerificationListener verificationListener, IProgressMonitor progress) throws CoreException {
        if (sourceFeature == null) {
            return null;
        }
        InstallMonitor monitor = progress == null ? null : (progress instanceof InstallMonitor ? (InstallMonitor)progress : new InstallMonitor(progress));
        IFeature localFeature = this.createExecutableFeature(sourceFeature);
        IFeatureReference localFeatureReference = null;
        localFeatureReference = sourceFeature.install(localFeature, optionalfeatures, verificationListener, monitor);
        return localFeatureReference;
    }

    public IFeatureReference install(IFeature sourceFeature, IFeatureReference[] optionalfeatures, IFeatureContentConsumer parentContentConsumer, IVerifier parentVerifier, IVerificationListener verificationListener, IProgressMonitor progress) throws InstallAbortedException, CoreException {
        if (sourceFeature == null) {
            return null;
        }
        InstallMonitor monitor = progress == null ? null : (progress instanceof InstallMonitor ? (InstallMonitor)progress : new InstallMonitor(progress));
        IFeature localFeature = this.createExecutableFeature(sourceFeature);
        parentContentConsumer.addChild(localFeature);
        IVerifier vr = sourceFeature.getFeatureContentProvider().getVerifier();
        if (vr != null) {
            vr.setParent(parentVerifier);
        }
        IFeatureReference localFeatureReference = null;
        localFeatureReference = sourceFeature.install(localFeature, optionalfeatures, verificationListener, monitor);
        return localFeatureReference;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(IFeature feature, IProgressMonitor progress) throws CoreException {
        block35: {
            if (feature == null) {
                UpdateCore.warn("Feature to remove is null");
                return;
            }
            recoveryLog = ErrorRecoveryLog.getLog();
            monitor = progress == null ? null : (progress instanceof InstallMonitor != false ? (InstallMonitor)progress : new InstallMonitor(progress));
            handler = new InstallHandlerProxy(4, feature, feature.getInstallHandlerEntry(), monitor);
            success = false;
            originalException = null;
            try {
                try {
                    recoveryLog.open("REMOVE_LOG");
                    this.aboutToRemove(feature);
                    recoveryLog.append("END_ABOUT_TO_REMOVE");
                    handler.uninstallInitiated();
                    pluginsToRemove = this.getPluginEntriesOnlyReferencedBy(feature);
                    if (monitor != null) {
                        monitor.beginTask(String.valueOf(Messages.SiteFile_Removing) + feature.getLabel(), pluginsToRemove.length + 1);
                    }
                    if ((featureReferences = this.getFeatureReferences()) != null) {
                        indexRef = 0;
                        while (indexRef < featureReferences.length) {
                            element = featureReferences[indexRef];
                            if (element.getVersionedIdentifier().equals(feature.getVersionedIdentifier())) {
                                this.removeFeatureReferenceModel((FeatureReferenceModel)element);
                                break;
                            }
                            ++indexRef;
                        }
                    }
                    if (InstallRegistry.getInstance().get("feature_" + feature.getVersionedIdentifier()) == null) {
                        UpdateCore.log(NLS.bind((String)Messages.SiteFile_featureNotRemoved, (Object[])new String[]{feature.getVersionedIdentifier().toString()}), null);
                    } else {
                        references = feature.getFeatureContentProvider().getFeatureEntryArchiveReferences(monitor);
                        i = 0;
                        while (true) {
                            if (i >= references.length) {
                                InstallRegistry.unregisterFeature(feature);
                                break;
                            }
                            try {
                                UpdateManagerUtils.removeFromFileSystem(references[i].asFile());
                                if (monitor != null) {
                                    monitor.worked(1);
                                }
                            }
                            catch (IOException e) {
                                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFile_CannotRemoveFeature, (Object[])new String[]{feature.getVersionedIdentifier().getIdentifier(), this.getURL().toExternalForm()}), e);
                            }
                            ++i;
                        }
                    }
                    i = 0;
                    while (true) {
                        if (i >= pluginsToRemove.length) break;
                        this.remove(feature, pluginsToRemove[i], monitor);
                        ++i;
                    }
                    childrenRef = feature.getIncludedFeatureReferences();
                    i = 0;
                    while (true) {
                        if (i >= childrenRef.length) {
                            this.removeFeatureFromCache(feature.getURL());
                            handler.completeUninstall();
                            success = true;
                        }
                        childFeature = null;
                        try {
                            childFeature = childrenRef[i].getFeature(null);
                        }
                        catch (CoreException v0) {
                            UpdateCore.warn("Unable to retrieve feature to remove for:" + childrenRef[i]);
                        }
                        if (childFeature != null && !this.getCurrentConfiguredSite().isConfigured(childFeature)) {
                            this.remove(childrenRef[i].getFeature(null), monitor);
                        }
                        ++i;
                    }
                }
                catch (Throwable t) {
                    originalException = t;
                }
            }
            catch (Throwable var14_20) {
                var13_21 = null;
                newException = null;
                try {
                    if (success) {
                        recoveryLog.close("END_REMOVE_LOG");
                        recoveryLog.delete();
                    } else {
                        recoveryLog.close("END_REMOVE_LOG");
                    }
                    handler.uninstallCompleted(success);
                }
                catch (Throwable t) {
                    newException = t;
                }
                if (originalException != null) {
                    throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{feature.getLabel()}), originalException);
                }
                if (newException != null) {
                    throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{feature.getLabel()}), newException);
                }
                throw var14_20;
            }
            {
                var13_22 = null;
                newException = null;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 547->583)] { 
lbl95:
            // 1 sources

            if (success) {
                recoveryLog.close("END_REMOVE_LOG");
                recoveryLog.delete();
            } else {
                recoveryLog.close("END_REMOVE_LOG");
            }
            handler.uninstallCompleted(success);
            break block35;
lbl102:
            // 1 sources

            catch (Throwable t) {
                newException = t;
            }
        }
        if (originalException != null) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{feature.getLabel()}), originalException);
        }
        if (newException != null) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{feature.getLabel()}), newException);
        }
    }

    public long getDownloadSizeFor(IFeature feature) {
        long result = 0L;
        IPluginEntry[] entriesToInstall = feature.getPluginEntries();
        IPluginEntry[] siteEntries = this.getPluginEntries();
        entriesToInstall = UpdateManagerUtils.diff(entriesToInstall, siteEntries);
        INonPluginEntry[] nonPluginEntriesToInstall = feature.getNonPluginEntries();
        try {
            result = feature.getFeatureContentProvider().getDownloadSizeFor(entriesToInstall, nonPluginEntriesToInstall);
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
            result = -1L;
        }
        return result;
    }

    public long getInstallSizeFor(IFeature feature) {
        long result = 0L;
        try {
            ArrayList<IPluginEntry> pluginsToInstall = new ArrayList<IPluginEntry>();
            pluginsToInstall.addAll(Arrays.asList(feature.getPluginEntries()));
            IIncludedFeatureReference[] children = feature.getIncludedFeatureReferences();
            IFeature currentFeature = null;
            int i = 0;
            while (i < children.length) {
                currentFeature = children[i].getFeature(null);
                if (currentFeature != null) {
                    pluginsToInstall.addAll(Arrays.asList(currentFeature.getPluginEntries()));
                }
                ++i;
            }
            IPluginEntry[] entriesToInstall = new IPluginEntry[]{};
            if (pluginsToInstall.size() > 0) {
                entriesToInstall = new IPluginEntry[pluginsToInstall.size()];
                pluginsToInstall.toArray(entriesToInstall);
            }
            IPluginEntry[] siteEntries = this.getPluginEntries();
            entriesToInstall = UpdateManagerUtils.diff(entriesToInstall, siteEntries);
            INonPluginEntry[] nonPluginEntriesToInstall = feature.getNonPluginEntries();
            result = feature.getFeatureContentProvider().getInstallSizeFor(entriesToInstall, nonPluginEntriesToInstall);
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
            result = -1L;
        }
        return result;
    }

    public void addPluginEntry(IPluginEntry pluginEntry) {
        this.pluginEntries.add(pluginEntry);
    }

    public IPluginEntry[] getPluginEntries() {
        IPluginEntry[] result = new IPluginEntry[]{};
        if (this.pluginEntries != null && !this.pluginEntries.isEmpty()) {
            result = new IPluginEntry[this.pluginEntries.size()];
            this.pluginEntries.toArray(result);
        }
        return result;
    }

    public int getPluginEntryCount() {
        return this.getPluginEntries().length;
    }

    private IFeature createExecutableFeature(IFeature sourceFeature) throws CoreException {
        IFeature result = null;
        IFeatureFactory factory = FeatureTypeFactory.getInstance().getFactory("org.eclipse.update.core.installed");
        result = factory.createFeature(null, this, null);
        ((FeatureModel)((Object)result)).setFeatureIdentifier(sourceFeature.getVersionedIdentifier().getIdentifier());
        ((FeatureModel)((Object)result)).setFeatureVersion(sourceFeature.getVersionedIdentifier().getVersion().toString());
        return result;
    }

    private void remove(IFeature feature, IPluginEntry pluginEntry, InstallMonitor monitor) throws CoreException {
        if (pluginEntry == null) {
            return;
        }
        if (InstallRegistry.getInstance().get("plugin_" + pluginEntry.getVersionedIdentifier()) == null) {
            UpdateCore.log(NLS.bind((String)Messages.SiteFile_pluginNotRemoved, (Object[])new String[]{pluginEntry.getVersionedIdentifier().toString()}), null);
            return;
        }
        ContentReference[] references = feature.getFeatureContentProvider().getPluginEntryArchiveReferences(pluginEntry, monitor);
        int i = 0;
        while (i < references.length) {
            try {
                UpdateManagerUtils.removeFromFileSystem(references[i].asFile());
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            catch (IOException e) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFile_CannotRemovePlugin, (Object[])new String[]{pluginEntry.getVersionedIdentifier().toString(), this.getURL().toExternalForm()}), e);
            }
            ++i;
        }
        this.pluginEntries.remove(pluginEntry);
        InstallRegistry.unregisterPlugin(pluginEntry);
    }

    private void aboutToRemove(IFeature feature) throws CoreException {
        ErrorRecoveryLog.getLog();
    }
}

