/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.dialog;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.monitor.run.composite.StringRunJobComposite;
import com.clustercontrol.monitor.run.util.StringValueInfoManager;
import com.clustercontrol.notify.composite.NotifyIdListComposite;
import com.clustercontrol.util.Messages;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StringValueInfoCreateDialog
extends CommonDialog {
    public static final int WIDTH_TITLE = 5;
    public static final int WIDTH_VALUE = 2;
    private MonitorStringValueInfo m_inputData = null;
    private ValidateResult m_validateResult = null;
    private String m_identifier = null;
    private int m_order = Integer.MAX_VALUE;
    private Text m_textDescription = null;
    private Text m_textPattern = null;
    private Button m_radioNotProcess = null;
    private Button m_radioProcess = null;
    private NotifyIdListComposite m_notifyId = null;
    private Combo m_comboPriority = null;
    private Text m_textMessageId = null;
    private Text m_textMessage = null;
    private Button m_checkJobRun = null;
    private StringRunJobComposite m_jobRun = null;
    private Button m_buttonValid = null;

    public StringValueInfoCreateDialog(Shell parent) {
        super(parent);
    }

    public StringValueInfoCreateDialog(Shell parent, String identifier) {
        super(parent);
        this.m_identifier = identifier;
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString("dialog.monitor.run.create.modify.string"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("description")) + " : ");
        this.m_textDescription = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textDescription.setLayoutData((Object)gridData);
        this.m_textDescription.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("monitor.rule")) + " : ");
        Group monitorRuleGroup = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        monitorRuleGroup.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        monitorRuleGroup.setLayoutData((Object)gridData);
        label = new Label((Composite)monitorRuleGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("pattern.matching.expression")) + " : ");
        this.m_textPattern = new Text((Composite)monitorRuleGroup, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textPattern.setLayoutData((Object)gridData);
        this.m_textPattern.addVerifyListener((VerifyListener)new StringVerifyListener(1024));
        this.m_radioNotProcess = new Button(parent, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_radioNotProcess.setLayoutData((Object)gridData);
        this.m_radioNotProcess.setText(Messages.getString("don't.process.if.matched"));
        this.m_radioProcess = new Button(parent, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_radioProcess.setLayoutData((Object)gridData);
        this.m_radioProcess.setText(Messages.getString("process.if.matched"));
        this.m_radioProcess.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringValueInfoCreateDialog.this.setEnabled(StringValueInfoCreateDialog.this.m_radioProcess.getSelection());
            }
        });
        Group group = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        group.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gridData);
        this.m_notifyId = new NotifyIdListComposite((Composite)group, 0, true);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_notifyId.setLayoutData(gridData);
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("priority")) + " : ");
        this.m_comboPriority = new Combo((Composite)group, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboPriority.setLayoutData((Object)gridData);
        this.m_comboPriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_comboPriority.add(PriorityConstant.STRING_WARNING);
        this.m_comboPriority.add(PriorityConstant.STRING_INFO);
        this.m_comboPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_comboPriority.setText(PriorityConstant.STRING_CRITICAL);
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("message.id")) + " : ");
        this.m_textMessageId = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textMessageId.setLayoutData((Object)gridData);
        this.m_textMessageId.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("message")) + " : ");
        this.m_textMessage = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textMessage.setLayoutData((Object)gridData);
        this.m_textMessage.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        this.m_checkJobRun = new Button((Composite)group, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_checkJobRun.setLayoutData((Object)gridData);
        this.m_checkJobRun.setText(String.valueOf(Messages.getString("run")) + " : ");
        this.m_checkJobRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringValueInfoCreateDialog.this.m_jobRun.setEnabled(StringValueInfoCreateDialog.this.m_checkJobRun.getSelection());
            }
        });
        Group groupRunJob = new Group((Composite)group, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRunJob.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupRunJob.setLayoutData((Object)gridData);
        this.m_jobRun = new StringRunJobComposite((Composite)groupRunJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_jobRun.setLayoutData(gridData);
        this.m_buttonValid = new Button(parent, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonValid.setLayoutData((Object)gridData);
        this.m_buttonValid.setText(Messages.getString("setting.valid.confirmed"));
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData((Object)gridData);
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        MonitorStringValueInfo info = StringValueInfoManager.getInstance().get(this.m_identifier);
        if (info == null) {
            info = new MonitorStringValueInfo();
        }
        this.setInputData(info);
    }

    public MonitorStringValueInfo getInputData() {
        return this.m_inputData;
    }

    protected void setInputData(MonitorStringValueInfo info) {
        this.m_inputData = info;
        this.m_identifier = info.getIdentifier();
        this.m_order = info.getOrderNo();
        if (info.getDescription() != null) {
            this.m_textDescription.setText(info.getDescription());
        }
        if (info.getPattern() != null) {
            this.m_textPattern.setText(info.getPattern());
        }
        if (info.getProcessType() == 1) {
            this.m_radioProcess.setSelection(true);
        } else {
            this.m_radioNotProcess.setSelection(true);
        }
        if (info.getNotifyId() != null) {
            this.m_notifyId.setText(info.getNotifyId());
        }
        this.m_comboPriority.setText(PriorityConstant.typeToString(info.getPriority()));
        if (info.getMessageId() != null) {
            this.m_textMessageId.setText(info.getMessageId());
        }
        if (info.getMessage() != null) {
            this.m_textMessage.setText(info.getMessage());
        }
        this.m_checkJobRun.setSelection(YesNoConstant.typeToBoolean(info.getJobRun()));
        this.m_jobRun.setInputData(info);
        if (info.isValidFlg()) {
            this.m_buttonValid.setSelection(true);
        }
        this.setEnabled(this.m_radioProcess.getSelection());
    }

    protected MonitorStringValueInfo createInputData() {
        MonitorStringValueInfo info = new MonitorStringValueInfo();
        info.setIdentifier(this.m_identifier);
        info.setOrderNo(this.m_order);
        if (this.m_textDescription.getText() == null || "".equals(this.m_textDescription.getText().trim())) {
            this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.26"));
            return null;
        }
        info.setDescription(this.m_textDescription.getText());
        if (this.m_textPattern.getText() != null && !"".equals(this.m_textPattern.getText().trim())) {
            try {
                Pattern.compile(this.m_textPattern.getText());
                info.setPattern(this.m_textPattern.getText());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.27"));
                return null;
            }
        } else {
            this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.27"));
            return null;
        }
        if (this.m_radioProcess.getSelection()) {
            info.setProcessType(1);
        } else {
            info.setProcessType(0);
        }
        String priorityText = this.m_comboPriority.getText();
        info.setPriority(PriorityConstant.stringToType(priorityText));
        String notifyId = this.m_notifyId.getText();
        if (notifyId != null && !"".equals(notifyId.trim())) {
            info.setNotifyId(notifyId);
        }
        if (this.m_textMessageId.getText() != null && !"".equals(this.m_textMessageId.getText().trim())) {
            info.setMessageId(this.m_textMessageId.getText());
        } else if (this.m_radioProcess.getSelection()) {
            this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.28"));
            return null;
        }
        if (this.m_textMessage.getText() != null && !"".equals(this.m_textMessage.getText().trim())) {
            info.setMessage(this.m_textMessage.getText());
        } else if (this.m_radioProcess.getSelection()) {
            this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.29"));
            return null;
        }
        info.setJobRun(YesNoConstant.booleanToType(this.m_checkJobRun.getSelection()));
        this.m_validateResult = this.m_jobRun.createInputData(info);
        if (this.m_validateResult != null) {
            return null;
        }
        if (this.m_buttonValid.getSelection()) {
            info.setValidFlg(true);
        } else {
            info.setValidFlg(false);
        }
        return info;
    }

    protected ValidateResult validate() {
        this.m_inputData = this.createInputData();
        if (this.m_inputData != null) {
            return super.validate();
        }
        return this.m_validateResult;
    }

    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

    private void setEnabled(boolean enable) {
        if (enable) {
            this.m_jobRun.setEnabled(this.m_checkJobRun.getSelection());
        } else {
            this.m_jobRun.setEnabled(enable);
        }
        this.m_notifyId.setEnabled(enable);
        this.m_comboPriority.setEnabled(enable);
        this.m_textMessageId.setEnabled(enable);
        this.m_textMessage.setEnabled(enable);
        this.m_checkJobRun.setEnabled(enable);
    }

    private void setValidateResult(String id, String message) {
        this.m_validateResult = new ValidateResult();
        this.m_validateResult.setValid(false);
        this.m_validateResult.setID(id);
        this.m_validateResult.setMessage(message);
    }
}

