/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.composite.MonitorBasicComposite;
import com.clustercontrol.util.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MonitorBasicScopeComposite
extends MonitorBasicComposite {
    protected Text m_textScope = null;
    protected Button m_buttonScope = null;
    protected String m_facilityId = null;
    protected boolean m_unregistered = false;

    public MonitorBasicScopeComposite(Composite parent, int style, boolean unregistered) {
        super(parent, style);
        this.m_unregistered = unregistered;
        this.initialize();
    }

    public MonitorBasicScopeComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("scope")) + " : ");
        this.m_textScope = new Text((Composite)this, 18440);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textScope.setLayoutData((Object)gridData);
        this.m_buttonScope = new Button((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonScope.setLayoutData((Object)gridData);
        this.m_buttonScope.setText(Messages.getString("refer"));
        this.m_buttonScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ScopeTreeDialog dialog = new ScopeTreeDialog(shell, false, MonitorBasicScopeComposite.this.m_unregistered);
                if (dialog.open() == 0) {
                    FacilityTreeItem item = dialog.getSelectItem();
                    FacilityInfo info = item.getData();
                    MonitorBasicScopeComposite.this.m_facilityId = info.getFacilityId();
                    if (info.getType() == 1) {
                        MonitorBasicScopeComposite.this.m_textScope.setText(info.getFacilityName());
                    } else {
                        FacilityPath path = new FacilityPath(ClusterControlPlugin.getDefault().getSeparator());
                        MonitorBasicScopeComposite.this.m_textScope.setText(path.getPath(item));
                    }
                }
            }
        });
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    public void setInputData(MonitorInfo info) {
        super.setInputData(info);
        if (info != null) {
            if (info.getScope() != null) {
                this.m_textScope.setText(info.getScope());
            }
            if (info.getFacilityId() != null) {
                this.m_facilityId = info.getFacilityId();
            }
        }
    }

    public ValidateResult createInputData(MonitorInfo info) {
        if (info != null) {
            ValidateResult validateResult = super.createInputData(info);
            if (validateResult != null) {
                return validateResult;
            }
            if (this.m_textScope.getText() != null && !"".equals(this.m_textScope.getText().trim())) {
                info.setFacilityId(this.m_facilityId);
            } else {
                return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.hinemos.3"));
            }
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_textScope.setEnabled(enabled);
        this.m_buttonScope.setEnabled(enabled);
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }
}

