/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.port.ejb.session;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.port.factory.AddMonitorPort;
import com.clustercontrol.port.factory.DeleteMonitorPort;
import com.clustercontrol.port.factory.ModifyMonitorPort;
import com.clustercontrol.port.factory.SelectMonitorPort;
import java.rmi.RemoteException;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public abstract class MonitorPortControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(MonitorPortControllerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public boolean addPort(MonitorInfo info) throws CreateException, FinderException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        Principal pri = this.m_context.getCallerPrincipal();
        AddMonitorPort port = new AddMonitorPort();
        return port.add(info, pri.getName());
    }

    public boolean modifyPort(MonitorInfo info) throws CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyMonitorPort port = new ModifyMonitorPort();
        return port.modify(info, pri.getName());
    }

    public boolean deletePort(String monitorId) throws FinderException, RemoveException, SchedulerException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        DeleteMonitorPort port = new DeleteMonitorPort();
        return port.delete("PORT", monitorId);
    }

    public MonitorInfo getPort(String monitorId) throws CreateException, FinderException, SchedulerException, NamingException {
        SelectMonitorPort port = new SelectMonitorPort();
        MonitorInfo info = port.getMonitor("PORT", monitorId);
        return info;
    }

    public ArrayList getPortList() throws CreateException, FinderException, SchedulerException, NamingException {
        SelectMonitorPort port = new SelectMonitorPort();
        ArrayList list = port.getMonitorList("PORT");
        return list;
    }

    public ArrayList getPortListTableDefine(Locale locale) {
        SelectMonitorPort port = new SelectMonitorPort();
        ArrayList tableDefine = port.getMonitorListTableDefine(locale);
        return tableDefine;
    }
}

