/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.metadata.unmarshalling.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.metadata.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.metadata.unmarshalling.BasicElementBinding;
import org.jboss.xb.binding.metadata.unmarshalling.DocumentBinding;
import org.jboss.xb.binding.metadata.unmarshalling.ElementBinding;
import org.jboss.xb.binding.metadata.unmarshalling.NamespaceBinding;
import org.jboss.xb.binding.metadata.unmarshalling.TopElementBinding;
import org.jboss.xb.binding.metadata.unmarshalling.XmlValueBinding;
import org.jboss.xb.binding.metadata.unmarshalling.impl.AttributeBindingImpl;
import org.jboss.xb.binding.metadata.unmarshalling.impl.DocumentBindingFactoryImpl;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public class XsdBinder {
    private static final Logger log = Logger.getLogger(XsdBinder.class);
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$ArrayList;

    private XsdBinder() {
    }

    public static DocumentBinding bindXsd(String xsdUrl) {
        return XsdBinder.bindXsd(xsdUrl, null);
    }

    public static DocumentBinding bindXsd(String xsdUrl, DocumentBinding delegate) {
        DocumentBindingImpl localDoc = delegate instanceof DocumentBindingImpl ? (DocumentBindingImpl)delegate : new DocumentBindingImpl(delegate);
        XSModel model = XsdBinder.loadSchema(xsdUrl);
        StringList namespaces = model.getNamespaces();
        for (int i = 0; i < namespaces.getLength(); ++i) {
            String namespaceUri = namespaces.item(i);
            NamespaceBindingImpl ns = localDoc.bindNamespace(namespaceUri);
            XSNamedMap components = model.getComponentsByNamespace((short)2, namespaceUri);
            for (int j = 0; j < components.getLength(); ++j) {
                XSElementDeclaration element = (XSElementDeclaration)components.item(j);
                XsdBinder.bindTopElement(localDoc, ns, element);
            }
        }
        return localDoc;
    }

    private static final void bindTopElement(DocumentBinding doc, NamespaceBindingImpl ns, XSElementDeclaration element) {
        TopElementBindingImpl top = new TopElementBindingImpl((NamespaceBinding)ns, element);
        ns.addTopElement(top);
        XsdBinder.bindComplexElement(element, doc, top);
    }

    private static void bindComplexElement(XSElementDeclaration elementDecl, DocumentBinding doc, ParentElement parentBinding) {
        XSComplexTypeDefinition complexType;
        XSParticle particle;
        XSTypeDefinition type = elementDecl.getTypeDefinition();
        if (type.getTypeCategory() == 15 && (particle = (complexType = (XSComplexTypeDefinition)type).getParticle()) != null) {
            XsdBinder.bindParticle(doc, parentBinding, particle);
        }
    }

    private static void bindParticle(DocumentBinding doc, ParentElement parent, XSParticle particle) {
        XSTerm term = particle.getTerm();
        switch (term.getType()) {
            case 7: {
                XsdBinder.bindModelGroup(doc, parent, (XSModelGroup)term);
                break;
            }
            case 9: {
                break;
            }
            case 2: {
                XsdBinder.bindElement(doc, parent, (XSElementDeclaration)term);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected term type: " + term.getType());
            }
        }
    }

    private static void bindElement(DocumentBinding doc, ParentElement parent, XSElementDeclaration elementDecl) {
        ElementBindingImpl child = new ElementBindingImpl((BasicElementBinding)parent, elementDecl);
        parent.addChild(child);
        XsdBinder.bindComplexElement(elementDecl, doc, child);
    }

    private static void bindModelGroup(DocumentBinding doc, ParentElement parent, XSModelGroup modelGroup) {
        XSObjectList particles = modelGroup.getParticles();
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            XsdBinder.bindParticle(doc, parent, particle);
        }
    }

    private static XSModel loadSchema(String xsdURL) {
        XSImplementation impl = XsdBinder.getXSImplementation();
        XSLoader schemaLoader = impl.createXSLoader(null);
        XSModel model = schemaLoader.loadURI(xsdURL);
        if (model == null) {
            throw new IllegalArgumentException("Invalid URI for schema: " + xsdURL);
        }
        return model;
    }

    private static XSImplementation getXSImplementation() {
        XSImplementation impl;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            String name = "org.apache.xerces.dom.DOMXSImplementationSourceImpl";
            Class<?> c = loader.loadClass(name);
            System.setProperty("org.w3c.dom.DOMImplementationSourceList", name);
        }
        catch (ClassNotFoundException e) {
            String name = "org.apache.xerces.dom.DOMXSImplementationSourceImpl";
            System.setProperty("org.w3c.dom.DOMImplementationSourceList", name);
        }
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            impl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
        }
        catch (Exception e) {
            log.error("Failed to create schema loader.", e);
            throw new IllegalStateException("Failed to create schema loader: " + e.getMessage());
        }
        return impl;
    }

    static interface ParentElement
    extends BasicElementBinding {
        public void addChild(BasicElementBinding var1);
    }

    private static class TopElementBindingImpl
    extends DocumentBindingFactoryImpl.AbstractTopElementBinding
    implements ParentElement {
        private final XSElementDeclaration elementDecl;
        private final Map children = new HashMap();
        protected Class javaType;

        public TopElementBindingImpl(NamespaceBinding ns, XSElementDeclaration elementDecl) {
            super(ns, elementDecl.getName());
            this.elementDecl = elementDecl;
        }

        private void init() {
            NamespaceBinding ns;
            DocumentBinding doc = this.ns.getDocument();
            XSTypeDefinition typeDef = this.elementDecl.getTypeDefinition();
            String typeBasedClsName = null;
            if ("http://www.w3.org/2001/XMLSchema".equals(typeDef.getNamespace())) {
                this.javaType = SimpleTypeBindings.classForType(typeDef.getName());
            } else if (typeDef.getName() != null) {
                ns = doc.getNamespace(typeDef.getNamespace());
                typeBasedClsName = ns.getJavaPackage() + "." + Util.xmlNameToClassName(typeDef.getName(), true);
                try {
                    this.javaType = Thread.currentThread().getContextClassLoader().loadClass(typeBasedClsName);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (this.javaType == null) {
                ns = doc.getNamespace(this.elementDecl.getNamespace());
                String elBasedClsName = ns.getJavaPackage() + "." + Util.xmlNameToClassName(this.elementDecl.getName(), true);
                try {
                    this.javaType = Thread.currentThread().getContextClassLoader().loadClass(elBasedClsName);
                }
                catch (ClassNotFoundException e1) {
                    throw new JBossXBRuntimeException("Failed to bind element " + this.name + " using XSD type (" + typeBasedClsName + ") and element name (" + elBasedClsName + "): classes not found.");
                }
            }
        }

        protected Class getJavaTypeLocal() {
            if (this.javaType == null) {
                this.init();
            }
            return this.javaType;
        }

        protected ElementBinding getElementLocal(QName elementName) {
            return (ElementBinding)this.children.get(elementName);
        }

        protected AttributeBinding getAttributeLocal(QName attributeName) {
            String fieldName = Util.xmlNameToClassName(attributeName.getLocalPart(), true);
            fieldName = Character.toLowerCase(fieldName.charAt(0)) + fieldName.substring(1);
            return new AttributeBindingImpl(attributeName, null, this.getJavaType(), fieldName);
        }

        protected XmlValueBinding getValueLocal() {
            throw new UnsupportedOperationException("getValueLocal is not implemented.");
        }

        public void addChild(BasicElementBinding child) {
            this.children.put(child.getName(), child);
        }
    }

    private static final class ElementBindingImpl
    extends DocumentBindingFactoryImpl.AbstractElementBinding
    implements ParentElement {
        private final XSElementDeclaration elementDecl;
        private final Map children = new HashMap();
        private Class javaType;
        private Class fieldType;
        private Method getter;
        private Method setter;
        private Field field;

        public ElementBindingImpl(BasicElementBinding parent, XSElementDeclaration elementDecl) {
            super(parent, new QName(elementDecl.getNamespace(), elementDecl.getName()));
            this.elementDecl = elementDecl;
        }

        private void init() {
            Class parentType;
            DocumentBinding doc = this.parent.getDocument();
            XSTypeDefinition typeDef = this.elementDecl.getTypeDefinition();
            String typeBasedClsName = null;
            if ("http://www.w3.org/2001/XMLSchema".equals(typeDef.getNamespace())) {
                this.javaType = SimpleTypeBindings.classForType(typeDef.getName());
            } else if (typeDef.getName() != null) {
                NamespaceBinding ns = doc.getNamespace(typeDef.getNamespace());
                typeBasedClsName = ns.getJavaPackage() + "." + Util.xmlNameToClassName(typeDef.getName(), true);
                try {
                    this.javaType = Thread.currentThread().getContextClassLoader().loadClass(typeBasedClsName);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            String elBasedClsName = Util.xmlNameToClassName(this.elementDecl.getName(), true);
            if (this.javaType == null) {
                NamespaceBinding ns = doc.getNamespace(this.elementDecl.getNamespace());
                try {
                    this.javaType = Thread.currentThread().getContextClassLoader().loadClass(ns.getJavaPackage() + "." + elBasedClsName);
                }
                catch (ClassNotFoundException e1) {
                    // empty catch block
                }
            }
            if ((class$java$util$Collection == null ? (class$java$util$Collection = XsdBinder.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(parentType = this.parent.getJavaType())) {
                if (this.javaType == null) {
                    this.javaType = class$java$lang$String == null ? (class$java$lang$String = XsdBinder.class$("java.lang.String")) : class$java$lang$String;
                }
            } else {
                try {
                    this.getter = parentType.getMethod("get" + elBasedClsName, null);
                    this.fieldType = this.getter.getReturnType();
                    try {
                        this.setter = parentType.getMethod("set" + elBasedClsName, this.getter.getReturnType());
                    }
                    catch (NoSuchMethodException e) {
                        this.setter = null;
                    }
                }
                catch (NoSuchMethodException e) {
                    String fieldName = Util.xmlNameToFieldName(this.elementDecl.getName(), true);
                    try {
                        this.field = parentType.getField(fieldName);
                        this.fieldType = this.field.getType();
                    }
                    catch (NoSuchFieldException e1) {
                        // empty catch block
                    }
                }
                if (this.fieldType != null) {
                    if (Modifier.isFinal(this.fieldType.getModifiers()) || this.javaType == null && !Modifier.isInterface(this.fieldType.getModifiers()) && !Modifier.isAbstract(this.fieldType.getModifiers())) {
                        this.javaType = this.fieldType;
                    } else if (this.fieldType == (class$java$util$Collection == null ? (class$java$util$Collection = XsdBinder.class$("java.util.Collection")) : class$java$util$Collection) || (class$java$util$Collection == null ? (class$java$util$Collection = XsdBinder.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(this.fieldType)) {
                        if (this.javaType == null) {
                            this.javaType = class$java$util$ArrayList == null ? (class$java$util$ArrayList = XsdBinder.class$("java.util.ArrayList")) : class$java$util$ArrayList;
                        }
                    } else if (this.javaType != null && this.javaType != this.fieldType && !this.fieldType.isAssignableFrom(this.javaType)) {
                        this.javaType = null;
                    }
                }
            }
            if (this.javaType == null) {
                throw new JBossXBRuntimeException("Failed to bind element " + this.name + " to any non-abstract Java type. Parent is " + parentType + ", field is " + this.fieldType + ", base=" + elBasedClsName);
            }
        }

        protected Field getFieldLocal() {
            if (this.javaType == null) {
                this.init();
            }
            return this.field;
        }

        protected Method getGetterLocal() {
            if (this.javaType == null) {
                this.init();
            }
            return this.getter;
        }

        protected Method getSetterLocal() {
            if (this.javaType == null) {
                this.init();
            }
            return this.setter;
        }

        protected Class getFieldTypeLocal() {
            if (this.javaType == null) {
                this.init();
            }
            return this.fieldType;
        }

        protected Class getJavaTypeLocal() {
            if (this.javaType == null) {
                this.init();
            }
            return this.javaType;
        }

        protected ElementBinding getElementLocal(QName elementName) {
            return (ElementBinding)this.children.get(elementName);
        }

        protected AttributeBinding getAttributeLocal(QName attributeName) {
            String fieldName = Util.xmlNameToClassName(attributeName.getLocalPart(), true);
            fieldName = Character.toLowerCase(fieldName.charAt(0)) + fieldName.substring(1);
            return new AttributeBindingImpl(attributeName, null, this.getJavaType(), fieldName);
        }

        protected XmlValueBinding getValueLocal() {
            throw new UnsupportedOperationException("getValueLocal is not implemented.");
        }

        public void addChild(BasicElementBinding child) {
            this.children.put(child.getName(), child);
        }
    }

    private static final class NamespaceBindingImpl
    extends DocumentBindingFactoryImpl.AbstractNamespaceBinding {
        private final Map tops = new HashMap();

        public NamespaceBindingImpl(DocumentBinding doc, String namespaceUri) {
            super(doc, namespaceUri);
        }

        protected String getJavaPackageLocal() {
            return Util.xmlNamespaceToJavaPackage(this.namespaceUri);
        }

        protected TopElementBinding getTopElementLocal(String elementName) {
            return (TopElementBinding)this.tops.get(elementName);
        }

        void addTopElement(TopElementBindingImpl top) {
            this.tops.put(top.getName().getLocalPart(), top);
        }
    }

    public static final class DocumentBindingImpl
    extends DocumentBindingFactoryImpl.AbstractDocumentBinding {
        private final Map namespaces = new HashMap();

        public DocumentBindingImpl(DocumentBinding doc) {
            super(doc);
        }

        NamespaceBindingImpl bindNamespace(String namespaceUri) {
            NamespaceBindingImpl ns = new NamespaceBindingImpl(this.doc, namespaceUri);
            this.namespaces.put(namespaceUri, ns);
            return ns;
        }

        protected NamespaceBinding getNamespaceLocal(String namespaceUri) {
            return (NamespaceBinding)this.namespaces.get(namespaceUri);
        }
    }
}

