package org.postgresforest;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

import org.postgresforest.apibase.*;
import org.postgresforest.constant.ErrorStr;
import org.postgresforest.exception.*;
import org.postgresforest.util.*;

import net.jcip.annotations.*;

@NotThreadSafe public class ForestResultSet implements ResultSet, ForestCloseable {
    
    private final EntrypointCommonResource epCommonResource;
    private final List<ResultSet> resList;
    private final int execServerId;
    
    public ForestResultSet(final EntrypointCommonResource epCommonResource, final List<ResultSet> resList, final int execServerId) {
        this.epCommonResource = epCommonResource;
        this.resList = resList;
        this.execServerId = execServerId;
    }
    
    private boolean isClosed = false;
    
    public boolean absolute(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void afterLast() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void beforeFirst() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void clearWarnings() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Void> task = new ResultSetTask.ClearWarning(resList.get(execServerId));
        epCommonResource.executeOneApi(task, execServerId);
        return;
    }
    
    public void deleteRow() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int findColumn(String arg0) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task = new ResultSetTask.FindColumn(resList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId).intValue();
    }
    
    public boolean first() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Array getArray(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Array getArray(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public InputStream getAsciiStream(int arg0) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<InputStream> task = new ResultSetTask.GetAsciiStream_Int(resList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public InputStream getAsciiStream(String arg0) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<InputStream> task = new ResultSetTask.GetAsciiStream_Str(resList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public BigDecimal getBigDecimal(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public BigDecimal getBigDecimal(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<BigDecimal> task = new ResultSetTask.GetBigDecimal_IntInt(resList.get(execServerId), arg0, arg1);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public BigDecimal getBigDecimal(String arg0, int arg1) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<BigDecimal> task = new ResultSetTask.GetBigDecimal_StrInt(resList.get(execServerId), arg0, arg1);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public InputStream getBinaryStream(int arg0) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<InputStream> task = new ResultSetTask.GetBinaryStream_Int(resList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public InputStream getBinaryStream(String arg0) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<InputStream> task = new ResultSetTask.GetBinaryStream_Str(resList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public Blob getBlob(int i) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Blob getBlob(String colName) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean getBoolean(int columnIndex) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task = new ResultSetTask.GetBoolean_Int(resList.get(execServerId), columnIndex);
        return epCommonResource.executeOneApi(task, execServerId).booleanValue();
    }
    
    public boolean getBoolean(String columnName) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task = new ResultSetTask.GetBoolean_Str(resList.get(execServerId), columnName);
        return epCommonResource.executeOneApi(task, execServerId).booleanValue();
    }
    
    public byte getByte(int columnIndex) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Byte> task = new ResultSetTask.GetByte_Int(resList.get(execServerId), columnIndex);
        return epCommonResource.executeOneApi(task, execServerId).byteValue();
    }
    
    public byte getByte(String columnName) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Byte> task = new ResultSetTask.GetByte_Str(resList.get(execServerId), columnName);
        return epCommonResource.executeOneApi(task, execServerId).byteValue();
    }
    
    public byte[] getBytes(int columnIndex) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<byte[]> task = new ResultSetTask.GetBytes_Int(resList.get(execServerId), columnIndex);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public byte[] getBytes(String columnName) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<byte[]> task = new ResultSetTask.GetBytes_Str(resList.get(execServerId), columnName);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Reader getCharacterStream(String columnName) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Clob getClob(int i) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Clob getClob(String colName) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int getConcurrency() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public String getCursorName() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task = new ResultSetTask.GetCursorName(resList.get(execServerId));
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public Date getDate(int columnIndex) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Date> task = new ResultSetTask.GetDate_Int(resList.get(execServerId), columnIndex);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public Date getDate(String columnName) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Date> task = new ResultSetTask.GetDate_Str(resList.get(execServerId), columnName);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public double getDouble(int columnIndex) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Double> task = new ResultSetTask.GetDouble_Int(resList.get(execServerId), columnIndex);
        return epCommonResource.executeOneApi(task, execServerId).doubleValue();
    }
    
    public double getDouble(String columnName) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Double> task = new ResultSetTask.GetDouble_Str(resList.get(execServerId), columnName);
        return epCommonResource.executeOneApi(task, execServerId).doubleValue();
    }
    
    public int getFetchDirection() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int getFetchSize() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public float getFloat(int columnIndex) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Float> task = new ResultSetTask.GetFloat_Int(resList.get(execServerId), columnIndex);
        return epCommonResource.executeOneApi(task, execServerId).floatValue();
    }
    
    public float getFloat(String columnName) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Float> task = new ResultSetTask.GetFloat_Str(resList.get(execServerId), columnName);
        return epCommonResource.executeOneApi(task, execServerId).floatValue();
    }
    
    public int getInt(int columnIndex) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task = new ResultSetTask.GetInt_Int(resList.get(execServerId), columnIndex);
        return epCommonResource.executeOneApi(task, execServerId).intValue();
    }
    
    public int getInt(String columnName) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task = new ResultSetTask.GetInt_Str(resList.get(execServerId), columnName);
        return epCommonResource.executeOneApi(task, execServerId).intValue();
    }
    
    public long getLong(int columnIndex) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Long> task = new ResultSetTask.GetLong_Int(resList.get(execServerId), columnIndex);
        return epCommonResource.executeOneApi(task, execServerId).longValue();
    }
    
    public long getLong(String columnName) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Long> task = new ResultSetTask.GetLong_Str(resList.get(execServerId), columnName);
        return epCommonResource.executeOneApi(task, execServerId).longValue();
    }
    
    public ResultSetMetaData getMetaData() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSetMetaData> task = new ResultSetTask.GetMetaData(resList.get(execServerId));
        final ResultSetMetaData rsmd = epCommonResource.executeOneApi(task, execServerId);
        final List<ResultSetMetaData> rsmdList = new ArrayList<ResultSetMetaData>(2);
        rsmdList.add(null);
        rsmdList.add(null);
        rsmdList.set(execServerId, rsmd);
        // XXX （縮退・閉塞）本来Statement系と同様にForestCloseableを実装してコントロールできるようにするべき
        return new ForestResultSetMetaData(epCommonResource, rsmdList, execServerId);
    }
    
    public Object getObject(int columnIndex) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Object> task = new ResultSetTask.GetObject_Int(resList.get(execServerId), columnIndex);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public Object getObject(String columnName) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Object> task = new ResultSetTask.GetObject_Str(resList.get(execServerId), columnName);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public Object getObject(int i, Map<String, Class<?>> map)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Object getObject(String colName, Map<String, Class<?>> map)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Ref getRef(int i) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Ref getRef(String colName) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int getRow() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public short getShort(int columnIndex) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Short> task = new ResultSetTask.GetShort_Int(resList.get(execServerId), columnIndex);
        return epCommonResource.executeOneApi(task, execServerId).shortValue();
    }
    
    public short getShort(String columnName) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Short> task = new ResultSetTask.GetShort_Str(resList.get(execServerId), columnName);
        return epCommonResource.executeOneApi(task, execServerId).shortValue();
    }
    
    public Statement getStatement() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public String getString(int columnIndex) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task = new ResultSetTask.GetString_Int(resList.get(execServerId), columnIndex);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public String getString(String columnName) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task = new ResultSetTask.GetString_Str(resList.get(execServerId), columnName);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public Time getTime(int columnIndex) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Time> task = new ResultSetTask.GetTime_Int(resList.get(execServerId), columnIndex);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public Time getTime(String columnName) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Time> task = new ResultSetTask.GetTime_Str(resList.get(execServerId), columnName);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Timestamp> task = new ResultSetTask.GetTimestamp_Int(resList.get(execServerId), columnIndex);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public Timestamp getTimestamp(String columnName) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Timestamp> task = new ResultSetTask.GetTimestamp_Str(resList.get(execServerId), columnName);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public Timestamp getTimestamp(int columnIndex, Calendar cal)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Timestamp getTimestamp(String columnName, Calendar cal)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int getType() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public URL getURL(String columnName) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<InputStream> task = new ResultSetTask.GetUnicodeStream_Int(resList.get(execServerId), columnIndex);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<InputStream> task = new ResultSetTask.GetUnicodeStream_Str(resList.get(execServerId), columnName);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public SQLWarning getWarnings() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<SQLWarning> task = new ResultSetTask.GetWarnings(resList.get(execServerId));
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public void insertRow() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean isAfterLast() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean isFirst() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean isLast() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean last() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void moveToInsertRow() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean next() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task = new ResultSetTask.Next(resList.get(execServerId));
        return epCommonResource.executeOneApi(task, execServerId).booleanValue();
    }
    
    public boolean previous() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void refreshRow() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean relative(int rows) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean rowDeleted() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean rowInserted() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean rowUpdated() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setFetchSize(int rows) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateAsciiStream(int columnIndex, InputStream x, int length)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateAsciiStream(String columnName, InputStream x, int length)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateBigDecimal(int columnIndex, BigDecimal x)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateBigDecimal(String columnName, BigDecimal x)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateBinaryStream(int columnIndex, InputStream x, int length)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateBinaryStream(String columnName, InputStream x, int length)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateCharacterStream(int columnIndex, Reader x, int length)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateCharacterStream(String columnName, Reader reader,
            int length) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateInt(String columnName, int x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateLong(String columnName, long x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateNull(String columnName) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateObject(int columnIndex, Object x, int scale)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateObject(String columnName, Object x, int scale)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateRow() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateShort(String columnName, short x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateString(String columnName, String x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateTimestamp(int columnIndex, Timestamp x)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void updateTimestamp(String columnName, Timestamp x)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean wasNull() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task = new ResultSetTask.WasNull(resList.get(execServerId));
        return epCommonResource.executeOneApi(task, execServerId).booleanValue();
    }
    
    public void close() throws SQLException {
        if (isClosed == false) {
            final Callable<Void> task0 = new ResultSetTask.Close(resList.get(0));
            final Callable<Void> task1 = new ResultSetTask.Close(resList.get(1));
            // closeは縮退対象としない。これは、close関数の中で仮に縮退などが発生すると
            // 内部から再度closeを呼ばれることになり、無限ループが発生するため
            epCommonResource.executeAllApiWithoutBroken(task0, task1);
        }
        isClosed = true;
    }
    
    public void closeOneSide(int serverId) {
        // 縮退で閉塞する場合にPostgreSQLのResultSetオブジェクトは
        // 閉塞しない。これは、既に解を取得済みの場合に、リソースを
        // 解放してしまうとその結果が得られないため
    }
    
}
