/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.vm.bean;

import com.clustercontrol.util.Messages;

/**
 * 
 * @version 3.1.0
 * @since 3.1.0
 */
public class NodeOperationStatusConstant {

	////////////////////////////////////
	// 実行状態(cc_vm_operation_detail.status)
	////////////////////////////////////


	
	//未開始
	public static Short READY = Short.valueOf("0");
	
	//実行中
	public static Short RUNNING = Short.valueOf("1");
	
	//終了
	public static Short STOP = Short.valueOf("2");
	
	//失敗
	public static Short FAIL = Short.valueOf("3");
	
	/**
	 * statusを名前に変える。
	 * 仮想化[操作ログ]で利用される。
	 * @param status
	 * @return
	 */
	public static String getName (Short status) {
		if (status == null) {
			return "";
		}
		if (status.compareTo(READY) == 0) {
			return Messages.getString("message.vm.operation.5");
		} else if (status.compareTo(RUNNING) == 0) {
			return Messages.getString("message.vm.operation.6");
		} else if (status.compareTo(STOP) == 0) {
			return Messages.getString("message.vm.operation.7");
		} else if (status.compareTo(FAIL) == 0) {
			return Messages.getString("message.vm.operation.8");
		} else {
			return status.toString();
		}
	}
}
