/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.composite;

import java.text.DateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityImageConstant;
import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.bean.LogListTabelDefine;

/**
 * フィルタ情報一覧のラベルプロバイダークラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class LogFilterInfoTableLabelProvider extends LabelProvider implements
        ITableLabelProvider {

    /**
     * カラム文字列を返します。
     * 
     * @since 1.0.0
     * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
     * @see com.clustercontrol.syslogng.bean.LogListTabelDefine
     */
    public String getColumnText(Object element, int columnIndex) {

        if (element instanceof LogFilterInfo) {
            LogFilterInfo filterInfo = (LogFilterInfo) element;

            if (columnIndex == LogListTabelDefine.ORDER_NO) {
                return Integer.toString(filterInfo.getOrderNo());
            } else if (columnIndex == LogListTabelDefine.PROCESS_TYPE) {
                return ProcessConstant
                        .typeToString(filterInfo.getProcessType());
            } else if (columnIndex == LogListTabelDefine.MONITOR_ID) {
                if (filterInfo.getMonitorId() != null) {
                    return filterInfo.getMonitorId();
                }
            } else if (columnIndex == LogListTabelDefine.DESCRIPTION) {
                if (filterInfo.getDescription() != null) {
                    return filterInfo.getDescription();
                }
            } else if (columnIndex == LogListTabelDefine.FACILITY_ID) {
                if (filterInfo.getScope() != null) {
                    return filterInfo.getScope();
                }
            } else if (columnIndex == LogListTabelDefine.CALENDAR_ID) {
                if (filterInfo.getCalendarId() != null) {
                    return filterInfo.getCalendarId();
                }
            } else if (columnIndex == LogListTabelDefine.VALID_FLG) {
                return ValidConstant.typeToString(filterInfo.getValid());
            } else if (columnIndex == LogListTabelDefine.CREATE_USER) {
                if (filterInfo.getRegUser() != null) {
                    return filterInfo.getRegUser();
                }
            } else if (columnIndex == LogListTabelDefine.UPDATE_USER) {
                if (filterInfo.getUpdateUser() != null) {
                    return filterInfo.getUpdateUser();
                }
            } else if (columnIndex == LogListTabelDefine.CREATE_TIME) {
            	if (filterInfo.getRegDate() != null) {
            		return DateFormat.getDateTimeInstance().format((Date) filterInfo.getRegDate());
                }
            } else if (columnIndex == LogListTabelDefine.UPDATE_TIME) {
            	if (filterInfo.getUpdateDate() != null) {
            		return DateFormat.getDateTimeInstance().format((Date) filterInfo.getUpdateDate());
                }
            }
        }
        return "";
    }

    /**
     * カラムイメージ(アイコン)を返します。
     * 
     * @since 1.0.0
     * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
     */
    public Image getColumnImage(Object element, int columnIndex) {

        if (element instanceof LogFilterInfo) {
            LogFilterInfo filterInfo = (LogFilterInfo) element;

            if (columnIndex == LogListTabelDefine.FACILITY_ID) {
                if (filterInfo.getFacilityId() != null) {
                    // データタイプが「ファシリティ」の処理
                    Pattern p = Pattern.compile(".*>");
                    Matcher m = p.matcher(filterInfo.getFacilityId());
                    if (m.matches()) {
                        return FacilityImageConstant
                                .typeToImage(FacilityConstant.TYPE_SCOPE);
                    } else {
                        return FacilityImageConstant
                                .typeToImage(FacilityConstant.TYPE_NODE);
                    }
                }
            }
        }
        return null;
    }
}