/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.bean;

/**
 * 監視[ステータス]ビューのテーブル定義を定数として格納するクラス<BR>
 * 
 * 監視[ステータス]ビューのテーブルの表示項目を表示順を定義しています。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class StatusTableDefine {

    // ----- static フィールド ----- //

    /** 重要度。 */
    public static final int PRIORITY = 0;

    /** プラグインID。 */
    public static final int PLUGIN_ID = 1;

    /** 監視項目ID。 */
    public static final int MONITOR_ID = 2;

    /** ファシリティID。 */
    public static final int FACILITY_ID = 3;

    /** スコープ。 */
    public static final int SCOPE = 4;

    /** アプリケーション。 */
    public static final int APPLICATION = 5;

    /** 更新日時。 */
    public static final int UPDATE_TIME = 6;

    /** 出力日時。 */
    public static final int OUTPUT_TIME = 7;

    /** メッセージID。 */
    public static final int MESSAGE_ID = 8;

    /** メッセージ。 */
    public static final int MESSAGE = 9;

    /** 初期表示時ソートカラム。 */
    public static final int SORT_COLUMN_INDEX = FACILITY_ID;

    /** 初期表示時ソートオーダー。 */
    public static final int SORT_ORDER = 1;

}