/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ジョブ操作用プロパティを取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、ジョブ操作用プロパティを取得する
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetJobOperationProperty {
	
	/**
	 * 開始用プロパティ取得
	 * 
	 * @param sessionId セッションID
	 * @param jobId ジョブID
	 * @param facilityId ファシリティID
	 * @return ジョブ開始操作用プロパティ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobController
	 * @see com.clustercontrol.jobmanagement.util.EjbConnectionManager
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerBean#getStartProperty(java.lang.String, java.lang.String, java.lang.String, java.util.Locale)
	 */
	public Property getStartProperty(String sessionId, String jobId, String facilityId) {
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		Property property = null;
		try {
			property = job.getStartProperty(sessionId, jobId, facilityId, Locale.getDefault());
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		}
		return property;
	}
	
	/**
	 * 停止用プロパティ取得
	 * 
	 * @param sessionId セッションID
	 * @param jobId ジョブID
	 * @param facilityId ファシリティID
	 * @return ジョブ停止操作用プロパティ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobController
	 * @see com.clustercontrol.jobmanagement.util.EjbConnectionManager
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerBean#getStopProperty(java.lang.String, java.lang.String, java.lang.String, java.util.Locale)
	 */
	public Property getStopProperty(String sessionId, String jobId, String facilityId) {
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		Property property = null;
		try {
			property = job.getStopProperty(sessionId, jobId, facilityId, Locale.getDefault());
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		}
		return property;
	}
}
