/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.hinemosagent.factory;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.hinemosagent.bean.MonitorAgentInfo;
import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoUtil;
import com.clustercontrol.hinemosagent.ejb.session.MonitorAgentRunManagementHome;
import com.clustercontrol.monitor.run.factory.AddMonitorTruthValueType;

/**
 * Hinemos Agent監視情報登録クラス<BR>
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class AddMonitorAgent extends AddMonitorTruthValueType{
	
	protected static Log m_log = LogFactory.getLog( AddMonitorAgent.class );
	
	/**
	 * エージェント監視情報を設定します。<BR>
	 */
	/* (non-Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#addCheckInfo()
	 */
	@Override
	public boolean addCheckInfo() throws CreateException, NamingException{
		// Agent監視情報を設定
		MonitorAgentInfo agent = (MonitorAgentInfo)m_monitorInfo.getCheckInfo();
		
		MonitorAgentInfoUtil.getLocalHome().create(
				m_monitorInfo.getMonitorTypeId(),
				m_monitorInfo.getMonitorId(),
				agent.getCheckJobAgent(),
				agent.getCheckLogAgent());
		
		return true;
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#getJndiName()
	 */
	@Override
	public String getJndiName() {
		return MonitorAgentRunManagementHome.JNDI_NAME;
	}
}
