/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.QueryExp;
import org.jboss.mx.util.ObjectNamePatternHelper;
import org.jboss.mx.util.QueryExpSupport;
import org.jboss.mx.util.Serialization;

public class ObjectName
implements Serializable,
QueryExp {
    private transient boolean hasPattern = false;
    private transient boolean hasDomainPattern = false;
    private transient boolean hasPropertyPattern = false;
    private transient Hashtable propertiesHash = null;
    private transient ArrayList propertiesList = null;
    private transient String domain = null;
    private transient String kProps = null;
    private transient String ckProps = null;
    private transient String cName = null;
    private transient String constructorProps;
    private transient int hash;
    private transient ObjectNamePatternHelper.PropertyPattern propertyPattern;
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;

    public static ObjectName getInstance(String name) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(name);
    }

    public static ObjectName getInstance(String domain, String key, String value) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(domain, key, value);
    }

    public static ObjectName getInstance(String domain, Hashtable table) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(domain, table);
    }

    public static ObjectName getInstance(ObjectName name) throws NullPointerException {
        return name;
    }

    public static String quote(String value) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException("null value");
        }
        StringBuffer buffer = new StringBuffer(value.length() + 10);
        buffer.append('\"');
        char[] chars = value.toCharArray();
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\"': 
                case '*': 
                case '?': 
                case '\\': {
                    buffer.append('\\').append(chars[i]);
                    continue block4;
                }
                case '\n': {
                    buffer.append('\\').append('n');
                    continue block4;
                }
                default: {
                    buffer.append(chars[i]);
                }
            }
        }
        buffer.append('\"');
        return buffer.toString();
    }

    public static String unquote(String value) throws IllegalArgumentException, NullPointerException {
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (value.length() == 0) {
            throw new IllegalArgumentException("Empty value");
        }
        StringBuffer buffer = new StringBuffer(value.length());
        char[] chars = value.toCharArray();
        boolean inQuote = false;
        boolean escape = false;
        block9: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (escape) {
                switch (c) {
                    case '\"': 
                    case '*': 
                    case '?': 
                    case '\\': {
                        escape = false;
                        buffer.append(c);
                        continue block9;
                    }
                    case 'n': {
                        escape = false;
                        buffer.append('\n');
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("The value " + value + " contains an invalid escape sequence backslash " + c);
                    }
                }
            }
            if (!inQuote && c == '\"') {
                inQuote = true;
                continue;
            }
            if (inQuote && c == '\"') {
                inQuote = false;
                continue;
            }
            if (inQuote && c == '\\') {
                escape = true;
                continue;
            }
            if (inQuote) {
                switch (c) {
                    case '\"': {
                        throw new IllegalArgumentException("The value " + value + " cannot contain quote inside a quote pair, use backslash quote");
                    }
                    case '*': 
                    case '?': {
                        throw new IllegalArgumentException("The value " + value + " cannot contain " + c + " inside a quote pair, use backslash " + c);
                    }
                    case '\n': {
                        throw new IllegalArgumentException("The value " + value + " cannot contain a new line inside a quote pair, use backslash n");
                    }
                }
                buffer.append(c);
                continue;
            }
            throw new IllegalArgumentException("The value " + value + " is not enclosed in quotes");
        }
        if (inQuote) {
            throw new IllegalArgumentException("Unterminated quote pair, missing quote");
        }
        if (escape) {
            throw new IllegalArgumentException("Unterminated escape, missing one of backslash quote asterisk question mark or n");
        }
        return buffer.toString();
    }

    public ObjectName(String name) throws MalformedObjectNameException, NullPointerException {
        this.init(name);
    }

    public ObjectName(String domain, String key, String value) throws MalformedObjectNameException, NullPointerException {
        if (null == key) {
            throw new NullPointerException("properties key cannot be null");
        }
        if (null == value) {
            throw new NullPointerException("properties value cannot be null");
        }
        if (key.length() == 0) {
            throw new MalformedObjectNameException("properties key cannot be empty");
        }
        if (value.length() == 0) {
            throw new MalformedObjectNameException("properties value cannot be empty");
        }
        this.initDomain(domain, null);
        Hashtable<String, String> ptable = new Hashtable<String, String>();
        ptable.put(key, value);
        this.initProperties(ptable, null);
    }

    public ObjectName(String domain, Hashtable table) throws MalformedObjectNameException, NullPointerException {
        if (table == null) {
            throw new NullPointerException("null table");
        }
        this.initDomain(domain, null);
        if (table.size() < 1) {
            throw new MalformedObjectNameException("empty table");
        }
        this.initProperties((Hashtable)table.clone(), null);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ObjectName) {
            ObjectName oname = (ObjectName)object;
            return oname.hash == this.hash && this.domain.equals(oname.domain) && this.ckProps.equals(oname.ckProps);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.getCanonicalName();
    }

    public boolean isPattern() {
        return this.hasPattern;
    }

    public String getCanonicalName() {
        if (this.cName == null) {
            this.cName = this.domain + ":" + this.ckProps;
            if (this.ckProps.length() == 0 && this.hasPropertyPattern) {
                this.cName = this.cName + "*";
            }
            if (this.ckProps.length() > 0 && this.hasPropertyPattern) {
                this.cName = this.cName + ",*";
            }
        }
        return this.cName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getKeyProperty(String property) throws NullPointerException {
        return (String)this.propertiesHash.get(property);
    }

    public Hashtable getKeyPropertyList() {
        return (Hashtable)this.propertiesHash.clone();
    }

    public String getKeyPropertyListString() {
        if (this.constructorProps != null) {
            return this.constructorProps;
        }
        if (this.kProps == null) {
            StringBuffer buffer = new StringBuffer();
            Iterator<Object> it = this.propertiesHash.keySet().iterator();
            if (this.propertiesList != null) {
                it = this.propertiesList.iterator();
            }
            int i = 0;
            while (it.hasNext()) {
                if (i > 0) {
                    buffer.append(",");
                }
                String key = (String)it.next();
                String val = (String)this.propertiesHash.get(key);
                buffer.append(key + "=" + val);
                ++i;
            }
            this.kProps = buffer.toString();
        }
        return this.kProps;
    }

    public String getCanonicalKeyPropertyListString() {
        if (this.ckProps == null) {
            StringBuffer buffer = new StringBuffer();
            ArrayList list = new ArrayList(this.propertiesHash.keySet());
            Collections.sort(list);
            Iterator it = list.iterator();
            int i = 0;
            while (it.hasNext()) {
                if (i > 0) {
                    buffer.append(",");
                }
                String key = (String)it.next();
                String val = (String)this.propertiesHash.get(key);
                buffer.append(key + "=" + val);
                ++i;
            }
            this.ckProps = buffer.toString();
        }
        return this.ckProps;
    }

    public boolean isPropertyPattern() {
        return this.hasPropertyPattern;
    }

    public boolean isDomainPattern() {
        return this.hasDomainPattern;
    }

    public boolean apply(ObjectName name) throws NullPointerException {
        if (name.isPattern()) {
            return false;
        }
        if (this == name) {
            return true;
        }
        if (ObjectNamePatternHelper.patternMatch(name.getDomain(), this.getDomain())) {
            if (this.propertyPattern == null) {
                this.propertyPattern = new ObjectNamePatternHelper.PropertyPattern(this);
            }
            return this.propertyPattern.patternMatch(name);
        }
        return false;
    }

    public void setMBeanServer(MBeanServer server) {
        QueryExpSupport.server.set(server);
    }

    private void init(String name) throws MalformedObjectNameException {
        int domainSep;
        if (name == null) {
            throw new NullPointerException("null name");
        }
        if (name.length() == 0) {
            name = "*:*";
        }
        if (-1 == (domainSep = name.indexOf(58))) {
            throw new MalformedObjectNameException("missing domain");
        }
        this.initDomain(name.substring(0, domainSep), name);
        this.constructorProps = name.substring(domainSep + 1);
        this.initProperties(this.constructorProps, name);
        if (this.constructorProps.equals("*")) {
            this.constructorProps = "";
        } else if (this.constructorProps.startsWith("*,")) {
            this.constructorProps = this.constructorProps.substring(2);
        } else if (this.constructorProps.endsWith(",*")) {
            this.constructorProps = this.constructorProps.substring(0, this.constructorProps.length() - 2);
        }
    }

    private void initDomain(String dstring, String name) throws MalformedObjectNameException {
        if (null == dstring) {
            throw new NullPointerException("null domain");
        }
        this.checkIllegalDomain(dstring, name);
        if (dstring.indexOf(42) > -1 || dstring.indexOf(63) > -1) {
            this.hasPattern = true;
            this.hasDomainPattern = true;
        }
        this.domain = dstring;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initProperties(String properties, String name) throws MalformedObjectNameException {
        if (null == properties || properties.length() < 1) {
            throw new MalformedObjectNameException(this.addDebugObjectName(name) + "null or empty properties");
        }
        Hashtable<String, String> ptable = new Hashtable<String, String>();
        this.propertiesList = new ArrayList();
        char[] chars = properties.toCharArray();
        String key = null;
        int start = 0;
        boolean inKey = true;
        boolean inQuote = false;
        boolean escape = false;
        boolean endOrTerminate = false;
        for (int current = 0; current < chars.length; ++current) {
            char c = chars[current];
            if (escape) {
                escape = false;
                continue;
            }
            if (inQuote) {
                if (c == '\"') {
                    inQuote = false;
                    endOrTerminate = true;
                    continue;
                }
                if (c != '\\') continue;
                escape = true;
                continue;
            }
            if (inKey) {
                if (c != '=' && c != ',') continue;
                if (current == start) {
                    throw new MalformedObjectNameException(this.addDebugObjectName(name) + "Empty key");
                }
                key = properties.substring(start, current);
                if (c == ',') {
                    if (!key.equals("*")) throw new MalformedObjectNameException(this.addDebugObjectName(name) + "Invalid key/value data " + key);
                    if (this.hasPropertyPattern) {
                        throw new MalformedObjectNameException(this.addDebugObjectName(name) + "A property pattern may only contain one * property");
                    }
                    this.hasPropertyPattern = true;
                    this.hasPattern = true;
                } else {
                    if (ptable.containsKey(key)) {
                        throw new MalformedObjectNameException(this.addDebugObjectName(name) + "Duplicate key " + key);
                    }
                    inKey = false;
                }
                start = current + 1;
                continue;
            }
            if (c == '\"') {
                inQuote = true;
                continue;
            }
            if (c == ',') {
                if (current == start) {
                    throw new MalformedObjectNameException(this.addDebugObjectName(name) + "Invalid key/value data " + key);
                }
                this.propertiesList.add(key);
                ptable.put(key, properties.substring(start, current));
                inKey = true;
                endOrTerminate = false;
                start = current + 1;
                continue;
            }
            if (!endOrTerminate) continue;
            throw new MalformedObjectNameException(this.addDebugObjectName(name) + "Invalid key/value data " + key);
        }
        if (inKey) {
            if (start == chars.length) {
                throw new MalformedObjectNameException(this.addDebugObjectName(name) + "An ObjectName cannot end with a comma");
            }
            key = properties.substring(start, chars.length);
            if (!key.equals("*")) throw new MalformedObjectNameException(this.addDebugObjectName(name) + "Invalid key/value data " + key);
            if (this.hasPropertyPattern) {
                throw new MalformedObjectNameException(this.addDebugObjectName(name) + "A property pattern may only contain one * property");
            }
            this.hasPropertyPattern = true;
            this.hasPattern = true;
        }
        if (!inKey) {
            if (start == chars.length) {
                throw new MalformedObjectNameException(this.addDebugObjectName(name) + "Invalid key/value data " + key);
            }
            this.propertiesList.add(key);
            ptable.put(key, properties.substring(start, chars.length));
        }
        this.initProperties(ptable, name);
    }

    private void initProperties(Hashtable properties, String name) throws MalformedObjectNameException {
        if (null == properties || !this.hasPropertyPattern && properties.size() < 1) {
            throw new MalformedObjectNameException(this.addDebugObjectName(name) + "null or empty properties");
        }
        Iterator<Object> it = properties.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            String key = null;
            try {
                key = (String)it.next();
            }
            catch (ClassCastException e) {
                throw new MalformedObjectNameException(this.addDebugObjectName(name) + "key is not a string " + key);
            }
            String val = null;
            try {
                val = (String)properties.get(key);
            }
            catch (ClassCastException e) {
                throw new MalformedObjectNameException(this.addDebugObjectName(name) + "value is not a string " + val);
            }
            if (key.equals("*") && val.equals("*")) {
                it.remove();
                this.hasPropertyPattern = true;
                this.hasPattern = true;
                continue;
            }
            if (key.length() == 0) {
                throw new MalformedObjectNameException(this.addDebugObjectName(name) + "key has no length =" + val);
            }
            if (val.length() == 0) {
                throw new MalformedObjectNameException(this.addDebugObjectName(name) + "value has no length =" + val);
            }
            this.checkIllegalKey(key, name);
            this.checkIllegalValue(val, name);
            list.add(new String(key + "=" + val));
        }
        Collections.sort(list);
        StringBuffer strBuffer = new StringBuffer();
        it = list.iterator();
        while (it.hasNext()) {
            strBuffer.append(it.next());
            if (!it.hasNext()) continue;
            strBuffer.append(',');
        }
        if (this.hasPropertyPattern) {
            if (properties.size() > 0) {
                strBuffer.append(",*");
            } else {
                strBuffer.append("*");
            }
        }
        this.propertiesHash = properties;
        this.kProps = this.getKeyPropertyListString();
        this.ckProps = this.getCanonicalKeyPropertyListString();
        this.hash = this.getCanonicalName().hashCode();
    }

    private void checkIllegalKey(String key, String name) throws MalformedObjectNameException {
        char[] chars = key.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '*': 
                case ',': 
                case ':': 
                case '=': 
                case '?': {
                    throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The key " + key + " cannot contain a " + chars[i] + " character");
                }
                case '\n': {
                    throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The key " + key + " cannot contain a new line character");
                }
            }
        }
    }

    private void checkIllegalValue(String value, String name) throws MalformedObjectNameException {
        char[] chars = value.toCharArray();
        boolean inQuote = false;
        boolean escape = false;
        block12: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (escape) {
                switch (c) {
                    case '\"': 
                    case '*': 
                    case '?': 
                    case '\\': 
                    case 'n': {
                        escape = false;
                        continue block12;
                    }
                    default: {
                        throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The value " + value + " contains an invalid escape sequence backslash " + c);
                    }
                }
            }
            if (!inQuote && c == '\"') {
                inQuote = true;
                continue;
            }
            if (inQuote && c == '\"') {
                inQuote = false;
                continue;
            }
            if (inQuote && c == '\\') {
                escape = true;
                continue;
            }
            if (inQuote) {
                switch (c) {
                    case '\"': {
                        throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The value " + value + " cannot contain quote inside a quote pair, use backslash quote");
                    }
                    case '*': 
                    case '?': {
                        throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The value " + value + " cannot contain " + c + " inside a quote pair, use backslash " + c);
                    }
                    case '\n': {
                        throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The value " + value + " cannot contain a new line inside a quote pair, use backslash n");
                    }
                }
                continue;
            }
            switch (c) {
                case '*': 
                case ',': 
                case ':': 
                case '=': 
                case '?': {
                    throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The value " + value + " cannot contain " + c + " use quote backslash " + c + " quote or ObjectName.quote(String)");
                }
                case '\n': {
                    throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The value " + value + " cannot contain a new line use quote backslash n quote or ObjectName.quote(String)");
                }
            }
        }
        if (inQuote) {
            throw new MalformedObjectNameException(this.addDebugObjectName(name) + "Unterminated quote pair, missing quote");
        }
        if (escape) {
            throw new MalformedObjectNameException(this.addDebugObjectName(name) + "Unterminated escape, missing one of backslash quote asterisk question mark or n");
        }
    }

    private void checkIllegalDomain(String dom, String name) throws MalformedObjectNameException {
        char[] chars = dom.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case ':': {
                    throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The domain " + dom + " cannot contain a : character");
                }
                case '\n': {
                    throw new MalformedObjectNameException(this.addDebugObjectName(name) + "The domain " + dom + " cannot contain a new line character");
                }
            }
        }
    }

    private String addDebugObjectName(String name) {
        if (name == null) {
            return "";
        }
        return name + " is not a valid ObjectName. ";
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        switch (Serialization.version) {
            case 10: {
                ObjectInputStream.GetField getField = ois.readFields();
                try {
                    String name = (String)getField.get("canonicalName", null);
                    if (name == null) {
                        throw new StreamCorruptedException("No canonical name for jmx1.0?");
                    }
                    this.init(name);
                    break;
                }
                catch (MalformedObjectNameException e) {
                    throw new StreamCorruptedException(e.toString());
                }
            }
            default: {
                try {
                    this.init((String)ois.readObject());
                    break;
                }
                catch (MalformedObjectNameException e) {
                    throw new StreamCorruptedException(e.toString());
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        switch (Serialization.version) {
            case 10: {
                ObjectOutputStream.PutField putField = oos.putFields();
                putField.put("domain", this.domain);
                putField.put("propertyList", this.propertiesHash);
                putField.put("propertyListString", this.ckProps);
                putField.put("canonicalName", this.domain + ":" + this.ckProps);
                putField.put("pattern", this.hasPattern);
                putField.put("propertyPattern", this.hasPropertyPattern);
                oos.writeFields();
                break;
            }
            default: {
                String props = this.getKeyPropertyListString();
                StringBuffer buffer = new StringBuffer(this.domain.length() + props.length() + 3);
                buffer.append(this.domain);
                buffer.append(':');
                buffer.append(props);
                if (this.hasPropertyPattern) {
                    if (this.propertiesHash.size() > 0) {
                        buffer.append(',');
                    }
                    buffer.append('*');
                }
                oos.writeObject(buffer.toString());
            }
        }
    }

    static {
        switch (Serialization.version) {
            case 10: {
                serialVersionUID = -5467795090068647408L;
                serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("domain", String.class), new ObjectStreamField("propertyList", Hashtable.class), new ObjectStreamField("propertyListString", String.class), new ObjectStreamField("canonicalName", String.class), new ObjectStreamField("pattern", Boolean.TYPE), new ObjectStreamField("propertyPattern", Boolean.TYPE)};
                break;
            }
            default: {
                serialVersionUID = 1081892073854801359L;
                serialPersistentFields = new ObjectStreamField[0];
            }
        }
    }
}

