/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.xml;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMFlavor;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMMethod;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMParameter;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMQualifierType;
import org.sblim.wbem.cim.CIMScope;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;
import org.sblim.wbem.cim.UnsignedInt32;
import org.sblim.wbem.cim.UnsignedInt64;
import org.sblim.wbem.cim.UnsignedInt8;
import org.sblim.wbem.client.indications.CIMError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class CIMXMLBuilderImpl {
    private static final int MAJOR_CIM_VERSION = 2;
    private static final int MINOR_CIM_VERSION = 0;
    private static final int MAJOR_DTD_VERSION = 2;
    private static final int MINOR_DTD_VERSION = 0;

    public static Element createCIM(Document doc) {
        Element e = doc.createElement("CIM");
        e.setAttribute("CIMVERSION", "2.0");
        e.setAttribute("DTDVERSION", "2.0");
        doc.appendChild(e);
        return e;
    }

    public static Element createVALUE(Document doc, Element parentE) {
        Element e = doc.createElement("VALUE");
        parentE.appendChild(e);
        return e;
    }

    public static Element createVALUE(Document doc, Element parentE, String value) {
        Element e = doc.createElement("VALUE");
        parentE.appendChild(e);
        Text textE = doc.createTextNode(value);
        e.appendChild(textE);
        return e;
    }

    public static Element createVALUEARRAY(Document doc, Element parentE) {
        Element e = doc.createElement("VALUE.ARRAY");
        parentE.appendChild(e);
        return e;
    }

    public static Element createVALUEREFERENCE(Document doc, Element parentE) {
        Element e = doc.createElement("VALUE.REFERENCE");
        parentE.appendChild(e);
        return e;
    }

    public static Element createVALUEREFARRAY(Document doc, Element parentE) {
        Element e = doc.createElement("VALUE.REFARRAY");
        parentE.appendChild(e);
        return e;
    }

    public static Element createPROPERTY(Document doc, Element parentE, String name, String type) {
        Element e = doc.createElement("PROPERTY");
        if (name != null) {
            e.setAttribute("NAME", name);
        }
        if (type != null) {
            e.setAttribute("TYPE", type);
        }
        parentE.appendChild(e);
        return e;
    }

    public static Element createPROPERTYARRAY(Document doc, Element parentE, String name, String type) {
        Element e = doc.createElement("PROPERTY.ARRAY");
        if (name != null) {
            e.setAttribute("NAME", name);
        }
        if (type != null) {
            e.setAttribute("TYPE", type);
        }
        parentE.appendChild(e);
        return e;
    }

    public static Element createPROPERTYREFERENCE(Document doc, Element parentE, String name, String referenceclass) {
        Element e = doc.createElement("PROPERTY.REFERENCE");
        if (name != null) {
            e.setAttribute("NAME", name);
        }
        if (referenceclass != null) {
            e.setAttribute("REFERENCECLASS", referenceclass);
        }
        parentE.appendChild(e);
        return e;
    }

    public static Element createLOCALNAMESPACEPATH(Document doc, Element parentE) {
        Element e = doc.createElement("LOCALNAMESPACEPATH");
        parentE.appendChild(e);
        return e;
    }

    public static Element createNAMESPACE(Document doc, Element parentE, String name) {
        Element e = doc.createElement("NAMESPACE");
        if (name != null) {
            e.setAttribute("NAME", name);
        }
        parentE.appendChild(e);
        return e;
    }

    public static Element createLOCALINSTANCEPATH(Document doc, Element parentE) {
        Element e = doc.createElement("LOCALINSTANCEPATH");
        parentE.appendChild(e);
        return e;
    }

    public static Element createCLASSNAME(Document doc, Element parentE, String name) {
        Element e = doc.createElement("CLASSNAME");
        if (name != null) {
            e.setAttribute("NAME", name);
            parentE.appendChild(e);
        }
        return e;
    }

    public static Element createCLASS(Document doc, Element parentE, String name, String superClass) {
        Element e = doc.createElement("CLASS");
        if (name != null) {
            e.setAttribute("NAME", name);
        }
        if (superClass != null && superClass.length() > 0) {
            e.setAttribute("SUPERCLASS", superClass);
        }
        if (parentE != null) {
            parentE.appendChild(e);
        }
        return e;
    }

    public static Element createINSTANCENAME(Document doc, Element parentE, String classname) {
        Element e = doc.createElement("INSTANCENAME");
        if (classname != null) {
            e.setAttribute("CLASSNAME", classname);
        }
        parentE.appendChild(e);
        return e;
    }

    public static Element createKEYBINDING(Document doc, Element parentE, String name) {
        Element e = doc.createElement("KEYBINDING");
        if (name != null) {
            e.setAttribute("NAME", name);
        }
        parentE.appendChild(e);
        return e;
    }

    public static Element createKEYVALUE(Document doc, Element parentE, String valuetype, String value) {
        Element e = doc.createElement("KEYVALUE");
        if (valuetype != null) {
            e.setAttribute("VALUETYPE", CIMXMLBuilderImpl.getOpTypeStr(CIMDataType.getDataType(valuetype, false)));
        } else {
            e.setAttribute("VALUETYPE", "string");
        }
        parentE.appendChild(e);
        Text valueE = doc.createTextNode(value);
        e.appendChild(valueE);
        return e;
    }

    public static Element createINSTANCE(Document doc, Element parentE, String classname) {
        Element e = doc.createElement("INSTANCE");
        if (classname != null) {
            e.setAttribute("CLASSNAME", classname);
        }
        if (parentE != null) {
            parentE.appendChild(e);
        }
        return e;
    }

    public static Element createQUALIFIER(Document doc, Element parentE, String name, String type) {
        Element e = doc.createElement("QUALIFIER");
        if (name != null) {
            e.setAttribute("NAME", name);
        }
        if (type != null) {
            e.setAttribute("TYPE", type);
        }
        parentE.appendChild(e);
        return e;
    }

    public static Element createMESSAGE(Document doc, Element parentE, String id, String protocolversion) {
        Element e = doc.createElement("MESSAGE");
        e.setAttribute("ID", id);
        e.setAttribute("PROTOCOLVERSION", protocolversion);
        parentE.appendChild(e);
        return e;
    }

    public static Element createSIMPLEREQ(Document doc, Element parentE) {
        Element e = doc.createElement("SIMPLEREQ");
        parentE.appendChild(e);
        return e;
    }

    public static Element createSIMPLEREQ(Document doc) {
        Element e = doc.createElement("SIMPLEREQ");
        return e;
    }

    public static Element createMULTIREQ(Document doc) {
        Element e = doc.createElement("MULTIREQ");
        return e;
    }

    public static Element createMETHODCALL(Document doc, Element parentE, String name, String paramtype) {
        Element e = doc.createElement("METHODCALL");
        if (name != null) {
            e.setAttribute("NAME", name);
        }
        if (paramtype != null) {
            e.setAttribute("PARAMTYPE", paramtype);
        }
        parentE.appendChild(e);
        return e;
    }

    public static Element createPARAMVALUE(Document doc, Element parentE, String name, String paramtype) {
        Element e = doc.createElement("PARAMVALUE");
        if (name != null) {
            e.setAttribute("NAME", name);
        }
        if (paramtype != null) {
            e.setAttribute("PARAMTYPE", paramtype);
        }
        parentE.appendChild(e);
        return e;
    }

    public static Element createSIMPLERSP(Document doc, Element parentE) {
        Element e = doc.createElement("SIMPLERSP");
        parentE.appendChild(e);
        return e;
    }

    public static Element createSIMPLEEXPRSP(Document doc, Element parentE) {
        Element e = doc.createElement("SIMPLEEXPRSP");
        parentE.appendChild(e);
        return e;
    }

    public static Element createMETHODRESPONSE(Document doc, Element parentE, String name) {
        Element e = doc.createElement("METHODRESPONSE");
        if (name != null) {
            e.setAttribute("NAME", name);
        }
        parentE.appendChild(e);
        return e;
    }

    public static Element createIMETHODRESPONSE(Document doc, Element parentE, String name) {
        Element e = doc.createElement("IMETHODRESPONSE");
        if (name != null) {
            e.setAttribute("NAME", name);
        }
        parentE.appendChild(e);
        return e;
    }

    public static Element createEXPMETHODRESPONSE(Document doc, Element parentE, String name) {
        Element e = doc.createElement("EXPMETHODRESPONSE");
        if (name != null) {
            e.setAttribute("NAME", name);
        }
        parentE.appendChild(e);
        return e;
    }

    public static Element createIRETURNVALUE(Document doc, Element parentE) {
        Element e = doc.createElement("IRETURNVALUE");
        parentE.appendChild(e);
        return e;
    }

    public static Element createIMETHODCALL(Document doc, Element parentE, String name) {
        Element e = doc.createElement("IMETHODCALL");
        if (name != null) {
            e.setAttribute("NAME", name);
        }
        parentE.appendChild(e);
        return e;
    }

    public static Element createIPARAMVALUE(Document doc, Element parentE, String name) {
        Element e = doc.createElement("IPARAMVALUE");
        if (name != null) {
            e.setAttribute("NAME", name);
        }
        parentE.appendChild(e);
        return e;
    }

    public static Element createERROR(Document doc, Element parentE, CIMError error) {
        String description;
        Element e = doc.createElement("ERROR");
        int code = error.getCode();
        if (code > 0) {
            e.setAttribute("CODE", Integer.toString(code));
        }
        if ((description = error.getDescription()) != null) {
            e.setAttribute("DESCRIPTION", description);
        }
        parentE.appendChild(e);
        return e;
    }

    public static Element createQUALIFIER_DECLARATION(Document doc, Element parentE, CIMQualifierType qualifiertype) {
        String pValueTypeStr = CIMXMLBuilderImpl.getTypeStr(qualifiertype.getType());
        Element qualifierdeclarationE = doc.createElement("QUALIFIER.DECLARATION");
        qualifierdeclarationE.setAttribute("NAME", qualifiertype.getName());
        qualifierdeclarationE.setAttribute("TYPE", pValueTypeStr);
        qualifierdeclarationE.setAttribute("ISARRAY", qualifiertype.isArrayValue() ? "true" : "false");
        Vector flavors = qualifiertype.getFlavor();
        for (int n = 0; n < flavors.size(); ++n) {
            CIMFlavor flavor = (CIMFlavor)flavors.elementAt(n);
            if (flavor.equals(CIMFlavor.getFlavor(4))) {
                qualifierdeclarationE.setAttribute("TRANSLATABLE", "true");
                continue;
            }
            if (flavor.equals(CIMFlavor.getFlavor(1))) {
                qualifierdeclarationE.setAttribute("OVERRIDABLE", "false");
                continue;
            }
            if (!flavor.equals(CIMFlavor.getFlavor(2))) continue;
            qualifierdeclarationE.setAttribute("TOSUBCLASS", "true");
        }
        Vector scopes = qualifiertype.getScope();
        if (scopes.size() > 0) {
            Element scopeE = doc.createElement("SCOPE");
            if (qualifiertype.hasScope(CIMScope.getScope(1))) {
                scopeE.setAttribute("CLASS", "true");
            }
            if (qualifiertype.hasScope(CIMScope.getScope(2))) {
                scopeE.setAttribute("ASSOCIATION", "true");
            }
            if (qualifiertype.hasScope(CIMScope.getScope(5))) {
                scopeE.setAttribute("REFERENCE", "true");
            }
            if (qualifiertype.hasScope(CIMScope.getScope(4))) {
                scopeE.setAttribute("PROPERTY", "true");
            }
            if (qualifiertype.hasScope(CIMScope.getScope(6))) {
                scopeE.setAttribute("METHOD", "true");
            }
            if (qualifiertype.hasScope(CIMScope.getScope(7))) {
                scopeE.setAttribute("PARAMETER", "true");
            }
            if (qualifiertype.hasScope(CIMScope.getScope(3))) {
                scopeE.setAttribute("INDICATION", "true");
            }
            qualifierdeclarationE.appendChild(scopeE);
        }
        if (qualifiertype.hasDefaultValue() && qualifiertype.getDefaultValue().getValue() != null) {
            CIMXMLBuilderImpl.createVALUE(doc, qualifierdeclarationE, qualifiertype.getDefaultValue());
        }
        parentE.appendChild(qualifierdeclarationE);
        return qualifierdeclarationE;
    }

    public static Element createQUALIFIER(Document doc, Element parentE, CIMQualifier qualifier) {
        CIMValue value = qualifier.getValue();
        if (value == null) {
            return null;
        }
        Element qualifierE = CIMXMLBuilderImpl.createQUALIFIER(doc, parentE, qualifier.getName(), CIMXMLBuilderImpl.getTypeStr(value.getType()));
        if (qualifier.isPropagated()) {
            qualifierE.setAttribute("PROPAGATED", "true");
        }
        Vector flavors = qualifier.getFlavor();
        for (int n = 0; n < flavors.size(); ++n) {
            CIMFlavor flavor = (CIMFlavor)flavors.elementAt(n);
            if (flavor.equals(CIMFlavor.getFlavor(4))) {
                qualifierE.setAttribute("TRANSLATABLE", "true");
                continue;
            }
            if (flavor.equals(CIMFlavor.getFlavor(1))) {
                qualifierE.setAttribute("OVERRIDABLE", "false");
                continue;
            }
            if (!flavor.equals(CIMFlavor.getFlavor(2))) continue;
            qualifierE.setAttribute("TOSUBCLASS", "false");
        }
        CIMXMLBuilderImpl.createVALUE(doc, qualifierE, value);
        parentE.appendChild(qualifierE);
        return qualifierE;
    }

    public static void createQUALIFIERS(Document doc, Element parentE, Vector qualifiersV) {
        for (int i = 0; i < qualifiersV.size(); ++i) {
            CIMQualifier qualifier = (CIMQualifier)qualifiersV.elementAt(i);
            CIMXMLBuilderImpl.createQUALIFIER(doc, parentE, qualifier);
        }
    }

    public static void createPROPERTIES(Document doc, Element parentE, Vector properties) {
        Iterator iter = properties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            CIMXMLBuilderImpl.createPROPERTY(doc, parentE, property);
        }
    }

    public static Element createPROPERTY(Document doc, Element parentE, CIMProperty property) {
        CIMDataType propertyDataType = property.getType();
        String pValueTypeStr = CIMXMLBuilderImpl.getTypeStr(propertyDataType);
        CIMValue pValue = property.getValue();
        Element propertyE = propertyDataType.isArrayType() ? CIMXMLBuilderImpl.createPROPERTYARRAY(doc, parentE, property.getName(), pValueTypeStr) : (propertyDataType.isReferenceType() ? CIMXMLBuilderImpl.createPROPERTYREFERENCE(doc, parentE, property.getName(), propertyDataType.getRefClassName()) : CIMXMLBuilderImpl.createPROPERTY(doc, parentE, property.getName(), pValueTypeStr));
        String classorigin = property.getOriginClass();
        if (classorigin != null && classorigin.length() > 0) {
            propertyE.setAttribute("CLASSORIGIN", classorigin);
        }
        if (property.isPropagated()) {
            propertyE.setAttribute("PROPAGATED", "true");
        }
        CIMXMLBuilderImpl.createQUALIFIERS(doc, propertyE, property.getQualifiers());
        if (pValue != null) {
            CIMXMLBuilderImpl.createVALUE(doc, propertyE, pValue);
        }
        return propertyE;
    }

    public static Element createVALUEARRAY(Document doc, Element parentE, Vector vect) {
        Element valuearrayE = CIMXMLBuilderImpl.createVALUEARRAY(doc, parentE);
        Iterator iter = vect.iterator();
        while (iter.hasNext()) {
            CIMValue value = new CIMValue(iter.next());
            CIMXMLBuilderImpl.createVALUE(doc, valuearrayE, value);
        }
        parentE.appendChild(valuearrayE);
        return valuearrayE;
    }

    public static Element createVALUE(Document doc, Element parentE, CIMValue argValue) {
        if (argValue == null || argValue.getValue() == null) {
            return null;
        }
        Element valueE = null;
        if (argValue.isArrayValue()) {
            valueE = CIMXMLBuilderImpl.createVALUEARRAY(doc, parentE, (Vector)argValue.getValue());
        } else {
            Object obj = argValue.getValue();
            CIMDataType type = argValue.getType();
            if (type != null && type.getType() == 14) {
                valueE = CIMXMLBuilderImpl.createVALUEREFERENCE(doc, parentE);
                CIMObjectPath op = (CIMObjectPath)obj;
                Vector keys = op.getKeys();
                if (op.getHost() == null || "".equals(op.getHost())) {
                    if (op.getNameSpace() == null || "".equals(op.getNameSpace())) {
                        if (keys.size() > 0) {
                            CIMXMLBuilderImpl.createINSTANCENAME(doc, valueE, op);
                        } else {
                            CIMXMLBuilderImpl.createCLASSNAME(doc, valueE, op.getObjectName());
                        }
                    } else if (keys.size() > 0) {
                        CIMXMLBuilderImpl.createLOCALINSTANCEPATH(doc, valueE, op);
                    } else {
                        CIMXMLBuilderImpl.createLOCALCLASSPATH(doc, valueE, op);
                    }
                } else if (keys.size() > 0) {
                    CIMXMLBuilderImpl.createINSTANCEPATH(doc, valueE, op);
                } else {
                    CIMXMLBuilderImpl.createCLASSPATH(doc, valueE, op);
                }
            } else if (obj instanceof CIMInstance) {
                valueE = CIMXMLBuilderImpl.createVALUE(doc, parentE);
                CIMXMLBuilderImpl.createINSTANCE(doc, valueE, (CIMInstance)obj);
            } else if (obj instanceof CIMClass) {
                valueE = CIMXMLBuilderImpl.createVALUE(doc, parentE);
                CIMXMLBuilderImpl.createCLASS(doc, valueE, (CIMClass)obj);
            } else {
                CIMXMLBuilderImpl.createVALUE(doc, parentE, argValue.getValue().toString());
            }
        }
        return valueE;
    }

    public static Element createIPARAMVALUE(Document doc, Element parentE, CIMValue argValue) {
        if (argValue == null || argValue.getValue() == null) {
            return null;
        }
        Element iparamvalueE = CIMXMLBuilderImpl.createIPARAMVALUE(doc, parentE, "NewValue");
        CIMXMLBuilderImpl.createVALUE(doc, iparamvalueE, argValue);
        parentE.appendChild(iparamvalueE);
        return iparamvalueE;
    }

    public static Element createINSTANCE(Document doc, Element parentE, CIMInstance instance) {
        String className = instance.getObjectPath().getObjectName();
        if (className == null) {
            throw new CIMException("CIM_ERR_FAILED", "null class name");
        }
        Element instanceE = CIMXMLBuilderImpl.createINSTANCE(doc, parentE, className);
        CIMXMLBuilderImpl.createQUALIFIERS(doc, instanceE, instance.getQualifiers());
        CIMXMLBuilderImpl.createPROPERTIES(doc, instanceE, instance.getAllProperties());
        if (parentE != null) {
            parentE.appendChild(instanceE);
        }
        return instanceE;
    }

    public static Element createOBJECTPATH(Document doc, Element parentE, CIMObjectPath path) {
        Element objectpathE = doc.createElement("OBJECTPATH");
        Vector keys = path.getKeys();
        if (keys.size() > 0) {
            CIMXMLBuilderImpl.createINSTANCEPATH(doc, objectpathE, path);
        } else {
            CIMXMLBuilderImpl.createCLASSPATH(doc, objectpathE, path);
        }
        parentE.appendChild(objectpathE);
        return objectpathE;
    }

    public static Element createOBJECTNAME(Document doc, Element parentE, CIMObjectPath path) {
        Vector keys = path.getKeys();
        if (keys.size() > 0) {
            return CIMXMLBuilderImpl.createINSTANCENAME(doc, parentE, path);
        }
        if (path.getObjectName() == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "null class name");
        }
        return CIMXMLBuilderImpl.createCLASSNAME(doc, parentE, path.getObjectName());
    }

    public static Element createLOCALINSTANCEPATH(Document doc, Element parentE, CIMObjectPath path) {
        Element localinstancepathE = doc.createElement("LOCALINSTANCEPATH");
        CIMXMLBuilderImpl.createLOCALNAMESPACEPATH(doc, localinstancepathE, path);
        CIMXMLBuilderImpl.createINSTANCENAME(doc, localinstancepathE, path);
        parentE.appendChild(localinstancepathE);
        return localinstancepathE;
    }

    public static Element createLOCALCLASSPATH(Document doc, Element parentE, CIMObjectPath path) {
        Element localinstancepathE = doc.createElement("LOCALCLASSPATH");
        CIMXMLBuilderImpl.createLOCALNAMESPACEPATH(doc, localinstancepathE, path);
        if (path.getObjectName() == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "null class name");
        }
        CIMXMLBuilderImpl.createCLASSNAME(doc, localinstancepathE, path.getObjectName());
        parentE.appendChild(localinstancepathE);
        return localinstancepathE;
    }

    public static Element createLOCALOBJECTPATH(Document doc, Element parentE, CIMObjectPath path) {
        Vector keys = path.getKeys();
        if (keys.size() > 0) {
            return CIMXMLBuilderImpl.createLOCALINSTANCEPATH(doc, parentE, path);
        }
        return CIMXMLBuilderImpl.createLOCALCLASSPATH(doc, parentE, path);
    }

    public static Element createVALUEREFERENCE(Document doc, Element parentE, CIMObjectPath path) {
        Element objectpathE = doc.createElement("VALUE.REFERENCE");
        String ns = path.getNameSpace();
        if (path.getHost() == null || "".equals(path.getHost().trim())) {
            if (path.getNameSpace() == null || "".equals(ns.trim())) {
                CIMXMLBuilderImpl.createINSTANCENAME(doc, objectpathE, path);
            } else {
                CIMXMLBuilderImpl.createLOCALOBJECTPATH(doc, objectpathE, path);
            }
        } else {
            Vector keys = path.getKeys();
            if (keys.size() > 0) {
                CIMXMLBuilderImpl.createINSTANCEPATH(doc, objectpathE, path);
            } else {
                CIMXMLBuilderImpl.createCLASSPATH(doc, objectpathE, path);
            }
        }
        parentE.appendChild(objectpathE);
        return objectpathE;
    }

    public static Element createINSTANCENAME(Document doc, Element parentE, CIMObjectPath instanceOP) {
        Element instancenameE = doc.createElement("INSTANCENAME");
        String classname = instanceOP.getObjectName();
        if (classname != null) {
            instancenameE.setAttribute("CLASSNAME", classname);
        }
        Vector keysV = instanceOP.getKeys();
        for (int ii = 0; ii < keysV.size(); ++ii) {
            CIMProperty p = (CIMProperty)keysV.elementAt(ii);
            String pName = p.getName();
            CIMValue pValue = p.getValue();
            if (pValue == null) {
                CIMDataType type = p.getType();
                switch (type.getType()) {
                    case 8: {
                        pValue = new CIMValue("", type);
                        break;
                    }
                    case 0: {
                        pValue = new CIMValue(new UnsignedInt8(0), type);
                        break;
                    }
                    case 2: {
                        pValue = new CIMValue(new UnsignedInt16(0), type);
                        break;
                    }
                    case 4: {
                        pValue = new CIMValue(new UnsignedInt32(0), type);
                        break;
                    }
                    case 6: {
                        pValue = new CIMValue(new UnsignedInt64(BigInteger.valueOf(0L)), type);
                        break;
                    }
                    case 1: {
                        pValue = new CIMValue(new Byte(0), type);
                        break;
                    }
                    case 3: {
                        pValue = new CIMValue(new Short(0), type);
                        break;
                    }
                    case 5: {
                        pValue = new CIMValue(new Integer(0), type);
                        break;
                    }
                    case 7: {
                        pValue = new CIMValue(new Long(0L), type);
                        break;
                    }
                    case 15: {
                        pValue = new CIMValue(new UnsignedInt64(BigInteger.valueOf(0L)), type);
                        break;
                    }
                    default: {
                        throw new CIMException("CIM_ERR_INVALID_PARAMETER", "Null CIM Property value" + p);
                    }
                }
            }
            Element keybindingE = CIMXMLBuilderImpl.createKEYBINDING(doc, instancenameE, pName);
            if (pValue.getType().isReferenceType()) {
                CIMObjectPath refOP = (CIMObjectPath)pValue.getValue();
                CIMXMLBuilderImpl.createVALUEREFERENCE(doc, keybindingE, refOP);
                continue;
            }
            String valueStr = pValue.getValue().toString();
            String valueTypeStr = CIMXMLBuilderImpl.getTypeStr(pValue.getType());
            CIMXMLBuilderImpl.createKEYVALUE(doc, keybindingE, valueTypeStr, valueStr);
        }
        parentE.appendChild(instancenameE);
        return instancenameE;
    }

    public static Element createCLASSPATH(Document doc, Element parentE, CIMObjectPath path) {
        Element classpathE = doc.createElement("CLASSPATH");
        CIMXMLBuilderImpl.createCLASSNAME(doc, classpathE, path.getNameSpace());
        parentE.appendChild(classpathE);
        return classpathE;
    }

    public static void createPARAMETERS(Document doc, Element parentE, Vector parameters) {
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            CIMParameter parameter = (CIMParameter)iter.next();
            CIMXMLBuilderImpl.createPARAMETER(doc, parentE, parameter);
        }
    }

    public static Element createPARAMETER(Document doc, Element parentE, CIMParameter parameter) {
        Element parameterE = doc.createElement("PARAMETER");
        CIMDataType cimDataType = parameter.getType();
        if (cimDataType != null) {
            if (cimDataType.isArrayType()) {
                if (cimDataType.isReferenceType()) {
                    parameterE = doc.createElement("PARAMETER.REFARRAY");
                    parameterE.setAttribute("NAME", parameter.getName());
                    parameterE.setAttribute("REFERENCECLASS", cimDataType.getRefClassName());
                    CIMXMLBuilderImpl.createQUALIFIERS(doc, parameterE, parameter.getQualifiers());
                } else {
                    parameterE = doc.createElement("PARAMETER.ARRAY");
                    parameterE.setAttribute("NAME", parameter.getName());
                    String datatype = CIMXMLBuilderImpl.getTypeStr(parameter.getType());
                    if (datatype != null && datatype.length() != 0) {
                        parameterE.setAttribute("TYPE", datatype);
                    }
                    parameterE.setAttribute("REFERENCECLASS", cimDataType.getRefClassName());
                    CIMXMLBuilderImpl.createQUALIFIERS(doc, parameterE, parameter.getQualifiers());
                }
                parentE.appendChild(parameterE);
                return parameterE;
            }
            if (cimDataType.isReferenceType()) {
                parameterE = doc.createElement("PARAMETER.REFERENCE");
                parameterE.setAttribute("NAME", parameter.getName());
                parameterE.setAttribute("REFERENCECLASS", cimDataType.getRefClassName());
                CIMXMLBuilderImpl.createQUALIFIERS(doc, parameterE, parameter.getQualifiers());
                parentE.appendChild(parameterE);
                return parameterE;
            }
            String datatype = CIMXMLBuilderImpl.getTypeStr(parameter.getType());
            if (datatype != null && datatype.length() != 0) {
                parameterE.setAttribute("TYPE", datatype);
            }
        }
        parameterE.setAttribute("NAME", parameter.getName());
        CIMXMLBuilderImpl.createQUALIFIERS(doc, parameterE, parameter.getQualifiers());
        parentE.appendChild(parameterE);
        return parameterE;
    }

    public static void createMETHODS(Document doc, Element parentE, Vector methods, String classname) {
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            CIMMethod method = (CIMMethod)iter.next();
            CIMXMLBuilderImpl.createMETHOD(doc, parentE, method, classname);
        }
    }

    public static Element createMETHOD(Document doc, Element parentE, CIMMethod method, String classname) {
        Element methodE = doc.createElement("METHOD");
        methodE.setAttribute("NAME", method.getName());
        String datatype = CIMXMLBuilderImpl.getTypeStr(method.getType());
        methodE.setAttribute("TYPE", datatype);
        String classorigin = method.getOriginClass();
        if (classorigin != null && classorigin.length() != 0) {
            methodE.setAttribute("CLASSORIGIN", classorigin);
        }
        if (classorigin != null && classorigin.equalsIgnoreCase(classname)) {
            methodE.setAttribute("PROPAGATED", "true");
        } else {
            methodE.setAttribute("PROPAGATED", "false");
        }
        CIMXMLBuilderImpl.createQUALIFIERS(doc, methodE, method.getQualifiers());
        CIMXMLBuilderImpl.createPARAMETERS(doc, methodE, method.getParameters());
        parentE.appendChild(methodE);
        return methodE;
    }

    public static Element createCLASS(Document doc, Element parentE, CIMClass clazz) {
        Element classE = CIMXMLBuilderImpl.createCLASS(doc, parentE, clazz.getName(), clazz.getSuperClass());
        CIMXMLBuilderImpl.createQUALIFIERS(doc, classE, clazz.getQualifiers());
        CIMXMLBuilderImpl.createPROPERTIES(doc, classE, clazz.getProperties());
        CIMXMLBuilderImpl.createMETHODS(doc, classE, clazz.getMethods(), clazz.getName());
        return classE;
    }

    public static Element createHOST(Document doc, Element parentE, String host) {
        Element hostE = doc.createElement("HOST");
        Text hostT = doc.createTextNode(host);
        hostE.appendChild(hostT);
        parentE.appendChild(hostE);
        return hostE;
    }

    public static Element createNAMESPACEPATH(Document doc, Element parentE, CIMObjectPath path) {
        Element namespacepathE = doc.createElement("NAMESPACEPATH");
        String host = path.getHost();
        if (host == null) {
            host = "unassigned-hostname";
        }
        CIMXMLBuilderImpl.createHOST(doc, namespacepathE, host);
        CIMXMLBuilderImpl.createLOCALNAMESPACEPATH(doc, namespacepathE, path);
        parentE.appendChild(namespacepathE);
        return namespacepathE;
    }

    public static Element createINSTANCEPATH(Document doc, Element parentE, CIMObjectPath path) {
        Element instancepathE = doc.createElement("INSTANCEPATH");
        CIMXMLBuilderImpl.createNAMESPACEPATH(doc, instancepathE, path);
        CIMXMLBuilderImpl.createINSTANCENAME(doc, instancepathE, path);
        parentE.appendChild(instancepathE);
        return instancepathE;
    }

    public static Element createVALUENAMEDINSTANCE(Document doc, Element parentE, CIMObjectPath path, CIMInstance inst) {
        Element valuenamedinstanceE = doc.createElement("VALUE.NAMEDINSTANCE");
        CIMXMLBuilderImpl.createINSTANCENAME(doc, valuenamedinstanceE, path);
        CIMXMLBuilderImpl.createINSTANCE(doc, valuenamedinstanceE, inst);
        parentE.appendChild(valuenamedinstanceE);
        return valuenamedinstanceE;
    }

    public static Element createVALUENAMEDINSTANCE(Document doc, Element parentE, CIMInstance inst) {
        Element valuenamedinstanceE = doc.createElement("VALUE.NAMEDINSTANCE");
        CIMXMLBuilderImpl.createINSTANCENAME(doc, valuenamedinstanceE, inst.getObjectPath());
        CIMXMLBuilderImpl.createINSTANCE(doc, valuenamedinstanceE, inst);
        parentE.appendChild(valuenamedinstanceE);
        return valuenamedinstanceE;
    }

    public static Element createVALUEOBJECTWITHPATH(Document doc, Element parentE, Object obj, CIMNameSpace ns) {
        Element valueobjectwithpathE = doc.createElement("VALUE.OBJECTWITHPATH");
        if (obj instanceof CIMClass) {
            CIMClass clazz = (CIMClass)obj;
            if (clazz.getObjectPath().getNameSpace() == null || clazz.getObjectPath().getNameSpace().length() == 0) {
                clazz.getObjectPath().setNameSpace(ns);
            }
            CIMXMLBuilderImpl.createCLASSPATH(doc, valueobjectwithpathE, clazz.getObjectPath());
            CIMXMLBuilderImpl.createCLASS(doc, valueobjectwithpathE, clazz);
        } else if (obj instanceof CIMInstance) {
            CIMInstance inst = (CIMInstance)obj;
            if (inst.getObjectPath().getNameSpace() == null || inst.getObjectPath().getNameSpace().length() == 0) {
                inst.getObjectPath().setNameSpace(ns);
            }
            CIMXMLBuilderImpl.createINSTANCEPATH(doc, valueobjectwithpathE, inst.getObjectPath());
            CIMXMLBuilderImpl.createINSTANCE(doc, valueobjectwithpathE, inst);
        }
        parentE.appendChild(valueobjectwithpathE);
        return valueobjectwithpathE;
    }

    public static Element createVALUEOBJECTWITHLOCALPATH(Document doc, Element parentE, Object obj, CIMNameSpace ns) {
        Element valueobjectwithpathE = doc.createElement("VALUE.OBJECTWITHLOCALPATH");
        if (obj instanceof CIMClass) {
            CIMClass clazz = (CIMClass)obj;
            if (clazz.getObjectPath().getNameSpace() == null || clazz.getObjectPath().getNameSpace().length() == 0) {
                clazz.getObjectPath().setNameSpace(ns);
            }
            CIMXMLBuilderImpl.createLOCALCLASSPATH(doc, valueobjectwithpathE, clazz.getObjectPath());
            CIMXMLBuilderImpl.createCLASS(doc, valueobjectwithpathE, clazz);
        } else if (obj instanceof CIMInstance) {
            CIMInstance inst = (CIMInstance)obj;
            if (inst.getObjectPath().getNameSpace() == null || inst.getObjectPath().getNameSpace().length() == 0) {
                inst.getObjectPath().setNameSpace(ns);
            }
            CIMXMLBuilderImpl.createLOCALINSTANCEPATH(doc, valueobjectwithpathE, inst.getObjectPath());
            CIMXMLBuilderImpl.createINSTANCE(doc, valueobjectwithpathE, inst);
        }
        parentE.appendChild(valueobjectwithpathE);
        return valueobjectwithpathE;
    }

    public static Element createIRETURNVALUE_ERROR(Document doc, Element parentE, CIMError error) {
        Element ireturnvalueE = doc.createElement("IRETURNVALUE");
        parentE.appendChild(ireturnvalueE);
        return ireturnvalueE;
    }

    public static Element createIRETURNVALUE_GETINSTANCE(Document doc, Element parentE, CIMInstance inst) {
        Element ireturnvalueE = doc.createElement("IRETURNVALUE");
        CIMXMLBuilderImpl.createINSTANCENAME(doc, ireturnvalueE, inst.getObjectPath());
        return ireturnvalueE;
    }

    public static Element createIRETURNVALUE_ASSOCIATORS_NAMES(Document doc, Element parentE, Vector resultSet) throws Exception {
        Element ireturnvalueE = doc.createElement("IRETURNVALUE");
        Iterator iter = resultSet.iterator();
        while (iter.hasNext()) {
            CIMObjectPath path = (CIMObjectPath)iter.next();
            if (path.getHost() == null || "".equals(path.getHost())) {
                CIMXMLBuilderImpl.createLOCALOBJECTPATH(doc, ireturnvalueE, path);
                continue;
            }
            CIMXMLBuilderImpl.createOBJECTPATH(doc, ireturnvalueE, path);
        }
        parentE.appendChild(ireturnvalueE);
        return ireturnvalueE;
    }

    public static Element createIRETURNVALUE_ASSOCIATORS(Document doc, Element parentE, Vector resultSet, CIMNameSpace ns) throws Exception {
        Element ireturnvalueE = doc.createElement("IRETURNVALUE");
        Iterator iter = resultSet.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            CIMObjectPath op = null;
            if (obj instanceof CIMClass) {
                op = ((CIMClass)obj).getObjectPath();
            } else if (obj instanceof CIMInstance) {
                op = ((CIMInstance)obj).getObjectPath();
            }
            if (op.getHost() == null || "".equals(op.getHost())) {
                CIMXMLBuilderImpl.createVALUEOBJECTWITHLOCALPATH(doc, ireturnvalueE, obj, ns);
                continue;
            }
            CIMXMLBuilderImpl.createVALUEOBJECTWITHPATH(doc, ireturnvalueE, obj, ns);
        }
        parentE.appendChild(ireturnvalueE);
        return ireturnvalueE;
    }

    public static Element createIRETURNVALUE_ENUMERATE_INSTANCENAME(Document doc, Element parentE, Vector resultSet, CIMNameSpace ns) throws Exception {
        Element ireturnvalueE = doc.createElement("IRETURNVALUE");
        Iterator iter = resultSet.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            CIMObjectPath op = null;
            if (obj instanceof CIMClass) {
                op = ((CIMClass)obj).getObjectPath();
            } else if (obj instanceof CIMInstance) {
                op = ((CIMInstance)obj).getObjectPath();
            }
            if (op.getHost() == null || "".equals(op.getHost())) {
                CIMXMLBuilderImpl.createVALUEOBJECTWITHLOCALPATH(doc, ireturnvalueE, obj, ns);
                continue;
            }
            CIMXMLBuilderImpl.createVALUEOBJECTWITHPATH(doc, ireturnvalueE, obj, ns);
        }
        parentE.appendChild(ireturnvalueE);
        return ireturnvalueE;
    }

    public static Element createIRETURNVALUE(Document doc, Element parentE, Vector resultSet) {
        Element ireturnvalueE = doc.createElement("IRETURNVALUE");
        if (resultSet.size() > 0) {
            Object obj = resultSet.elementAt(0);
            if (obj instanceof CIMClass) {
                Iterator iter = resultSet.iterator();
                while (iter.hasNext()) {
                    CIMClass clazz = (CIMClass)iter.next();
                    Element classnameE = doc.createElement("CLASSNAME");
                    ireturnvalueE.appendChild(classnameE);
                    if (clazz.getName() == null) continue;
                    classnameE.setAttribute("NAME", clazz.getName());
                }
            } else if (obj instanceof CIMInstance) {
                Iterator iter = resultSet.iterator();
                while (iter.hasNext()) {
                    CIMInstance inst = (CIMInstance)iter.next();
                    CIMXMLBuilderImpl.createVALUENAMEDINSTANCE(doc, ireturnvalueE, inst);
                }
            }
        }
        parentE.appendChild(ireturnvalueE);
        return ireturnvalueE;
    }

    public static Element createIRETURNVALUE_ENUMERATE_CLASSNAME(Document doc, Element parentE, Vector resultSet) {
        Element ireturnvalueE = doc.createElement("IRETURNVALUE");
        if (resultSet.size() > 0) {
            Iterator iter = resultSet.iterator();
            while (iter.hasNext()) {
                CIMClass clazz = (CIMClass)iter.next();
                Element classnameE = doc.createElement("CLASSNAME");
                ireturnvalueE.appendChild(classnameE);
                if (clazz.getName() == null) continue;
                classnameE.setAttribute("NAME", clazz.getName());
            }
        }
        parentE.appendChild(ireturnvalueE);
        return ireturnvalueE;
    }

    public static Element createIndication_response(Document doc, String ID, CIMError error) {
        Element cimE = CIMXMLBuilderImpl.createCIM(doc);
        Element messageE = CIMXMLBuilderImpl.createMESSAGE(doc, cimE, ID, "1.0");
        Element simpleexprspE = CIMXMLBuilderImpl.createSIMPLEEXPRSP(doc, messageE);
        Element expmethodresponseE = CIMXMLBuilderImpl.createEXPMETHODRESPONSE(doc, simpleexprspE, "ExportIndication");
        if (error == null) {
            CIMXMLBuilderImpl.createIRETURNVALUE(doc, expmethodresponseE);
        } else {
            CIMXMLBuilderImpl.createERROR(doc, expmethodresponseE, error);
        }
        return cimE;
    }

    public static Element createIRETURNVALUE_ENUMERATE_INSTANCE(Document doc, Element parentE, Vector resultSet) {
        Element ireturnvalueE = doc.createElement("IRETURNVALUE");
        if (resultSet.size() > 0) {
            Iterator iter = resultSet.iterator();
            while (iter.hasNext()) {
                CIMInstance inst = (CIMInstance)iter.next();
                CIMXMLBuilderImpl.createVALUENAMEDINSTANCE(doc, ireturnvalueE, inst);
            }
        }
        parentE.appendChild(ireturnvalueE);
        return ireturnvalueE;
    }

    public static String getTypeStr(CIMDataType type) {
        if (type == null) {
            return "string";
        }
        switch (type.getType()) {
            case 0: 
            case 16: {
                return "uint8";
            }
            case 2: 
            case 18: {
                return "uint16";
            }
            case 4: 
            case 20: {
                return "uint32";
            }
            case 6: 
            case 22: {
                return "uint64";
            }
            case 1: 
            case 17: {
                return "sint8";
            }
            case 3: 
            case 19: {
                return "sint16";
            }
            case 5: 
            case 21: {
                return "sint32";
            }
            case 7: 
            case 23: {
                return "sint64";
            }
            case 8: 
            case 24: {
                return "string";
            }
            case 9: 
            case 25: {
                return "boolean";
            }
            case 10: 
            case 26: {
                return "real32";
            }
            case 11: 
            case 27: {
                return "real64";
            }
            case 12: 
            case 28: {
                return "datetime";
            }
            case 13: 
            case 29: {
                return "char16";
            }
            case 15: {
                return "numeric";
            }
            case 32: {
                return "null";
            }
        }
        return "";
    }

    public static String getOpTypeStr(CIMDataType type) {
        if (type == null) {
            return "string";
        }
        switch (type.getType()) {
            case 0: 
            case 16: {
                return "numeric";
            }
            case 2: 
            case 18: {
                return "numeric";
            }
            case 4: 
            case 20: {
                return "numeric";
            }
            case 6: 
            case 22: {
                return "numeric";
            }
            case 1: 
            case 17: {
                return "numeric";
            }
            case 3: 
            case 19: {
                return "numeric";
            }
            case 5: 
            case 21: {
                return "numeric";
            }
            case 7: 
            case 23: {
                return "numeric";
            }
            case 8: 
            case 24: {
                return "string";
            }
            case 9: 
            case 25: {
                return "boolean";
            }
            case 10: 
            case 26: {
                return "numeric";
            }
            case 11: 
            case 27: {
                return "numeric";
            }
            case 12: 
            case 28: {
                return "string";
            }
            case 13: 
            case 29: {
                return "string";
            }
            case 15: {
                return "numeric";
            }
            case 32: {
                return "string";
            }
        }
        return "string";
    }

    public static Element createLOCALNAMESPACEPATH(Document doc, Element parentE, CIMObjectPath name) {
        if (name == null) {
            return null;
        }
        Element localnamespacepathE = doc.createElement("LOCALNAMESPACEPATH");
        String ns = name.getNameSpace();
        if (ns != null && ns.length() > 0) {
            int next = 0;
            int prev = 0;
            while ((next = ns.indexOf(47, prev)) > -1) {
                String path = ns.substring(prev, next);
                if (path.length() > 0) {
                    CIMXMLBuilderImpl.createNAMESPACE(doc, localnamespacepathE, path);
                }
                prev = next + 1;
            }
            if (prev < ns.length()) {
                CIMXMLBuilderImpl.createNAMESPACE(doc, localnamespacepathE, ns.substring(prev, ns.length()));
            }
        }
        parentE.appendChild(localnamespacepathE);
        return localnamespacepathE;
    }
}

