/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.cim.CIMSimpleDateTime;
import org.sblim.wbem.util.GlobalProperties;

public class CIMDateTime
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5756487333233101157L;
    protected String iDateString;
    protected Calendar iCalendar = null;
    protected boolean iInterval = false;
    protected int iYear;
    protected int iMonth;
    protected int iDay;
    protected int iHour;
    protected int iMinute;
    protected int iSecond;
    protected int iMillisecond;
    protected int iMicrosecond;
    protected int iOffsetMinute;
    protected int iPrecision = 12;
    public static final int YEAR_PRECISION = 0;
    public static final int MONTH_PRECISION = 1;
    public static final int DAY_PRECISION = 2;
    public static final int HOUR_PRECISION = 3;
    public static final int MINUTE_PRECISION = 4;
    public static final int SECOND_PRECISION = 5;
    public static final int MILLI_ONE_DIGIT_PRECISION = 6;
    public static final int MILLI_TWO_DIGIT_PRECISION = 7;
    public static final int MILLI_THREE_DIGIT_PRECISION = 8;
    public static final int MILLI_FOUR_DIGIT_PRECISION = 9;
    public static final int MILLI_FIVE_DIGIT_PRECISION = 10;
    public static final int MILLI_SIX_DIGIT_PRECISION = 11;
    public static final int FULL_PRECISION = 12;

    public CIMDateTime(Calendar pCalendar) {
        if (pCalendar == null) {
            throw new IllegalArgumentException("null calendar argument");
        }
        Calendar calendar = (Calendar)pCalendar.clone();
        this.iOffsetMinute = calendar.getTimeZone().inDaylightTime(calendar.getTime()) ? (calendar.get(15) + calendar.get(16)) / 60000 : calendar.get(15) / 60000;
        this.iYear = calendar.get(1);
        this.iMonth = calendar.get(2) - calendar.getMinimum(2) + 1;
        this.iDay = calendar.get(5) - calendar.getMinimum(5) + 1;
        this.iHour = calendar.get(11) - calendar.getMinimum(11);
        this.iMinute = calendar.get(12) - calendar.getMinimum(12);
        this.iSecond = calendar.get(13) - calendar.getMinimum(13);
        this.iMillisecond = calendar.get(14) - calendar.getMinimum(14);
        this.iPrecision = 12;
    }

    public CIMDateTime(String pDateString) {
        char sign = pDateString.charAt(21);
        if (sign == ':') {
            this.iInterval = true;
        }
        CIMDateTime.valueOf(this, pDateString);
    }

    protected CIMDateTime() {
    }

    public Object clone() {
        return this.clone(new CIMDateTime());
    }

    protected CIMDateTime clone(CIMDateTime pClone) {
        pClone.iCalendar = this.iCalendar;
        pClone.iYear = this.iYear;
        pClone.iMonth = this.iMonth;
        pClone.iDay = this.iDay;
        pClone.iHour = this.iHour;
        pClone.iMinute = this.iMinute;
        pClone.iSecond = this.iSecond;
        pClone.iMillisecond = this.iMillisecond;
        pClone.iMicrosecond = this.iMicrosecond;
        pClone.iPrecision = this.iPrecision;
        return pClone;
    }

    public static CIMDateTime valueOf(String pDateString) {
        CIMDateTime datetime = null;
        char sign = pDateString.charAt(21);
        if (sign == ':') {
            datetime = new CIMDateTime();
            datetime.iInterval = true;
        } else {
            datetime = new CIMSimpleDateTime();
        }
        return CIMDateTime.valueOf(datetime, pDateString);
    }

    protected static CIMDateTime valueOf(CIMDateTime pDatetime, String pDateString) {
        try {
            String _microsecond;
            int i;
            String _second;
            String _minute;
            if (pDateString == null) {
                throw new IllegalArgumentException("null calendar argument");
            }
            char sign = pDateString.charAt(21);
            pDatetime.iDateString = pDateString;
            if (pDateString.length() != 25) {
                throw new IllegalArgumentException("Invalid length of cim date type: " + pDateString);
            }
            if (!pDatetime.iInterval) {
                String _day;
                pDatetime.iPrecision = 12;
                String _year = pDateString.substring(0, 4);
                if (_year.indexOf(42) > -1) {
                    pDatetime.iPrecision = 0;
                } else {
                    pDatetime.iYear = Integer.parseInt(_year);
                }
                String _month = pDateString.substring(4, 6);
                if (_month.indexOf(42) > -1) {
                    if (pDatetime.iPrecision == 12) {
                        pDatetime.iPrecision = 1;
                    }
                } else {
                    pDatetime.iMonth = Integer.parseInt(_month);
                }
                if ((_day = pDateString.substring(6, 8)).indexOf(42) > -1) {
                    if (pDatetime.iPrecision == 12) {
                        pDatetime.iPrecision = 2;
                    }
                } else {
                    pDatetime.iDay = Integer.parseInt(_day);
                }
            } else {
                String _day = pDateString.substring(0, 8);
                if (_day.indexOf(42) > -1) {
                    if (pDatetime.iPrecision == 12) {
                        pDatetime.iPrecision = 2;
                    }
                } else {
                    pDatetime.iDay = Integer.parseInt(_day);
                }
            }
            String _hour = pDateString.substring(8, 10);
            if (_hour.indexOf(42) > -1) {
                if (pDatetime.iPrecision == 12) {
                    pDatetime.iPrecision = 3;
                }
            } else {
                pDatetime.iHour = Integer.parseInt(_hour);
            }
            if ((_minute = pDateString.substring(10, 12)).indexOf(42) > -1) {
                if (pDatetime.iPrecision == 12) {
                    pDatetime.iPrecision = 4;
                }
            } else {
                pDatetime.iMinute = Integer.parseInt(_minute);
            }
            if ((_second = pDateString.substring(12, 14)).indexOf(42) > -1) {
                if (pDatetime.iPrecision == 12) {
                    pDatetime.iPrecision = 5;
                }
            } else {
                pDatetime.iSecond = Integer.parseInt(_second);
            }
            if ((i = (_microsecond = pDateString.substring(15, 21)).indexOf(42)) > -1) {
                if (pDatetime.iPrecision == 12) {
                    pDatetime.iPrecision = i + 6;
                }
                pDatetime.iMillisecond = Integer.parseInt(_microsecond.replace('*', '0')) / 1000;
                pDatetime.iMicrosecond = Integer.parseInt(_microsecond.replace('*', '0')) % 1000;
            } else {
                pDatetime.iMillisecond = Integer.parseInt(_microsecond) / 1000;
                pDatetime.iMicrosecond = Integer.parseInt(_microsecond) % 1000;
            }
            pDatetime.iOffsetMinute = Integer.parseInt(pDateString.substring(22, 25));
            if (sign != ':') {
                if (sign == '-') {
                    pDatetime.iOffsetMinute = -pDatetime.iOffsetMinute;
                } else if (sign != '+') {
                    throw new IllegalArgumentException("Invalid cim date type:" + pDateString);
                }
            } else if (pDatetime.iOffsetMinute > 0) {
                throw new IllegalArgumentException("Invalid offset minute of cim date time: " + pDateString);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            Logger logger = GlobalProperties.getLogger();
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "error while parsing CIMDateTime value: " + pDateString, e);
            }
            throw new IllegalArgumentException("Invalid cim date type: " + pDateString);
        }
        return pDatetime;
    }

    public int hashCode() {
        int hashvalue = 31;
        if (this.iInterval) {
            return this.getCalendar().hashCode();
        }
        hashvalue *= this.iDay;
        hashvalue *= this.iHour;
        hashvalue *= this.iMinute;
        hashvalue *= this.iHour;
        hashvalue *= this.iSecond;
        hashvalue *= this.iMillisecond;
        hashvalue *= this.iMicrosecond;
        return hashvalue *= this.iPrecision;
    }

    public boolean after(CIMDateTime pThat) {
        if (pThat == null) {
            throw new IllegalArgumentException("null calendar argument");
        }
        if (this.iInterval || pThat.iInterval) {
            return false;
        }
        return this.getCalendar().after(pThat.getCalendar());
    }

    public boolean before(CIMDateTime pThat) {
        if (pThat == null) {
            throw new IllegalArgumentException("null calendar argument");
        }
        if (this.iInterval || pThat.iInterval) {
            return false;
        }
        return this.getCalendar().before(pThat.getCalendar());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CIMDateTime)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        CIMDateTime that = (CIMDateTime)o;
        if (this.iInterval == that.iInterval) {
            if (!this.iInterval) {
                return this.getCalendar().equals(that.getCalendar());
            }
            return this.iDay == that.iDay && this.iHour == that.iHour && this.iSecond == that.iSecond && this.iMillisecond == that.iMillisecond;
        }
        return false;
    }

    public boolean isInterval() {
        return this.iInterval;
    }

    public Calendar getCalendar() {
        if (this.iCalendar == null && !this.iInterval) {
            TimeZone timezone = TimeZone.getDefault();
            timezone.setRawOffset(this.iOffsetMinute * 60 * 1000);
            this.iCalendar = Calendar.getInstance(timezone);
            this.iCalendar.set(this.iYear, this.iMonth - 1 + this.iCalendar.getMinimum(2), this.iDay - 1 + this.iCalendar.getMinimum(5), this.iHour + this.iCalendar.getMinimum(11), this.iMinute + this.iCalendar.getMinimum(12), this.iSecond + this.iCalendar.getMinimum(13));
            this.iCalendar.set(14, this.iMillisecond);
        }
        return (Calendar)this.iCalendar.clone();
    }

    public String toMOF() {
        StringBuffer buf = new StringBuffer();
        if (!this.iInterval) {
            if (this.isYearPrecision()) {
                buf.append(this.zeroPadding(this.iYear, 4));
            } else {
                buf.append(this.starPadding(4));
            }
            if (this.isMonthPrecision()) {
                buf.append(this.zeroPadding(this.iMonth, 2));
            } else {
                buf.append(this.starPadding(2));
            }
            if (this.isDayPrecision()) {
                buf.append(this.zeroPadding(this.iDay, 2));
            } else {
                buf.append(this.starPadding(2));
            }
        } else if (this.isDayPrecision()) {
            buf.append(this.zeroPadding(this.iDay, 8));
        } else {
            buf.append(this.starPadding(8));
        }
        if (this.isHourPrecision()) {
            buf.append(this.zeroPadding(this.iHour, 2));
        } else {
            buf.append(this.starPadding(2));
        }
        if (this.isMinutePrecision()) {
            buf.append(this.zeroPadding(this.iMinute, 2));
        } else {
            buf.append(this.starPadding(2));
        }
        if (this.isSecondPrecision()) {
            buf.append(this.zeroPadding(this.iSecond, 2));
        } else {
            buf.append(this.starPadding(2));
        }
        buf.append('.');
        int microsecodsPrecision = this.getMicrosecodsPrecision();
        if (microsecodsPrecision < 6) {
            String millis = this.zeroPadding(this.iMillisecond, 3);
            String micros = this.zeroPadding(this.iMicrosecond, 3);
            int totalMicros = Integer.parseInt(millis + micros);
            for (int n = 0; n < 6 - microsecodsPrecision; ++n) {
                totalMicros /= 10;
            }
            if (microsecodsPrecision > 0) {
                buf.append(this.zeroPadding(totalMicros, microsecodsPrecision));
            }
            buf.append(this.starPadding(6 - microsecodsPrecision));
        } else {
            buf.append(this.zeroPadding(this.iMillisecond, 3));
            buf.append(this.zeroPadding(this.iMicrosecond, 3));
        }
        if (this.iInterval) {
            buf.append(":000");
        } else if (this.iOffsetMinute > 0) {
            buf.append('+');
            buf.append(this.zeroPadding(this.iOffsetMinute, 3));
        } else {
            buf.append('-');
            buf.append(this.zeroPadding(-this.iOffsetMinute, 3));
        }
        return buf.toString();
    }

    protected String starPadding(int pDigits) {
        if (pDigits > 0) {
            return "**********".substring(0, pDigits);
        }
        return "";
    }

    protected String zeroPadding(int pValue, int pDigits) {
        String str = String.valueOf(pValue);
        if (pDigits - str.length() > 0) {
            return "00000000000".substring(0, pDigits - str.length()) + str;
        }
        return str;
    }

    public String toString() {
        return this.toMOF();
    }

    public int getMillisecond() {
        return this.iMillisecond;
    }

    public int getMicrosecond() {
        return this.iMicrosecond;
    }

    public int getMinute() {
        return this.iMinute;
    }

    public int getDay() {
        return this.iDay;
    }

    public int getHour() {
        return this.iHour;
    }

    public int getOffsetMinute() {
        return this.iOffsetMinute;
    }

    public int getSeconds() {
        return this.iSecond;
    }

    public void setHour(int pHour) {
        if (pHour < 0 || pHour > 23) {
            throw new IllegalArgumentException("invalid value of hour [1-24]:" + pHour);
        }
        this.iCalendar = null;
        this.iHour = pHour;
    }

    public void setMilliseconds(int pMillisecond) {
        if (pMillisecond < 0 || pMillisecond > 999) {
            throw new IllegalArgumentException("invalid value of millisecond [0-999]:" + pMillisecond);
        }
        this.iCalendar = null;
        this.iMillisecond = pMillisecond;
    }

    public void setMicroseconds(int pMicrosecond) {
        if (pMicrosecond < 0 || pMicrosecond > 999) {
            throw new IllegalArgumentException("invalid value of microsecond [0-999]:" + pMicrosecond);
        }
        this.iCalendar = null;
        this.iMicrosecond = pMicrosecond;
    }

    public void setMinute(int pMinute) {
        if (pMinute < 0 || pMinute > 59) {
            throw new IllegalArgumentException("invalid value of minute:" + pMinute);
        }
        this.iCalendar = null;
        this.iMinute = pMinute;
    }

    public void setOffsetMinute(int pOffsetMinutes) {
        if (pOffsetMinutes < -999 || pOffsetMinutes > 999) {
            throw new IllegalArgumentException("invalid value of offset minute:" + pOffsetMinutes);
        }
        this.iCalendar = null;
        this.iOffsetMinute = pOffsetMinutes;
    }

    public void setSecond(int pSecond) {
        if (pSecond < 0 || pSecond > 59) {
            throw new IllegalArgumentException("invalid value of second:" + pSecond);
        }
        this.iCalendar = null;
        this.iSecond = pSecond;
    }

    public boolean isDayPrecision() {
        return this.iPrecision > 2;
    }

    public boolean isHourPrecision() {
        return this.iPrecision > 3;
    }

    public int getMicrosecodsPrecision() {
        if (this.iPrecision > 5) {
            return this.iPrecision - 6;
        }
        return 0;
    }

    public boolean isMinutePrecision() {
        return this.iPrecision > 4;
    }

    public boolean isMonthPrecision() {
        return this.iPrecision > 1;
    }

    public boolean isSecondPrecision() {
        return this.iPrecision > 5;
    }

    public boolean isYearPrecision() {
        return this.iPrecision > 0;
    }

    public void setPrecision(int pPrecision) {
        if (pPrecision < 0 || pPrecision > 12) {
            throw new IllegalArgumentException("precision argument out of range [0-11]:" + pPrecision);
        }
        this.iPrecision = pPrecision;
    }

    public int getPrecision() {
        return this.iPrecision;
    }

    public static void main(String[] args) {
        System.out.println(new CIMDateTime("12345678901234.567890:000"));
        System.out.println(new CIMDateTime("12345678901234.56789*:000"));
        System.out.println(new CIMDateTime("12345678901234.5678**:000"));
        System.out.println(new CIMDateTime("12345678901234.567***:000"));
        System.out.println(new CIMDateTime("12345678901234.56****:000"));
        System.out.println(new CIMDateTime("12345678901234.5*****:000"));
        System.out.println(new CIMDateTime("12345678901234.******:000"));
        System.out.println(new CIMDateTime("123456789012**.******:000"));
        System.out.println(new CIMDateTime("1234567890****.******:000"));
        System.out.println(new CIMDateTime("12345678******.******:000"));
        System.out.println(new CIMDateTime("1234**********.******+000"));
        System.out.println(new CIMDateTime("12*45678901234.567890+100"));
    }
}

