/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.xdoclet.core;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.Preferences;
import org.jboss.ide.eclipse.core.AbstractPlugin;
import org.osgi.framework.BundleContext;

public class XDocletCorePlugin
extends AbstractPlugin {
    public static final String JBOSS_NET_VERSION = "jboss.net.version";
    public static final String JBOSS_NET_VERSION_4_0 = "4.0";
    public static final String JBOSS_NET_VERSION_3_2 = "3.2";
    public static final String JBOSS_NET_VERSION_DEFAULT = "4.0";
    private URL[] modules;
    private URL[] xTagsXML;
    private static XDocletCorePlugin plugin;

    public XDocletCorePlugin() {
        plugin = this;
    }

    public URL[] getModules() {
        if (this.modules == null) {
            this.fetchModules();
        }
        return this.modules;
    }

    public URL[] getXTagsXml() {
        if (this.xTagsXML == null) {
            this.fetchXTagsXML();
        }
        return this.xTagsXML;
    }

    public void refreshModules() {
        this.fetchModules();
        this.fetchXTagsXML();
    }

    public void refreshXtagsXML() {
        this.fetchXTagsXML();
    }

    public String getJBossNetVersion() {
        Preferences prefs = this.getPluginPreferences();
        return prefs.getString(JBOSS_NET_VERSION);
    }

    public void setJBossNetVersion(String version) {
        if (!"4.0".equals(version) && !JBOSS_NET_VERSION_3_2.equals(version)) {
            throw new IllegalArgumentException(version);
        }
        Preferences prefs = this.getPluginPreferences();
        prefs.setValue(JBOSS_NET_VERSION, version);
        this.savePluginPreferences();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPluginPreferences().setDefault(JBOSS_NET_VERSION, "4.0");
        this.fetchModules();
    }

    protected void fetchModules() {
        StringBuffer cp = new StringBuffer();
        ArrayList<URL> result = new ArrayList<URL>();
        try {
            File[] files = this.getModuleFiles();
            int i = 0;
            while (i < files.length) {
                result.add(files[i].toURL());
                cp.append(files[i].getAbsolutePath()).append(File.pathSeparatorChar);
                ++i;
            }
        }
        catch (MalformedURLException mfue) {
            AbstractPlugin.logError((String)"Error while getting modules files", (Throwable)mfue);
        }
        System.setProperty("xdoclet.class.path", cp.toString());
        this.modules = result.toArray(new URL[result.size()]);
    }

    protected void fetchXTagsXML() {
        this.xTagsXML = this.getURLs("META-INF/xtags.xml");
    }

    protected File[] getModuleFiles() {
        File dir = new File(this.getBaseDir());
        File[] modules = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String fileName = file.getName();
                if (fileName.endsWith(".jar")) {
                    if (fileName.startsWith("xdoclet-module-jboss-net")) {
                        String version = XDocletCorePlugin.this.getJBossNetVersion();
                        return fileName.indexOf(version) != -1;
                    }
                    return true;
                }
                return false;
            }
        });
        return modules;
    }

    protected URL[] getURLs(String pattern) {
        ArrayList<URL> result = new ArrayList<URL>();
        try {
            File[] modules = this.getModuleFiles();
            int i = 0;
            while (i < modules.length) {
                JarFile jarFile = new JarFile(modules[i]);
                JarEntry xtagsXml = jarFile.getJarEntry(pattern);
                if (xtagsXml != null) {
                    result.add(new URL(new URL("jar:" + modules[i].toURL() + "!/"), pattern));
                }
                ++i;
            }
        }
        catch (IOException e) {
            AbstractPlugin.logError((String)"Error while getting modules URLs", (Throwable)e);
        }
        return result.toArray(new URL[result.size()]);
    }

    public static XDocletCorePlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (XDocletCorePlugin.getDefault() == null) {
            return "org.jboss.ide.eclipse.xdoclet.core";
        }
        return XDocletCorePlugin.getDefault().getBundle().getSymbolicName();
    }
}

