#!/bin/bash

#Copyright (C) 2006 - 2008 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#
# 変数
#

. /opt/hinemos/hinemos.cfg

DBUSER=hinemos
DBNAME=hinemos
DBPORT=24001
#DBPORT=5432
DBHOST=localhost
DUMP_PATH="."
PGDUMP_FILE_BASE="hinemos_pgdump"
SLAPCAT_FILE_BASE="hinemos_slapcat"

DATE=`date "+%Y-%m-%d_%H%M%S"`
REV=0
MESSAGE1="PostgreSQLをダンプします。"
MESSAGE2="OpenLDAPをダンプします。"

umask 377 


#
# function
# 
function usage {
        echo "使用方法:"
	echo "hinemos_mng_backup.sh -p : "$MESSAGE1
	echo "hinemos_mng_backup.sh -l : "$MESSAGE2
	return 0
}

#
# パラメタチェック
#

if [ $# -eq 0 ]; then
	usage
        exit 1
fi

for OPTION in "$@"
do
	case $OPTION in 
		-p|-l)
			;;
		*)
			usage
			exit 1
			;;
	esac
done

#
# パラメタに応じて処理
#

for OPTION in "$@"
do
	case $OPTION in
		-p)
			## pg_dump

			echo $MESSAGE1
			DUMP_FILE=$DUMP_PATH"/"$PGDUMP_FILE_BASE"."$DATE
			echo "ダンプ先ファイル名："$DUMP_FILE
			if [ -e $DUMP_FILE ]; then
				echo "file "$DUMP_FILE" already exists. please remove it at first,and try again." 
				exit 1
			fi
			
			pg_dump -U $DBUSER -p $DBPORT -h $DBHOST $DBNAME -f $DUMP_FILE -C
			#pg_dump -U $DBUSER -p $DBPORT -h $DBHOST $DBNAME -f $DUMP_FILE -Fc -b
			;;
		-l)
			## slapcat

			echo $MESSAGE2
			DUMP_FILE=$DUMP_PATH"/"$SLAPCAT_FILE_BASE"."$DATE
			echo "ダンプ先ファイル名："$DUMP_FILE
			if [ -e $DUMP_FILE ]; then
				echo "file "$DUMP_FILE" already exists. please remove it at first,and try again." 
				exit 1
			fi
			
			slapcat -l $DUMP_FILE
			;;
		*)
			exit 1
			;;
	esac
	if [ $? -ne 0 ]; then
		REV=$?
		echo "処理に失敗しました。"
		exit $REV
	fi
done

#
# 終了処理
#

echo "正常に終了しました。"

exit 0 
