#!/bin/sh

#Copyright (C) 2006 - 2008 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#設定情報読み込み

HINEMOS_HOME=`pwd`
. ${HINEMOS_HOME}/hinemos.cfg

#DBクラスタの初期化
${PG}/bin/initdb --no-local --encoding=UNICODE -D $PGDATA > /dev/null 2>&1
#${PG}/bin/initdb --no-local -D $PGDATA > /dev/null 2>&1
#${PG}/bin/initdb --no-local -D $PGDATA 

#ファイルのコピー
cp -p ${HINEMOS_HOME}/sbin/db_init/postgresql.conf $PGDATA

#PostgreSQLの起動
${HINEMOS_HOME}/bin/pg_start.sh

#hinemosDBの作成
${PG}/bin/createdb -p 24001 

#DDLのリストア
${PG}/bin/psql -q -p 24001 -f ${HINEMOS_HOME}/sbin/db_init/hinemos_db_ddl.sql > /dev/null 2>&1
#${PG}/bin/psql -q -p 24001 -f ${HINEMOS_HOME}/sbin/db_init/hinemos_db_ddl.sql

#SNMP Trap分のSQLの実行
${PG}/bin/psql -q -p 24001 -f ${HINEMOS_HOME}/sbin/db_init/hinemos_trap_events.sql > /dev/null 2>&1
#${PG}/bin/psql -q -p 24001 -f ${HINEMOS_HOME}/sbin/db_init/hinemos_trap_events.sql

#$HINEMOS_USERの初期パスワードを設定
${PG}/bin/psql -p 24001 -c "ALTER USER hinemos PASSWORD 'hinemos'" 

#PostgreSQLの停止
${HINEMOS_HOME}/bin/pg_stop.sh

#ファイルのコピー
cp -p ${HINEMOS_HOME}/sbin/db_init/pg_hba.conf $PGDATA
