/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.deployment;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.webservice.deployment.WSDDGenerator;

public class OperationDescription {
    private final Logger log = Logger.getLogger((Class)OperationDescription.class);
    private String name;
    private QName qname;
    private QName returnQName;
    private QName returnType;
    private boolean oneWay;
    private ArrayList parameters = new ArrayList();
    private ArrayList faults = new ArrayList();

    public OperationDescription(String name, QName qname) {
        if (name == null) {
            throw new IllegalArgumentException("Operation name cannot be null");
        }
        if (qname == null) {
            qname = new QName(name);
        }
        this.name = name;
        this.qname = qname;
    }

    public String getJavaName() {
        return this.name;
    }

    public String getWsdlName() {
        return this.getQName().getLocalPart();
    }

    public QName getQName() {
        return this.qname;
    }

    public QName getReturnQName() {
        return this.returnQName;
    }

    public QName getReturnType() {
        return this.returnType;
    }

    public void setReturnQName(QName returnQName) {
        this.returnQName = returnQName;
    }

    public void setReturnType(QName returnType) {
        this.returnType = returnType;
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public void setOneWay(boolean oneWay) {
        this.oneWay = oneWay;
    }

    public Iterator getParameters() {
        return this.parameters.iterator();
    }

    public void setParameters(List newList) {
        ArrayList oldList = this.parameters;
        this.parameters = new ArrayList();
        Iterator itNew = newList.iterator();
        while (itNew.hasNext()) {
            Parameter param = (Parameter)itNew.next();
            this.log.debug((Object)("Reordering: " + param.getName()));
            this.parameters.add(param);
            oldList.remove(param);
        }
        Iterator itOld = oldList.iterator();
        while (itOld.hasNext()) {
            Parameter param = (Parameter)itOld.next();
            if (param.inHeader || param.outHeader) {
                this.log.debug((Object)("Appending header: " + param.getName()));
                this.parameters.add(param);
                continue;
            }
            throw new IllegalStateException("Incomplete reorder list: " + param.getName());
        }
    }

    public void addParameter(Parameter param) {
        this.parameters.add(param);
    }

    public void addFault(Fault fault) {
        this.faults.add(fault);
    }

    public Parameter getParameterForName(String partName) {
        Parameter param = null;
        Iterator it = this.parameters.iterator();
        while (param == null && it.hasNext()) {
            Parameter pa = (Parameter)it.next();
            if (!pa.getName().equals(partName)) continue;
            param = pa;
        }
        return param;
    }

    public Iterator getFaults() {
        return this.faults.iterator();
    }

    public void writeWSDD(PrintWriter out) {
        String name = this.getJavaName();
        QName qname = this.getQName();
        QName returnQName = this.getReturnQName();
        QName returnType = this.getReturnType();
        this.log.trace((Object)("Operation: " + this));
        String xmlns = "";
        String opPrefix = qname.getPrefix();
        if (opPrefix.length() > 0) {
            xmlns = "xmlns:" + opPrefix + "='" + qname.getNamespaceURI() + "' ";
        }
        String qnameAttr = WSDDGenerator.getQNameAttrValue(qname);
        if (returnType != null) {
            String returnAttr = WSDDGenerator.getQNameAttrValue(returnQName);
            String typeAttr = WSDDGenerator.getQNameAttrValue(returnType);
            String typePrefix = returnType.getPrefix();
            if (typePrefix.startsWith("ns") && !xmlns.startsWith("xmlns:" + typePrefix)) {
                xmlns = xmlns + "xmlns:" + typePrefix + "='" + returnType.getNamespaceURI() + "' ";
            }
            out.println("  <operation name='" + name + "' qname='" + qnameAttr + "' returnQName='" + returnAttr + "' returnType='" + typeAttr + "' " + xmlns + ">");
        } else {
            String onewayStr = this.oneWay ? "oneway='true' " : "";
            out.println("  <operation name='" + name + "' qname='" + qnameAttr + "' " + onewayStr + xmlns + ">");
        }
        Iterator itParam = this.getParameters();
        while (itParam.hasNext()) {
            Parameter param = (Parameter)itParam.next();
            String paramName = param.getName();
            QName paramQName = param.getQName();
            String mode = param.getMode();
            boolean inHeader = param.isInHeader();
            boolean outHeader = param.isOutHeader();
            this.log.trace((Object)("Parameter: " + param));
            QName typeQName = param.getType();
            String headers = "";
            if (inHeader) {
                headers = headers + "inHeader='true' ";
            }
            if (outHeader) {
                headers = headers + "outHeader='true' ";
            }
            xmlns = "";
            if (typeQName != null) {
                String typeAttr = WSDDGenerator.getQNameAttrValue(typeQName);
                String typePrefix = typeQName.getPrefix();
                if (typePrefix.startsWith("ns")) {
                    xmlns = xmlns + "xmlns:" + typePrefix + "='" + typeQName.getNamespaceURI() + "' ";
                }
                qnameAttr = WSDDGenerator.getQNameAttrValue(paramQName);
                out.println("    <parameter name='" + paramName + "' qname='" + qnameAttr + "' mode='" + mode + "' type='" + typeAttr + "' " + headers + xmlns + "/>");
                continue;
            }
            out.println("    <parameter name='" + paramName + "' mode='" + mode + "' " + headers + xmlns + "/>");
        }
        Iterator itFault = this.getFaults();
        while (itFault.hasNext()) {
            Fault fault = (Fault)itFault.next();
            String faultName = fault.getName();
            String javaType = fault.getJavaType();
            this.log.trace((Object)("Fault: " + fault));
            QName typeQName = fault.getTypeQName();
            QName faultQName = fault.getQName();
            String typeAttr = WSDDGenerator.getQNameAttrValue(typeQName);
            xmlns = "";
            String typePrefix = typeQName.getPrefix();
            if (typePrefix.startsWith("ns")) {
                xmlns = xmlns + "xmlns:" + typePrefix + "='" + typeQName.getNamespaceURI() + "' ";
            }
            qnameAttr = WSDDGenerator.getQNameAttrValue(faultQName);
            out.println("    <fault name='" + faultName + "' qname='" + qnameAttr + "' type='" + typeAttr + "' class='" + javaType + "' " + xmlns + "/>");
        }
        out.println("  </operation>");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "[name=" + this.name + ",qname=" + this.qname + ",returnQName=" + this.returnQName + ",returnType=" + this.returnType + "]";
    }

    public static class Fault {
        private String name;
        private QName qname;
        private QName typeQName;
        private String javaType;

        public Fault(String name, QName qname, String javaType, QName type) {
            if (name == null) {
                throw new IllegalArgumentException("Fault name cannot be null");
            }
            if (javaType == null) {
                throw new IllegalArgumentException("Fault javaType cannot be null");
            }
            if (type == null) {
                throw new IllegalArgumentException("Fault type cannot be null");
            }
            if (qname == null) {
                qname = new QName(name);
            }
            this.name = name;
            this.qname = qname;
            this.javaType = javaType;
            this.typeQName = type;
        }

        public String getName() {
            return this.name;
        }

        public QName getQName() {
            return this.qname;
        }

        public QName getTypeQName() {
            return this.typeQName;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return "[name=" + this.name + "qname=" + this.qname + ",type=" + this.typeQName + ",java=" + this.javaType + "]";
        }
    }

    public static class Parameter {
        private String name;
        private QName qname;
        private String mode;
        private QName type;
        private boolean inHeader;
        private boolean outHeader;

        public Parameter(String name, QName qname, String mode, QName type) {
            if (name == null) {
                throw new IllegalArgumentException("Parameter name cannot be null");
            }
            if (mode == null) {
                throw new IllegalArgumentException("Parameter mode cannot be null");
            }
            if (type == null) {
                throw new IllegalArgumentException("Parameter type cannot be null");
            }
            if (qname == null) {
                qname = new QName(name);
            }
            this.name = name;
            this.qname = qname;
            this.mode = mode;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public QName getQName() {
            return this.qname;
        }

        public QName getType() {
            return this.type;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public boolean isInHeader() {
            return this.inHeader;
        }

        public void setInHeader(boolean inHeader) {
            this.inHeader = inHeader;
        }

        public boolean isOutHeader() {
            return this.outHeader;
        }

        public void setOutHeader(boolean outHeader) {
            this.outHeader = outHeader;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return "[name=" + this.name + "qname=" + this.qname + ",mode=" + this.mode + ",type=" + this.type + "]";
        }
    }
}

