/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.ejb.session;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.calendar.factory.AddProperty;
import com.clustercontrol.calendar.factory.CalendarProperty;
import com.clustercontrol.calendar.factory.ModifyCalendar;
import com.clustercontrol.calendar.factory.SelectCalendar;
import com.clustercontrol.calendar.factory.WeekdayProperty;
import com.clustercontrol.util.Messages;
import java.rmi.RemoteException;
import java.security.Principal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CalendarControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(CalendarControllerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public ArrayList getCalendarListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"calendar.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"calendar.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"valid.time", (Locale)locale) + "(" + Messages.getString((String)"start", (Locale)locale) + ")", -1, 150, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"valid.time", (Locale)locale) + "(" + Messages.getString((String)"end", (Locale)locale) + ")", -1, 150, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 150, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(8, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(9, new TableColumnInfo("", 15, 0, 16384));
        return tableDefine;
    }

    public ArrayList getWeekdayListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"weekday", (Locale)locale), 16, 80, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"timestamp", (Locale)locale) + "(" + Messages.getString((String)"start", (Locale)locale) + ")", -1, 100, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"timestamp", (Locale)locale) + "(" + Messages.getString((String)"end", (Locale)locale) + ")", -1, 100, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 150, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 150, 16384));
        return tableDefine;
    }

    public ArrayList getAddListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"run", (Locale)locale), 15, 50, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"time", (Locale)locale) + "(" + Messages.getString((String)"start", (Locale)locale) + ")", -1, 150, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"time", (Locale)locale) + "(" + Messages.getString((String)"end", (Locale)locale) + ")", -1, 150, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 150, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 150, 16384));
        return tableDefine;
    }

    public ArrayList getScheduleTableDefine(Date base, Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"calendar.id", (Locale)locale), -1, 0, 16384));
        for (int i = 0; i < 28; ++i) {
            Calendar baseCalendar = Calendar.getInstance();
            baseCalendar.setTime(base);
            baseCalendar.add(5, i);
            Date work = baseCalendar.getTime();
            tableDefine.add(i + 1, new TableColumnInfo(DateFormat.getDateInstance(3, locale).format(work), 17, 70, 16384));
        }
        return tableDefine;
    }

    public ArrayList getCalendarList() throws FinderException, NamingException {
        ArrayList list = null;
        try {
            SelectCalendar select = new SelectCalendar();
            list = select.getCalendarList();
        }
        catch (FinderException e) {
            m_log.debug((Object)("getCalendarList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getWeekdayList(String id) throws FinderException, NamingException {
        ArrayList list = null;
        try {
            SelectCalendar select = new SelectCalendar();
            list = select.getWeekdayList(id);
        }
        catch (FinderException e) {
            m_log.debug((Object)("getWeekdayList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getAddList(String id) throws FinderException, NamingException {
        ArrayList list = null;
        try {
            SelectCalendar select = new SelectCalendar();
            list = select.getAddList(id);
        }
        catch (FinderException e) {
            m_log.debug((Object)("getAddList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getSchedule(Date base) throws FinderException, NamingException {
        SelectCalendar select = new SelectCalendar();
        ArrayList list = select.getSchedule(base);
        return list;
    }

    public Property getCalendarProperty(String id, int mode, Locale locale) throws FinderException, NamingException {
        try {
            return new CalendarProperty().getProperty(id, mode, locale);
        }
        catch (FinderException e) {
            m_log.debug((Object)("getCalendarProperty() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public void addCalendar(Property property) throws NamingException, CreateException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyCalendar modify = new ModifyCalendar();
        modify.addCalendar(property, pri.getName());
    }

    public void modifyCalendar(Property property) throws NamingException, FinderException {
        try {
            Principal pri = this.m_context.getCallerPrincipal();
            ModifyCalendar modify = new ModifyCalendar();
            modify.modifyCalendar(property, pri.getName());
        }
        catch (NamingException e) {
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("modifyCalendar() -> " + e.getMessage()));
            throw e;
        }
    }

    public void deleteCalendar(String id) throws NamingException, RemoveException, FinderException {
        try {
            ModifyCalendar modify = new ModifyCalendar();
            modify.deleteCalendar(id);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (RemoveException e) {
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("deleteCalendar() -> " + e.getMessage()));
            throw e;
        }
    }

    public Property getWeekdayProperty(String id, Integer weekday, Date from, Date to, int mode, Locale locale) throws FinderException, NamingException {
        try {
            return new WeekdayProperty().getProperty(id, weekday, from, to, mode, locale);
        }
        catch (FinderException e) {
            m_log.debug((Object)("getWeekdayProperty() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public void addWeekday(String id, Property property) throws NamingException, CreateException, FinderException {
        try {
            Principal pri = this.m_context.getCallerPrincipal();
            ModifyCalendar modify = new ModifyCalendar();
            modify.addWeekday(id, property, pri.getName());
        }
        catch (NamingException e) {
            throw e;
        }
        catch (CreateException e) {
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("addWeekday() -> " + e.getMessage()));
            throw e;
        }
    }

    public void modifyWeekday(String id, Integer weekday, Date from, Date to, Property property) throws NamingException, FinderException, RemoveException, CreateException {
        try {
            Principal pri = this.m_context.getCallerPrincipal();
            ModifyCalendar modify = new ModifyCalendar();
            modify.modifyWeekday(id, weekday, from, to, property, pri.getName());
        }
        catch (NamingException e) {
            throw e;
        }
        catch (RemoveException e) {
            throw e;
        }
        catch (CreateException e) {
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("modifyWeekday() -> " + e.getMessage()));
            throw e;
        }
    }

    public void deleteWeekday(String id, Integer weekday, Date from, Date to) throws NamingException, RemoveException, FinderException {
        try {
            ModifyCalendar modify = new ModifyCalendar();
            modify.deleteWeekday(id, weekday, from, to);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (RemoveException e) {
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("deleteWeekday() -> " + e.getMessage()));
            throw e;
        }
    }

    public Property getAddInfoProperty(String id, Date from, Date to, int mode, Locale locale) throws FinderException, NamingException {
        try {
            return new AddProperty().getProperty(id, from, to, mode, locale);
        }
        catch (FinderException e) {
            m_log.debug((Object)("getAddInfoProperty() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public void addAddInfo(String id, Property property) throws NamingException, CreateException, FinderException {
        try {
            Principal pri = this.m_context.getCallerPrincipal();
            ModifyCalendar modify = new ModifyCalendar();
            modify.addAddInfo(id, property, pri.getName());
        }
        catch (NamingException e) {
            throw e;
        }
        catch (CreateException e) {
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("addAddInfo() -> " + e.getMessage()));
            throw e;
        }
    }

    public void modifyAddInfo(String id, Date from, Date to, Property property) throws NamingException, FinderException, RemoveException, CreateException {
        try {
            Principal pri = this.m_context.getCallerPrincipal();
            ModifyCalendar modify = new ModifyCalendar();
            modify.modifyAddInfo(id, from, to, property, pri.getName());
        }
        catch (NamingException e) {
            throw e;
        }
        catch (RemoveException e) {
            throw e;
        }
        catch (CreateException e) {
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("modifyAddInfo() -> " + e.getMessage()));
            throw e;
        }
    }

    public void deleteAddInfo(String id, Date from, Date to) throws NamingException, RemoveException, FinderException {
        try {
            ModifyCalendar modify = new ModifyCalendar();
            modify.deleteAddInfo(id, from, to);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (RemoveException e) {
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("deleteAddInfo() -> " + e.getMessage()));
            throw e;
        }
    }

    public Boolean isRun(String id, Date checkTimestamp) throws FinderException, NamingException {
        try {
            SelectCalendar select = new SelectCalendar();
            return select.isRun(id, checkTimestamp);
        }
        catch (FinderException e) {
            m_log.debug((Object)("isRun() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public ArrayList getCalendarIdList() throws FinderException, NamingException {
        try {
            SelectCalendar select = new SelectCalendar();
            return select.getCalendarIdList();
        }
        catch (FinderException e) {
            m_log.debug((Object)("getCalendarIdList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }
}

