/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server.jmx;

import org.jboss.mq.server.JMSServerInterceptor;
import org.jboss.mq.server.jmx.ClientMonitorInterceptorMBean;
import org.jboss.mq.server.jmx.InterceptorMBeanSupport;

public class ClientMonitorInterceptor
extends InterceptorMBeanSupport
implements ClientMonitorInterceptorMBean {
    private org.jboss.mq.server.ClientMonitorInterceptor interceptor = new org.jboss.mq.server.ClientMonitorInterceptor();
    long clientTimeout = 60000L;
    Thread serviceThread;

    public JMSServerInterceptor getInterceptor() {
        return this.interceptor;
    }

    public long getClientTimeout() {
        return this.clientTimeout;
    }

    public void setClientTimeout(long clientTimeout) {
        this.clientTimeout = clientTimeout;
    }

    protected void startService() throws Exception {
        super.startService();
        if (this.serviceThread != null) {
            return;
        }
        this.serviceThread = new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        Thread.sleep(ClientMonitorInterceptor.this.clientTimeout);
                        ClientMonitorInterceptor.this.interceptor.disconnectInactiveClients(System.currentTimeMillis() - ClientMonitorInterceptor.this.clientTimeout);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }, "ClientMonitor Service Thread");
        this.serviceThread.setDaemon(true);
        this.serviceThread.start();
    }

    protected void stopService() throws Exception {
        if (this.serviceThread != null) {
            this.serviceThread.interrupt();
            this.serviceThread = null;
        }
        super.stopService();
    }
}

