/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.server.JMSServerInterceptorSupport;

public class TracingInterceptor
extends JMSServerInterceptorSupport {
    protected static Logger log = Logger.getLogger((Class)TracingInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadGroup getThreadGroup() {
        if (!log.isTraceEnabled()) {
            return this.getNext().getThreadGroup();
        }
        try {
            log.trace((Object)"CALLED : getThreadGroup");
            ThreadGroup threadGroup = this.getNext().getThreadGroup();
            return threadGroup;
        }
        finally {
            log.trace((Object)"RETURN : getThreadGroup");
        }
    }

    public String getID() throws JMSException {
        if (!log.isTraceEnabled()) {
            return this.getNext().getID();
        }
        try {
            log.trace((Object)"CALLED : getID");
            String string = this.getNext().getID();
            return string;
        }
        catch (JMSException e) {
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : getID: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : getID");
        }
    }

    public TemporaryTopic getTemporaryTopic(ConnectionToken dc) throws JMSException {
        if (!log.isTraceEnabled()) {
            return this.getNext().getTemporaryTopic(dc);
        }
        try {
            log.trace((Object)"CALLED : getTemporaryTopic");
            TemporaryTopic temporaryTopic = this.getNext().getTemporaryTopic(dc);
            return temporaryTopic;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : getTemporaryTopic: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : getTemporaryTopic: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : getTemporaryTopic");
        }
    }

    public TemporaryQueue getTemporaryQueue(ConnectionToken dc) throws JMSException {
        if (!log.isTraceEnabled()) {
            return this.getNext().getTemporaryQueue(dc);
        }
        try {
            log.trace((Object)"CALLED : getTemporaryQueue");
            TemporaryQueue temporaryQueue = this.getNext().getTemporaryQueue(dc);
            return temporaryQueue;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : getTemporaryQueue: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : getTemporaryQueue: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : getTemporaryQueue");
        }
    }

    public void connectionClosing(ConnectionToken dc) throws JMSException {
        if (!log.isTraceEnabled()) {
            this.getNext().connectionClosing(dc);
            return;
        }
        try {
            log.trace((Object)"CALLED : connectionClosing");
            this.getNext().connectionClosing(dc);
            return;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : connectionClosing: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : receive: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : connectionClosing");
        }
    }

    public void checkID(String ID) throws JMSException {
        if (!log.isTraceEnabled()) {
            this.getNext().checkID(ID);
            return;
        }
        try {
            log.trace((Object)"CALLED : checkID");
            log.trace((Object)("ARG    : " + ID));
            this.getNext().checkID(ID);
            return;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : checkID: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : checkID: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : checkID");
        }
    }

    public void addMessage(ConnectionToken dc, SpyMessage message) throws JMSException {
        if (!log.isTraceEnabled()) {
            this.getNext().addMessage(dc, message);
            return;
        }
        try {
            log.trace((Object)"CALLED : addMessage");
            log.trace((Object)("ARG    : " + message));
            this.getNext().addMessage(dc, message);
            return;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : addMessage: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : addMessage: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : addMessage");
        }
    }

    public Queue createQueue(ConnectionToken dc, String dest) throws JMSException {
        if (!log.isTraceEnabled()) {
            return this.getNext().createQueue(dc, dest);
        }
        try {
            log.trace((Object)"CALLED : createQueue");
            log.trace((Object)("ARG    : " + dest));
            Queue queue = this.getNext().createQueue(dc, dest);
            return queue;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : createQueue: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : createQueue: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : createQueue");
        }
    }

    public Topic createTopic(ConnectionToken dc, String dest) throws JMSException {
        if (!log.isTraceEnabled()) {
            return this.getNext().createTopic(dc, dest);
        }
        try {
            log.trace((Object)"CALLED : createTopic");
            log.trace((Object)("ARG    : " + dest));
            Topic topic = this.getNext().createTopic(dc, dest);
            return topic;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : createTopic: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : createTopic: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : createTopic");
        }
    }

    public void deleteTemporaryDestination(ConnectionToken dc, SpyDestination dest) throws JMSException {
        if (!log.isTraceEnabled()) {
            this.getNext().deleteTemporaryDestination(dc, dest);
            return;
        }
        try {
            log.trace((Object)"CALLED : deleteTemporaryDestination");
            log.trace((Object)("ARG    : " + dest));
            this.getNext().deleteTemporaryDestination(dc, dest);
            return;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : deleteTemporaryDestination: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : deleteTemporaryDestination: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : deleteTemporaryDestination");
        }
    }

    public void transact(ConnectionToken dc, TransactionRequest t) throws JMSException {
        if (!log.isTraceEnabled()) {
            this.getNext().transact(dc, t);
            return;
        }
        try {
            log.trace((Object)"CALLED : transact");
            log.trace((Object)("ARG    : " + t));
            this.getNext().transact(dc, t);
            return;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : transact: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : transact: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : transact");
        }
    }

    public void acknowledge(ConnectionToken dc, AcknowledgementRequest item) throws JMSException {
        if (!log.isTraceEnabled()) {
            this.getNext().acknowledge(dc, item);
            return;
        }
        try {
            log.trace((Object)"CALLED : acknowledge");
            log.trace((Object)("ARG    : " + item));
            this.getNext().acknowledge(dc, item);
            return;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : acknowledge: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : acknowledge: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : acknowledge");
        }
    }

    public SpyMessage[] browse(ConnectionToken dc, Destination dest, String selector) throws JMSException {
        if (!log.isTraceEnabled()) {
            return this.getNext().browse(dc, dest, selector);
        }
        try {
            log.trace((Object)"CALLED : browse");
            log.trace((Object)("ARG    : " + dest));
            log.trace((Object)("ARG    : " + selector));
            SpyMessage[] spyMessageArray = this.getNext().browse(dc, dest, selector);
            return spyMessageArray;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : browse: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : browse: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : browse");
        }
    }

    public SpyMessage receive(ConnectionToken dc, int subscriberId, long wait) throws JMSException {
        if (!log.isTraceEnabled()) {
            return this.getNext().receive(dc, subscriberId, wait);
        }
        try {
            log.trace((Object)"CALLED : receive");
            log.trace((Object)("ARG    : " + subscriberId));
            log.trace((Object)("ARG    : " + wait));
            SpyMessage spyMessage = this.getNext().receive(dc, subscriberId, wait);
            return spyMessage;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : receive: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : receive: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : receive");
        }
    }

    public void setEnabled(ConnectionToken dc, boolean enabled) throws JMSException {
        if (!log.isTraceEnabled()) {
            this.getNext().setEnabled(dc, enabled);
            return;
        }
        try {
            log.trace((Object)"CALLED : setEnabled");
            log.trace((Object)("ARG    : " + enabled));
            this.getNext().setEnabled(dc, enabled);
            return;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : setEnabled: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : setEnabled: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : setEnabled");
        }
    }

    public void unsubscribe(ConnectionToken dc, int subscriptionId) throws JMSException {
        if (!log.isTraceEnabled()) {
            this.getNext().unsubscribe(dc, subscriptionId);
            return;
        }
        try {
            log.trace((Object)"CALLED : unsubscribe");
            log.trace((Object)("ARG    : " + subscriptionId));
            this.getNext().unsubscribe(dc, subscriptionId);
            return;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : unsubscribe: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : unsubscribe: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : unsubscribe");
        }
    }

    public void destroySubscription(ConnectionToken dc, DurableSubscriptionID id) throws JMSException {
        if (!log.isTraceEnabled()) {
            this.getNext().destroySubscription(dc, id);
            return;
        }
        try {
            log.trace((Object)"CALLED : destroySubscription");
            log.trace((Object)("ARG    : " + id));
            this.getNext().destroySubscription(dc, id);
            return;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : destroySubscription: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : destroySubscription: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : destroySubscription");
        }
    }

    public String checkUser(String userName, String password) throws JMSException {
        if (!log.isTraceEnabled()) {
            return this.getNext().checkUser(userName, password);
        }
        try {
            log.trace((Object)"CALLED : checkUser");
            log.trace((Object)("ARG    : " + userName));
            log.trace((Object)"ARG    : (password not shown)");
            String string = this.getNext().checkUser(userName, password);
            return string;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : checkUser: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : checkUser: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : checkUser");
        }
    }

    public String authenticate(String userName, String password) throws JMSException {
        if (!log.isTraceEnabled()) {
            return this.getNext().authenticate(userName, password);
        }
        try {
            log.trace((Object)"CALLED : authenticate");
            String string = this.getNext().authenticate(userName, password);
            return string;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : authenticate: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : authenticate: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : authenticate");
        }
    }

    public void subscribe(ConnectionToken dc, Subscription s) throws JMSException {
        if (!log.isTraceEnabled()) {
            this.getNext().subscribe(dc, s);
            return;
        }
        try {
            log.trace((Object)"CALLED : subscribe");
            log.trace((Object)("ARG    : " + s));
            this.getNext().subscribe(dc, s);
            return;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : subscribe: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : subscribe: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : subscribe");
        }
    }

    public void ping(ConnectionToken dc, long clientTime) throws JMSException {
        if (!log.isTraceEnabled()) {
            this.getNext().ping(dc, clientTime);
            return;
        }
        try {
            log.trace((Object)"CALLED : ping");
            log.trace((Object)("ARG    : " + clientTime));
            this.getNext().ping(dc, clientTime);
            return;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : ping: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : ping: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : ping");
        }
    }

    public SpyTopic getDurableTopic(DurableSubscriptionID sub) throws JMSException {
        if (!log.isTraceEnabled()) {
            return this.getNext().getDurableTopic(sub);
        }
        try {
            log.trace((Object)"CALLED : getDurableTopic");
            log.trace((Object)("ARG    : " + sub));
            SpyTopic spyTopic = this.getNext().getDurableTopic(sub);
            return spyTopic;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : getDurableTopic: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : getDurableTopic: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : getDurableTopic");
        }
    }

    public Subscription getSubscription(ConnectionToken dc, int subscriberId) throws JMSException {
        if (!log.isTraceEnabled()) {
            return this.getNext().getSubscription(dc, subscriberId);
        }
        try {
            log.trace((Object)"CALLED : getSubscription");
            log.trace((Object)("ARG    : " + subscriberId));
            Subscription subscription = this.getNext().getSubscription(dc, subscriberId);
            return subscription;
        }
        catch (JMSException e) {
            log.trace((Object)"EXCEPTION : getSubscription: ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Object)"EXCEPTION : getSubscription: ", (Throwable)e);
            throw e;
        }
        finally {
            log.trace((Object)"RETURN : getSubscription");
        }
    }
}

