/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.jobmanagement.dao.JobSessionNodeDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.util.ParameterUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobSessionNodeDAOImpl
implements JobSessionNodeDAO {
    protected static Log m_log = LogFactory.getLog(JobSessionNodeDAOImpl.class);

    public void init() {
    }

    public void load(JobSessionNodePK pk, JobSessionNodeBean ejb) throws EJBException {
        block21: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_session_node WHERE session_id = ? AND job_id = ? AND facility_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                stmt.setString(2, pk.getJob_id());
                stmt.setString(3, pk.getFacility_id());
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setAgent_check(res.getInt("agent_check"));
                    if (res.getTimestamp("check_date") != null) {
                        ejb.setCheck_date(new Date(res.getTimestamp("check_date").getTime()));
                    } else {
                        ejb.setCheck_date(null);
                    }
                    if (res.getTimestamp("end_date") != null) {
                        ejb.setEnd_date(new Date(res.getTimestamp("end_date").getTime()));
                    } else {
                        ejb.setEnd_date(null);
                    }
                    if (res.getString("end_value") != null) {
                        ejb.setEnd_value(res.getInt("end_value"));
                    } else {
                        ejb.setEnd_value(null);
                    }
                    ejb.setFacility_id(res.getString("facility_id"));
                    ejb.setJob_id(res.getString("job_id"));
                    ejb.setMessage(res.getString("message"));
                    ejb.setNode_name(res.getString("node_name"));
                    ejb.setResult(res.getString("result"));
                    ejb.setRetry_count(res.getInt("retry_count"));
                    ejb.setSession_id(res.getString("session_id"));
                    if (res.getTimestamp("start_date") != null) {
                        ejb.setStart_date(new Date(res.getTimestamp("start_date").getTime()));
                    } else {
                        ejb.setStart_date(null);
                    }
                    ejb.setStatus(res.getInt("status"));
                    ejb.setStatus_buffer(res.getInt("status_buffer"));
                    break block21;
                }
                String msg = "JobSessionNode data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    public void store(JobSessionNodeBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE cc_job_session_node SET ");
            sql.append("node_name = ?, ");
            sql.append("status = ?, ");
            sql.append("start_date = ?, ");
            sql.append("end_date = ?, ");
            sql.append("end_value = ?, ");
            sql.append("message = ?, ");
            sql.append("agent_check = ?, ");
            sql.append("check_date = ?, ");
            sql.append("retry_count = ?, ");
            sql.append("result = ?, ");
            sql.append("status_buffer = ? ");
            sql.append("WHERE session_id = ? ");
            sql.append("AND job_id = ? ");
            sql.append("AND facility_id = ?");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getNode_name());
            stmt.setInt(2, ejb.getStatus());
            if (ejb.getStart_date() instanceof Date) {
                stmt.setTimestamp(3, new Timestamp(ejb.getStart_date().getTime()));
            } else {
                stmt.setTimestamp(3, null);
            }
            if (ejb.getEnd_date() instanceof Date) {
                stmt.setTimestamp(4, new Timestamp(ejb.getEnd_date().getTime()));
            } else {
                stmt.setTimestamp(4, null);
            }
            if (ejb.getEnd_value() instanceof Integer) {
                stmt.setInt(5, ejb.getEnd_value());
            } else {
                stmt.setNull(5, 4);
            }
            stmt.setString(6, ejb.getMessage());
            if (ejb.getAgent_check() instanceof Integer) {
                stmt.setInt(7, ejb.getAgent_check());
            } else {
                stmt.setNull(7, 4);
            }
            if (ejb.getCheck_date() instanceof Date) {
                stmt.setTimestamp(8, new Timestamp(ejb.getCheck_date().getTime()));
            } else {
                stmt.setTimestamp(8, null);
            }
            if (ejb.getRetry_count() instanceof Integer) {
                stmt.setInt(9, ejb.getRetry_count());
            } else {
                stmt.setNull(9, 4);
            }
            stmt.setString(10, ejb.getResult());
            if (ejb.getStatus_buffer() instanceof Integer) {
                stmt.setInt(11, ejb.getStatus_buffer());
            } else {
                stmt.setNull(11, 4);
            }
            stmt.setString(12, ejb.getSession_id());
            stmt.setString(13, ejb.getJob_id());
            stmt.setString(14, ejb.getFacility_id());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("store() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id()));
    }

    public void remove(JobSessionNodePK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_job_session_node WHERE session_id = ? AND job_id = ? AND facility_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            stmt.setString(3, pk.getFacility_id());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    public JobSessionNodePK create(JobSessionNodeBean ejb) throws CreateException, EJBException {
        JobSessionNodePK pk;
        m_log.debug((Object)("create() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO cc_job_session_node (");
            sql.append("session_id, ");
            sql.append("job_id, ");
            sql.append("facility_id, ");
            sql.append("node_name, ");
            sql.append("status, ");
            sql.append("start_date, ");
            sql.append("end_date, ");
            sql.append("end_value, ");
            sql.append("message, ");
            sql.append("agent_check, ");
            sql.append("check_date, ");
            sql.append("retry_count, ");
            sql.append("result, ");
            sql.append("status_buffer) ");
            sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getSession_id());
            stmt.setString(2, ejb.getJob_id());
            stmt.setString(3, ejb.getFacility_id());
            stmt.setString(4, ejb.getNode_name());
            stmt.setInt(5, ejb.getStatus());
            if (ejb.getStart_date() instanceof Date) {
                stmt.setTimestamp(6, new Timestamp(ejb.getStart_date().getTime()));
            } else {
                stmt.setTimestamp(6, null);
            }
            if (ejb.getEnd_date() instanceof Date) {
                stmt.setTimestamp(7, new Timestamp(ejb.getEnd_date().getTime()));
            } else {
                stmt.setTimestamp(7, null);
            }
            if (ejb.getEnd_value() instanceof Integer) {
                stmt.setInt(8, ejb.getEnd_value());
            } else {
                stmt.setNull(8, 4);
            }
            stmt.setString(9, ejb.getMessage());
            if (ejb.getAgent_check() instanceof Integer) {
                stmt.setInt(10, ejb.getAgent_check());
            } else {
                stmt.setNull(10, 4);
            }
            if (ejb.getCheck_date() instanceof Date) {
                stmt.setTimestamp(11, new Timestamp(ejb.getCheck_date().getTime()));
            } else {
                stmt.setTimestamp(11, null);
            }
            if (ejb.getRetry_count() instanceof Integer) {
                stmt.setInt(12, ejb.getRetry_count());
            } else {
                stmt.setNull(12, 4);
            }
            stmt.setString(13, ejb.getResult());
            if (ejb.getStatus_buffer() instanceof Integer) {
                stmt.setInt(14, ejb.getStatus_buffer());
            } else {
                stmt.setNull(14, 4);
            }
            int row = stmt.executeUpdate();
            pk = new JobSessionNodePK(ejb.getSession_id(), ejb.getJob_id(), ejb.getFacility_id());
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id() + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobSessionNodePK> ret = new ArrayList<JobSessionNodePK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_session_node";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                JobSessionNodePK pk = new JobSessionNodePK(res.getString("session_id"), res.getString("job_id"), res.getString("facility_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobSessionNodePK findByPrimaryKey(JobSessionNodePK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_session_node WHERE session_id = ? AND job_id = ? AND facility_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            stmt.setString(3, pk.getFacility_id());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobSessionNodePK jobSessionNodePK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobSessionNodePK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    public Collection findBySessionIdAndJobId(String sessionId, String jobId) throws FinderException {
        m_log.debug((Object)("findBySessionIdAndJobId() start : " + sessionId + ", " + jobId));
        ArrayList<JobSessionNodePK> ret = new ArrayList<JobSessionNodePK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_session_node WHERE session_id = ? AND job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, sessionId);
            stmt.setString(2, jobId);
            res = stmt.executeQuery();
            while (res.next()) {
                JobSessionNodePK pk = new JobSessionNodePK(res.getString("session_id"), res.getString("job_id"), res.getString("facility_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("findBySessionIdAndJobId() error : " + sessionId + ", " + jobId + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findBySessionIdAndJobId() error : " + sessionId + ", " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("findBySessionIdAndJobId() end : " + sessionId + ", " + jobId));
        return ret;
    }

    public Collection findByFacilityId(String facilityId) throws FinderException {
        m_log.debug((Object)("findByFacilityId() start : " + facilityId));
        ArrayList<JobSessionNodePK> ret = new ArrayList<JobSessionNodePK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_session_node WHERE facility_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, facilityId);
            res = stmt.executeQuery();
            while (res.next()) {
                JobSessionNodePK pk = new JobSessionNodePK(res.getString("session_id"), res.getString("job_id"), res.getString("facility_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("findByFacilityId() error : " + facilityId + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByFacilityId() error : " + facilityId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("findByFacilityId() end : " + facilityId));
        return ret;
    }

    public Collection findByStatus(Integer status) throws FinderException {
        m_log.debug((Object)("findByStatus() start : " + status));
        ArrayList<JobSessionNodePK> ret = new ArrayList<JobSessionNodePK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT * FROM cc_job_session_node ");
            sql.append("WHERE status = ?");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setInt(1, status);
            res = stmt.executeQuery();
            while (res.next()) {
                JobSessionNodePK pk = new JobSessionNodePK(res.getString("session_id"), res.getString("job_id"), res.getString("facility_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("findByStatus() error : " + status + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByStatus() error : " + status + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("findByStatus() end : " + status));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void makeSession(String sessionId, Collection jobs) throws CreateException {
        block40: {
            m_log.debug((Object)("makeSession() start : " + sessionId));
            Connection conn = null;
            Connection connMaster = null;
            Statement stmt = null;
            Statement stmtMasster = null;
            String jobId = null;
            try {
                try {
                    conn = ConnectionManager.getConnectionManager().getConnection();
                    connMaster = ConnectionManager.getConnectionManager().getConnection();
                    RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
                    StringBuilder sql = new StringBuilder();
                    sql.append("INSERT INTO cc_job_session_node (");
                    sql.append("session_id, ");
                    sql.append("job_id, ");
                    sql.append("facility_id, ");
                    sql.append("node_name, ");
                    sql.append("status, ");
                    sql.append("start_date, ");
                    sql.append("end_date, ");
                    sql.append("end_value, ");
                    sql.append("message, ");
                    sql.append("agent_check, ");
                    sql.append("check_date, ");
                    sql.append("retry_count, ");
                    sql.append("result, ");
                    sql.append("status_buffer) ");
                    sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    stmt = conn.prepareStatement(sql.toString());
                    stmt.setString(1, sessionId);
                    stmt.setInt(5, 0);
                    stmt.setTimestamp(6, null);
                    stmt.setTimestamp(7, null);
                    stmt.setNull(8, 4);
                    stmt.setString(9, null);
                    stmt.setNull(10, 4);
                    stmt.setTimestamp(11, null);
                    stmt.setInt(12, 0);
                    stmt.setString(13, null);
                    stmt.setNull(14, 4);
                    StringBuilder sqlMaster = new StringBuilder();
                    sqlMaster.append("SELECT ");
                    sqlMaster.append("cc_job_mst.job_type, ");
                    sqlMaster.append("cc_job_command_mst.facility_id ");
                    sqlMaster.append("FROM cc_job_mst left join cc_job_command_mst ");
                    sqlMaster.append("on  (cc_job_mst.job_id=cc_job_command_mst.job_id) ");
                    sqlMaster.append("WHERE  cc_job_mst.job_id= ? ");
                    stmtMasster = connMaster.prepareStatement(sqlMaster.toString());
                    for (Hashtable ht : jobs) {
                        jobId = (String)ht.get("jobId");
                        stmtMasster.setString(1, jobId);
                        ResultSet resMaster = stmtMasster.executeQuery();
                        if (resMaster.next() && resMaster.getInt("job_type") == 2) {
                            String facilityId = resMaster.getString("facility_id");
                            if (facilityId.equals("${FACILITY_ID}")) {
                                facilityId = ParameterUtil.getSessionParameterValue(sessionId, "FACILITY_ID");
                            }
                            StringBuilder updateSql = new StringBuilder();
                            updateSql.append("UPDATE cc_job_session_job ");
                            updateSql.append("SET scope_text = ? ");
                            updateSql.append("WHERE session_id = ? ");
                            updateSql.append("AND job_id = ?");
                            PreparedStatement updateStmt = conn.prepareStatement(updateSql.toString());
                            updateStmt.setString(1, repository.getFacilityPath(facilityId, null));
                            updateStmt.setString(2, sessionId);
                            updateStmt.setString(3, jobId);
                            updateStmt.executeUpdate();
                            updateStmt.close();
                            ArrayList nodeIdList = null;
                            if (repository.isNode(facilityId)) {
                                nodeIdList = new ArrayList();
                                nodeIdList.add(facilityId);
                            } else {
                                nodeIdList = repository.getNodeFacilityIdList(facilityId, 0);
                            }
                            if (nodeIdList instanceof ArrayList) {
                                for (int i = 0; i < nodeIdList.size(); ++i) {
                                    ArrayList<String> Attribute2 = new ArrayList<String>();
                                    Attribute2.add("cn");
                                    HashMap map = repository.getNodeDetail((String)nodeIdList.get(i), Attribute2);
                                    stmt.setString(2, jobId);
                                    stmt.setString(3, (String)nodeIdList.get(i));
                                    stmt.setString(4, (String)map.get("cn"));
                                    int row = stmt.executeUpdate();
                                    if (row == 1) continue;
                                    String msg = "result row is not 1";
                                    m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                                    throw new EJBException(msg);
                                }
                            }
                        }
                        resMaster.close();
                    }
                    Object var24_27 = null;
                }
                catch (SQLException e) {
                    if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                    m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException" + "DuplicateKeyException "));
                    throw new DuplicateKeyException(e.getMessage());
                }
                catch (CreateException e) {
                    e.printStackTrace();
                    Object var24_28 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                        if (stmtMasster != null) {
                            stmtMasster.close();
                        }
                        if (connMaster != null) {
                            connMaster.close();
                        }
                    }
                    catch (SQLException e1) {
                        m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                        throw new EJBException(e1.getMessage());
                    }
                }
                catch (NamingException e) {
                    e.printStackTrace();
                    Object var24_29 = null;
                    try {}
                    catch (SQLException e1) {
                        m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                        throw new EJBException(e1.getMessage());
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                    if (stmtMasster != null) {
                        stmtMasster.close();
                    }
                    if (connMaster != null) {
                        connMaster.close();
                    }
                    break block40;
                }
                catch (FinderException e) {
                    e.printStackTrace();
                    Object var24_30 = null;
                    try {}
                    catch (SQLException e1) {
                        m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                        throw new EJBException(e1.getMessage());
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                    if (stmtMasster != null) {
                        stmtMasster.close();
                    }
                    if (connMaster != null) {
                        connMaster.close();
                    }
                    break block40;
                }
            }
            catch (Throwable throwable) {
                Object var24_31 = null;
                try {}
                catch (SQLException e1) {
                    m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                    throw new EJBException(e1.getMessage());
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
                if (stmtMasster != null) {
                    stmtMasster.close();
                }
                if (connMaster == null) throw throwable;
                connMaster.close();
                throw throwable;
            }
            try {}
            catch (SQLException e1) {
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
            if (stmtMasster != null) {
                stmtMasster.close();
            }
            if (connMaster != null) {
                connMaster.close();
            }
        }
        m_log.debug((Object)("makeSession() end : " + sessionId));
    }
}

