/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.dbc.condition;

import bsh.Capabilities;
import java.util.HashMap;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.dbc.DesignByContractAspect;
import org.jboss.aspects.dbc.condition.parser.BeanshellGenerator;
import org.jboss.aspects.dbc.condition.parser.Expression;
import org.jboss.aspects.dbc.condition.parser.ExpressionParser;

public abstract class Condition {
    public static final String TARGET = "tgt";
    public static final String RETURN = "rtn";
    protected HashMap parameterLookup = new HashMap();
    protected String originalExpr;
    protected String condExpr;
    protected Class clazz;
    protected boolean isStatic;

    public Condition(String condExpr, Class clazz, boolean isStatic) {
        this.isStatic = isStatic;
        if (DesignByContractAspect.verbose) {
            System.out.println("[dbc] Initialising condition: " + condExpr);
        }
        this.originalExpr = condExpr;
        condExpr = condExpr + " ";
        StringBuffer newcond = new StringBuffer();
        StringBuffer param = null;
        for (int i = 0; i < condExpr.length(); ++i) {
            char c = condExpr.charAt(i);
            if (c == '$') {
                param = new StringBuffer();
                continue;
            }
            if (param != null && (c == '.' || c == ' ' || c == '=' || c == '>' || c == '<' || c == ')' || c == '}' || c == ';' || c == '[' || c == ']')) {
                String prm = param.toString();
                if (prm.equals(TARGET) && isStatic) {
                    newcond.append(clazz.getName());
                } else {
                    String bsparam = "p" + i;
                    newcond.append(bsparam);
                    this.parameterLookup.put(bsparam, prm);
                }
                param = null;
            }
            if (param == null) {
                newcond.append(c);
                continue;
            }
            param.append(c);
        }
        Expression expr = ExpressionParser.parseExpression(newcond.toString());
        BeanshellGenerator gen = new BeanshellGenerator(expr);
        this.condExpr = gen.createBeanshellCode();
        if (DesignByContractAspect.verbose) {
            System.out.println("[dbc] Expanded to Java code:\n" + this.condExpr);
        }
        this.clazz = clazz;
    }

    public String toString() {
        return this.originalExpr;
    }

    public boolean equals(Object o) {
        if (o instanceof Condition) {
            Condition c = (Condition)o;
            return c.clazz.equals(this.clazz) && this.originalExpr.equals(c.originalExpr);
        }
        return false;
    }

    public int hashCode() {
        return this.originalExpr.hashCode();
    }

    protected Object getTarget(Invocation invocation, boolean isStatic) {
        if (!isStatic) {
            return invocation.getTargetObject();
        }
        return this.clazz;
    }

    static {
        Capabilities.setAccessibility((boolean)true);
    }
}

