/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.util;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performanceMGR.bean.ScopeRelationData;
import com.clustercontrol.performanceMGR.dao.ScopeRelationDAO;
import com.clustercontrol.performanceMGR.dao.ScopeSnapDAO;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import javax.ejb.CreateException;

public class FacilityTreeDB {
    public void insertFacilityTree(String collectorID, FacilityTreeItem fItem) {
        this.insertFacilityTree(collectorID, fItem, null);
    }

    private void insertFacilityTree(String collectorID, FacilityTreeItem fItem, HashSet writtenSet) {
        ScopeRelationDAO srdao = new ScopeRelationDAO();
        ScopeSnapDAO sndao = new ScopeSnapDAO();
        if (writtenSet == null) {
            writtenSet = new HashSet<String>();
        }
        FacilityInfo fInfo = fItem.getData();
        FacilityTreeItem[] fArray = fItem.getChildren();
        ScopeRelationData srData = new ScopeRelationData();
        srData.setCollectorID(collectorID);
        if (fItem.getParent() != null) {
            srData.setParentFacilityID(fItem.getParent().getData().getFacilityId());
        } else {
            srData.setParentFacilityID("");
        }
        srData.setFacilityID(fInfo.getFacilityId());
        try {
            if (!writtenSet.contains(fInfo.getFacilityId())) {
                sndao.insertScopeSnap(collectorID, fInfo);
                writtenSet.add(fInfo.getFacilityId());
            }
            srdao.insertScopeRelation(srData);
        }
        catch (CreateException e) {
            // empty catch block
        }
        for (int i = 0; i < fArray.length; ++i) {
            this.insertFacilityTree(collectorID, fArray[i], writtenSet);
        }
    }

    public FacilityTreeItem getFacilityTree(String collectorID) {
        ScopeRelationDAO srdao = new ScopeRelationDAO();
        ScopeSnapDAO sndao = new ScopeSnapDAO();
        Hashtable<String, FacilityTreeItem> ht = new Hashtable<String, FacilityTreeItem>();
        Hashtable sncol = null;
        Collection srcol = null;
        FacilityTreeItem currentItem = null;
        FacilityTreeItem parentItem = null;
        ScopeRelationData srData2 = null;
        String current = null;
        String parent = null;
        sncol = sndao.selectScopeSnapByCollectorID(collectorID);
        srcol = srdao.selectScopeRelationByCollectorID(collectorID);
        String topFacility = null;
        if (!sncol.isEmpty() && !srcol.isEmpty()) {
            for (ScopeRelationData srData2 : srcol) {
                current = srData2.getFacilityID();
                parent = srData2.getParentFacilityID();
                if (((FacilityInfo)sncol.get(current)).getType() != 2) {
                    if (ht.containsKey(parent)) {
                        parentItem = (FacilityTreeItem)ht.get(parent);
                    } else {
                        parentItem = new FacilityTreeItem((FacilityTreeItem)null, (FacilityInfo)sncol.get(parent));
                        ht.put(parent, parentItem);
                    }
                } else {
                    parentItem = null;
                    topFacility = ((FacilityInfo)sncol.get(current)).getFacilityId();
                }
                if (ht.containsKey(current)) {
                    currentItem = (FacilityTreeItem)ht.get(current);
                    if (currentItem.getData().getType() == 1 && currentItem.getParent() != null) {
                        FacilityInfo info = new FacilityInfo();
                        info.setFacilityId(currentItem.getData().getFacilityId());
                        info.setFacilityName(currentItem.getData().getFacilityName());
                        info.setType(currentItem.getData().getType());
                        currentItem = new FacilityTreeItem(parentItem, info);
                        continue;
                    }
                    currentItem.setParent(parentItem);
                    parentItem.addChildren(currentItem);
                    continue;
                }
                currentItem = new FacilityTreeItem(parentItem, (FacilityInfo)sncol.get(current));
                ht.put(current, currentItem);
            }
        }
        FacilityTreeItem top = (FacilityTreeItem)ht.get(topFacility);
        return top;
    }
}

