/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.jobs.FileScanJob;
import org.quartz.jobs.FileScanListener;
import org.quartz.spi.SchedulerPlugin;
import org.quartz.xml.JobSchedulingDataProcessor;

public class JobInitializationPlugin
implements SchedulerPlugin,
FileScanListener {
    private String name;
    private Scheduler scheduler;
    private boolean overWriteExistingJobs = false;
    private boolean failOnFileNotFound = true;
    private boolean fileFound = false;
    private String fileName = "quartz_jobs.xml";
    private String filePath = null;
    private boolean useContextClassLoader = true;
    private boolean validating = true;
    private boolean validatingSchema = true;
    private long scanInterval = 0L;
    boolean initializing = true;
    boolean started = false;
    static /* synthetic */ Class class$org$quartz$plugins$xml$JobInitializationPlugin;
    static /* synthetic */ Class class$org$quartz$jobs$FileScanJob;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isOverWriteExistingJobs() {
        return this.overWriteExistingJobs;
    }

    public void setOverWriteExistingJobs(boolean overWriteExistingJobs) {
        this.overWriteExistingJobs = overWriteExistingJobs;
    }

    public long getScanInterval() {
        return this.scanInterval / 1000L;
    }

    public void setScanInterval(long scanInterval) {
        this.scanInterval = scanInterval * 1000L;
    }

    public boolean isFailOnFileNotFound() {
        return this.failOnFileNotFound;
    }

    public void setFailOnFileNotFound(boolean failOnFileNotFound) {
        this.failOnFileNotFound = failOnFileNotFound;
    }

    public boolean isUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean useContextClassLoader) {
        this.useContextClassLoader = useContextClassLoader;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isValidatingSchema() {
        return this.validatingSchema;
    }

    public void setValidatingSchema(boolean validatingSchema) {
        this.validatingSchema = validatingSchema;
    }

    protected static Log getLog() {
        return LogFactory.getLog((Class)(class$org$quartz$plugins$xml$JobInitializationPlugin == null ? (class$org$quartz$plugins$xml$JobInitializationPlugin = JobInitializationPlugin.class$("org.quartz.plugins.xml.JobInitializationPlugin")) : class$org$quartz$plugins$xml$JobInitializationPlugin));
    }

    public void initialize(String name, Scheduler scheduler) throws SchedulerException {
        this.initializing = true;
        try {
            this.name = name;
            this.scheduler = scheduler;
            JobInitializationPlugin.getLog().info((Object)"Registering Quartz Job Initialization Plug-in.");
            this.findFile();
            Object var4_3 = null;
            this.initializing = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.initializing = false;
            throw throwable;
        }
    }

    private String getFilePath() throws SchedulerException {
        if (this.filePath == null) {
            this.findFile();
        }
        return this.filePath;
    }

    private void findFile() throws SchedulerException {
        URL url;
        FileInputStream f = null;
        File file = new File(this.getFileName());
        if (!(file != null && file.exists() || (url = Thread.currentThread().getContextClassLoader().getResource(this.getFileName())) == null)) {
            file = new File(url.getPath());
        }
        try {
            f = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        if (f == null && this.isFailOnFileNotFound()) {
            throw new SchedulerException("File named '" + this.getFileName() + "' does not exist.");
        }
        if (f == null) {
            JobInitializationPlugin.getLog().warn((Object)("File named '" + this.getFileName() + "' does not exist."));
        } else {
            this.fileFound = true;
            try {
                this.filePath = file.getPath();
                ((InputStream)f).close();
            }
            catch (IOException ioe) {
                JobInitializationPlugin.getLog().warn((Object)("Error closing file named '" + this.getFileName()), (Throwable)ioe);
            }
        }
    }

    public void start() {
        if (this.scanInterval > 0L) {
            try {
                SimpleTrigger trig = new SimpleTrigger("JobInitializationPlugin_" + this.name, "JobInitializationPlugin", new Date(), null, SimpleTrigger.REPEAT_INDEFINITELY, this.scanInterval);
                trig.setVolatility(true);
                JobDetail job = new JobDetail("JobInitializationPlugin_" + this.name, "JobInitializationPlugin", class$org$quartz$jobs$FileScanJob == null ? (class$org$quartz$jobs$FileScanJob = JobInitializationPlugin.class$("org.quartz.jobs.FileScanJob")) : class$org$quartz$jobs$FileScanJob);
                job.setVolatility(true);
                job.getJobDataMap().put(FileScanJob.FILE_NAME, this.getFilePath());
                job.getJobDataMap().put(FileScanJob.FILE_SCAN_LISTENER_NAME, "JobInitializationPlugin_" + this.name);
                this.scheduler.getContext().put((Object)("JobInitializationPlugin_" + this.name), this);
                this.scheduler.scheduleJob(job, trig);
            }
            catch (SchedulerException se) {
                JobInitializationPlugin.getLog().error((Object)"Error starting background-task for watching jobs file.", (Throwable)se);
            }
        }
        try {
            this.processFile();
            Object var4_4 = null;
            this.started = true;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.started = true;
            throw throwable;
        }
    }

    public void shutdown() {
    }

    public void processFile() {
        if (!this.fileFound) {
            return;
        }
        JobSchedulingDataProcessor processor = new JobSchedulingDataProcessor(this.isUseContextClassLoader(), this.isValidating(), this.isValidatingSchema());
        try {
            processor.processFileAndScheduleJobs(this.fileName, this.scheduler, true);
        }
        catch (Exception e) {
            JobInitializationPlugin.getLog().error((Object)("Error scheduling jobs: " + e.getMessage()), (Throwable)e);
        }
    }

    public void fileUpdated(String fileName) {
        if (this.started) {
            this.processFile();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

