/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;

public final class Util {
    public static final SortedSet EMPTY_SORTED_SET = Collections.unmodifiableSortedSet(new TreeSet());
    public static final String ZERO_LENGTH_STRING = "";

    public static final void assertInstance(Object object, Class c) {
        Util.assertInstance(object, c, false);
    }

    private static final void assertInstance(Object object, Class c, boolean allowNull) {
        if (object == null && allowNull) {
            return;
        }
        if (object == null || c == null) {
            throw new NullPointerException();
        }
        if (!c.isInstance(object)) {
            throw new IllegalArgumentException();
        }
    }

    public static final int compare(boolean left, boolean right) {
        return !left ? (right ? -1 : 0) : 1;
    }

    public static final int compare(int left, int right) {
        return left - right;
    }

    public static final int compare(Comparable left, Comparable right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return left.compareTo(right);
    }

    public static final int compare(Comparable[] left, Comparable[] right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        int l = left.length;
        int r = right.length;
        if (l != r) {
            return l - r;
        }
        int i = 0;
        while (i < l) {
            int compareTo = Util.compare(left[i], right[i]);
            if (compareTo != 0) {
                return compareTo;
            }
            ++i;
        }
        return 0;
    }

    public static final int compare(List left, List right) {
        int r;
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        int l = left.size();
        if (l != (r = right.size())) {
            return l - r;
        }
        int i = 0;
        while (i < l) {
            int compareTo = Util.compare((Comparable)left.get(i), (Comparable)right.get(i));
            if (compareTo != 0) {
                return compareTo;
            }
            ++i;
        }
        return 0;
    }

    public static final boolean endsWith(Object[] left, Object[] right, boolean equals) {
        if (left == null || right == null) {
            return false;
        }
        int r = right.length;
        int l = left.length;
        if (r > l || !equals && r == l) {
            return false;
        }
        int i = 0;
        while (i < r) {
            if (!Util.equals(left[l - i - 1], right[r - i - 1])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean equals(Object left, Object right) {
        return left == null ? right == null : right != null && left.equals(right);
    }

    public static final boolean equals(Object[] leftArray, Object[] rightArray) {
        if (leftArray == null) {
            return rightArray == null;
        }
        if (rightArray == null) {
            return false;
        }
        if (leftArray.length != rightArray.length) {
            return false;
        }
        int i = 0;
        while (i < leftArray.length) {
            boolean equal;
            Object left = leftArray[i];
            Object right = rightArray[i];
            boolean bl = left == null ? right == null : (equal = left.equals(right));
            if (!equal) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final int hashCode(int i) {
        return i;
    }

    public static final int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public static final int hashCode(Object[] objects) {
        if (objects == null) {
            return 0;
        }
        int hashCode = 89;
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object != null) {
                hashCode = hashCode * 31 + object.hashCode();
            }
            ++i;
        }
        return hashCode;
    }

    public static final boolean startsWith(Object[] left, Object[] right, boolean equals) {
        if (left == null || right == null) {
            return false;
        }
        int r = right.length;
        int l = left.length;
        if (r > l || !equals && r == l) {
            return false;
        }
        int i = 0;
        while (i < r) {
            if (!Util.equals(left[i], right[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final String translateString(ResourceBundle resourceBundle, String key, String defaultString) {
        if (resourceBundle != null && key != null) {
            try {
                String translatedString = resourceBundle.getString(key);
                if (translatedString != null) {
                    return translatedString;
                }
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return defaultString;
    }

    private Util() {
    }
}

