/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.services;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import javax.management.Notification;
import org.jboss.logging.DynamicLogger;
import org.jboss.monitor.alarm.AlarmHelper;
import org.jboss.monitor.alarm.AlarmNotification;
import org.jboss.monitor.alarm.AlarmTable;
import org.jboss.monitor.alarm.AlarmTableNotification;
import org.jboss.monitor.services.ActiveAlarmTableMBean;
import org.jboss.system.ListenerServiceMBeanSupport;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.Strings;

public class ActiveAlarmTable
extends ListenerServiceMBeanSupport
implements ActiveAlarmTableMBean {
    protected static final DynamicLogger log = DynamicLogger.getDynamicLogger((Class)(class$org$jboss$monitor$services$ActiveAlarmTable == null ? (class$org$jboss$monitor$services$ActiveAlarmTable = ActiveAlarmTable.class$("org.jboss.monitor.services.ActiveAlarmTable")) : class$org$jboss$monitor$services$ActiveAlarmTable));
    private SynchronizedLong notificationCount;
    AlarmTable almtab = new AlarmTable((ServiceMBeanSupport)this);
    static /* synthetic */ Class class$org$jboss$monitor$services$ActiveAlarmTable;

    public ActiveAlarmTable() {
        this.notificationCount = new SynchronizedLong(0L);
        this.almtab.setServerId("jboss");
        this.almtab.setMaxSize(1000);
    }

    public int getActiveAlarmCount() {
        return this.almtab.getAlarmSize();
    }

    public long getNotificationsReceived() {
        return this.notificationCount.get();
    }

    public void setServerId(String serverId) {
        if (serverId != null) {
            this.almtab.setServerId(serverId);
        }
    }

    public void setMaxTableSize(int maxSize) {
        this.almtab.setMaxSize(maxSize);
    }

    public int getMaxTableSize() {
        return this.almtab.getMaxSize();
    }

    public String getServerId() {
        return this.almtab.getServerId();
    }

    public void setLogLevel(String logLevel) {
        log.setLogLevelAsString(logLevel);
    }

    public String getLogLevel() {
        return log.getLogLevelAsString();
    }

    public int acknowledgeAll(String user, String system) {
        AlarmTableNotification[] atns = this.almtab.getAlarmTable();
        int acked = 0;
        for (int i = 0; i < atns.length; ++i) {
            AlarmTableNotification atn = atns[i];
            String alarmId = atn.getAlarmId();
            if (!this.almtab.acknowledge(alarmId, user, system)) continue;
            ++acked;
        }
        return acked;
    }

    public int unacknowledgeAll(String user, String system) {
        AlarmTableNotification[] atns = this.almtab.getAlarmTable();
        int unacked = 0;
        for (int i = 0; i < atns.length; ++i) {
            AlarmTableNotification atn = atns[i];
            String alarmId = atn.getAlarmId();
            if (!this.almtab.unacknowledge(alarmId, user, system)) continue;
            ++unacked;
        }
        return unacked;
    }

    public boolean acknowledge(String alarmId, String user, String system) {
        return this.almtab.acknowledge(alarmId, user, system);
    }

    public boolean unacknowledge(String alarmId, String user, String system) {
        return this.almtab.unacknowledge(alarmId, user, system);
    }

    public AlarmTableNotification[] fetchAlarmTable() {
        return this.almtab.getAlarmTable();
    }

    public String fetchAlarmTableAsHtml() {
        AlarmTableNotification[] tab = this.almtab.getAlarmTable();
        StringBuffer sbuf = new StringBuffer(8192);
        sbuf.append("<p>Number of Alarms: ").append(tab.length).append("</p>").append("\n");
        sbuf.append("<table border=\"1\">").append("\n");
        sbuf.append("<tr>");
        sbuf.append("<th width=\"20%\">AlarmInfo</th>");
        sbuf.append("<th>NotificationInfo</th>");
        sbuf.append("</tr>").append("\n");
        for (int i = 0; i < tab.length; ++i) {
            AlarmTableNotification atn = tab[i];
            Notification n = (Notification)atn.getUserData();
            Object source = AlarmNotification.getEffectiveSource(n);
            sbuf.append("<tr>");
            sbuf.append("<td>").append("alarmId: ").append(atn.getAlarmId()).append("<br><br>").append("severity: ").append(AlarmHelper.getSeverityAsString(atn.getSeverity())).append("<br>").append("alarmState: ").append(AlarmHelper.getStateAsString(atn.getAlarmState())).append("<br><br>").append("ackState: ").append(atn.getAckState()).append("<br><br>").append("ackTime: ").append(atn.getAckTime()).append("<br>").append("ackUser: ").append(atn.getAckUser()).append("<br>").append("ackSystem: ").append(atn.getAckSystem()).append("</td>");
            sbuf.append("<td>").append("source: ").append(source).append("<br>").append("type: ").append(n.getType()).append("<br>").append("timeStamp: ").append(n.getTimeStamp()).append("<br>").append("sequenceNumber: ").append(n.getSequenceNumber()).append("<br><br>").append("message: ").append(this.substNewLines(n.getMessage())).append("<br><br>").append("userData: ").append(this.substNewLines(n.getUserData())).append("</td>");
            sbuf.append("</tr>").append("\n");
        }
        sbuf.append("</table>").append("\n");
        return sbuf.toString();
    }

    public void startService() throws Exception {
        super.subscribe(true);
    }

    public void stopService() throws Exception {
        super.unsubscribe();
    }

    public void handleNotification2(Notification notification, Object handback) {
        log.log((Object)("Got notification (#" + Long.toString(this.notificationCount.increment()) + "): " + notification + ", handback: " + handback));
        this.almtab.update(notification);
    }

    protected String substNewLines(Object input) {
        if (input == null) {
            return "null";
        }
        return Strings.subst((String)"\n", (String)"<br>", (String)input.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

