/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.portlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.context.ReleaseableExternalContext;
import org.apache.myfaces.context.portlet.ApplicationMap;
import org.apache.myfaces.context.portlet.InitParameterMap;
import org.apache.myfaces.context.portlet.RequestHeaderMap;
import org.apache.myfaces.context.portlet.RequestHeaderValuesMap;
import org.apache.myfaces.context.portlet.RequestMap;
import org.apache.myfaces.context.portlet.RequestParameterMap;
import org.apache.myfaces.context.portlet.RequestParameterValuesMap;
import org.apache.myfaces.context.portlet.SessionMap;
import org.apache.myfaces.util.EnumerationIterator;

public class PortletExternalContextImpl
extends ExternalContext
implements ReleaseableExternalContext {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$context$portlet$PortletExternalContextImpl == null ? (class$org$apache$myfaces$context$portlet$PortletExternalContextImpl = PortletExternalContextImpl.class$("org.apache.myfaces.context.portlet.PortletExternalContextImpl")) : class$org$apache$myfaces$context$portlet$PortletExternalContextImpl));
    private static final String INIT_PARAMETER_MAP_ATTRIBUTE = (class$org$apache$myfaces$context$portlet$InitParameterMap == null ? (class$org$apache$myfaces$context$portlet$InitParameterMap = PortletExternalContextImpl.class$("org.apache.myfaces.context.portlet.InitParameterMap")) : class$org$apache$myfaces$context$portlet$InitParameterMap).getName();
    private static final Map EMPTY_UNMODIFIABLE_MAP = Collections.unmodifiableMap(new HashMap(0));
    PortletContext _portletContext;
    PortletRequest _portletRequest;
    PortletResponse _portletResponse;
    private Map _applicationMap;
    private Map _sessionMap;
    private Map _requestMap;
    private Map _requestParameterMap;
    private Map _requestParameterValuesMap;
    private Map _requestHeaderMap;
    private Map _requestHeaderValuesMap;
    private Map _initParameterMap;
    private boolean _isActionRequest;
    static /* synthetic */ Class class$org$apache$myfaces$context$portlet$PortletExternalContextImpl;
    static /* synthetic */ Class class$org$apache$myfaces$context$portlet$InitParameterMap;

    public PortletExternalContextImpl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        block6: {
            this._portletContext = portletContext;
            this._portletRequest = portletRequest;
            this._portletResponse = portletResponse;
            boolean bl = this._isActionRequest = portletRequest != null && portletRequest instanceof ActionRequest;
            if (this._isActionRequest) {
                ActionRequest actionRequest = (ActionRequest)portletRequest;
                try {
                    String contentType = portletRequest.getProperty("Content-Type");
                    String characterEncoding = this.lookupCharacterEncoding(contentType);
                    if (characterEncoding == null) {
                        PortletSession session = portletRequest.getPortletSession(false);
                        if (session != null) {
                            characterEncoding = (String)session.getAttribute("javax.faces.request.charset", 2);
                        }
                        if (characterEncoding != null) {
                            actionRequest.setCharacterEncoding(characterEncoding);
                        }
                    }
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block6;
                    log.warn((Object)("Failed to set character encoding " + e));
                }
            }
        }
    }

    private String lookupCharacterEncoding(String contentType) {
        String characterEncoding = null;
        if (contentType != null) {
            int charsetFind = contentType.indexOf("charset=");
            if (charsetFind != -1) {
                if (charsetFind == 0) {
                    characterEncoding = contentType.substring(8);
                } else {
                    char charBefore = contentType.charAt(charsetFind - 1);
                    if (charBefore == ';' || Character.isWhitespace(charBefore)) {
                        characterEncoding = contentType.substring(charsetFind + 8);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Incoming request has Content-Type header with character encoding " + characterEncoding));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Incoming request has Content-Type header without character encoding: " + contentType));
            }
        }
        return characterEncoding;
    }

    public void dispatch(String path) throws IOException {
        if (this._isActionRequest) {
            String msg = "Can not call dispatch() during a portlet ActionRequest";
            throw new IllegalStateException(msg);
        }
        PortletRequestDispatcher requestDispatcher = this._portletContext.getRequestDispatcher(path);
        try {
            requestDispatcher.include((RenderRequest)this._portletRequest, (RenderResponse)this._portletResponse);
        }
        catch (PortletException e) {
            if (e.getMessage() != null) {
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
            throw new FacesException((Throwable)e);
        }
    }

    public String encodeActionURL(String url) {
        this.checkNull(url, "url");
        return this._portletResponse.encodeURL(url);
    }

    public String encodeNamespace(String name) {
        if (this._isActionRequest) {
            String msg = "Can not call encodeNamespace() during a portlet ActionRequest";
            throw new IllegalStateException(msg);
        }
        return ((RenderResponse)this._portletResponse).getNamespace() + name;
    }

    public String encodeResourceURL(String url) {
        this.checkNull(url, "url");
        return this._portletResponse.encodeURL(url);
    }

    public Map getApplicationMap() {
        if (this._applicationMap == null) {
            this._applicationMap = new ApplicationMap(this._portletContext);
        }
        return this._applicationMap;
    }

    public String getAuthType() {
        return this._portletRequest.getAuthType();
    }

    public Object getContext() {
        return this._portletContext;
    }

    public String getInitParameter(String name) {
        return this._portletContext.getInitParameter(name);
    }

    public Map getInitParameterMap() {
        if (this._initParameterMap == null && (this._initParameterMap = (Map)this._portletContext.getAttribute(INIT_PARAMETER_MAP_ATTRIBUTE)) == null) {
            this._initParameterMap = new InitParameterMap(this._portletContext);
            this._portletContext.setAttribute(INIT_PARAMETER_MAP_ATTRIBUTE, (Object)this._initParameterMap);
        }
        return this._initParameterMap;
    }

    public String getRemoteUser() {
        return this._portletRequest.getRemoteUser();
    }

    public Object getRequest() {
        return this._portletRequest;
    }

    public String getRequestContextPath() {
        return this._portletRequest.getContextPath();
    }

    public Map getRequestCookieMap() {
        return EMPTY_UNMODIFIABLE_MAP;
    }

    public Map getRequestHeaderMap() {
        if (this._requestHeaderMap == null) {
            this._requestHeaderMap = new RequestHeaderMap(this._portletRequest);
        }
        return this._requestHeaderMap;
    }

    public Map getRequestHeaderValuesMap() {
        if (this._requestHeaderValuesMap == null) {
            this._requestHeaderValuesMap = new RequestHeaderValuesMap(this._portletRequest);
        }
        return this._requestHeaderValuesMap;
    }

    public Locale getRequestLocale() {
        return this._portletRequest.getLocale();
    }

    public Iterator getRequestLocales() {
        return new EnumerationIterator(this._portletRequest.getLocales());
    }

    public Map getRequestMap() {
        if (this._requestMap == null) {
            this._requestMap = new RequestMap(this._portletRequest);
        }
        return this._requestMap;
    }

    public Map getRequestParameterMap() {
        if (this._requestParameterMap == null) {
            this._requestParameterMap = new RequestParameterMap(this._portletRequest);
        }
        return this._requestParameterMap;
    }

    public Iterator getRequestParameterNames() {
        return new EnumerationIterator(this._portletRequest.getParameterNames());
    }

    public Map getRequestParameterValuesMap() {
        if (this._requestParameterValuesMap == null) {
            this._requestParameterValuesMap = new RequestParameterValuesMap(this._portletRequest);
        }
        return this._requestParameterValuesMap;
    }

    public String getRequestPathInfo() {
        return null;
    }

    public String getRequestServletPath() {
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        this.checkNull(path, "path");
        return this._portletContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        this.checkNull(path, "path");
        return this._portletContext.getResourceAsStream(path);
    }

    public Set getResourcePaths(String path) {
        this.checkNull(path, "path");
        return this._portletContext.getResourcePaths(path);
    }

    public Object getResponse() {
        return this._portletResponse;
    }

    public Object getSession(boolean create) {
        return this._portletRequest.getPortletSession(create);
    }

    public Map getSessionMap() {
        if (this._sessionMap == null) {
            this._sessionMap = new SessionMap(this._portletRequest);
        }
        return this._sessionMap;
    }

    public Principal getUserPrincipal() {
        return this._portletRequest.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        this.checkNull(role, "role");
        return this._portletRequest.isUserInRole(role);
    }

    public void log(String message) {
        this.checkNull(message, "message");
        this._portletContext.log(message);
    }

    public void log(String message, Throwable exception) {
        this.checkNull(message, "message");
        this.checkNull(exception, "exception");
        this._portletContext.log(message, exception);
    }

    public void redirect(String url) throws IOException {
        if (!(this._portletResponse instanceof ActionResponse)) {
            throw new IllegalArgumentException("Only ActionResponse supported");
        }
        ((ActionResponse)this._portletResponse).sendRedirect(url);
    }

    public void release() {
        this._portletContext = null;
        this._portletRequest = null;
        this._portletResponse = null;
        this._applicationMap = null;
        this._sessionMap = null;
        this._requestMap = null;
        this._requestParameterMap = null;
        this._requestParameterValuesMap = null;
        this._requestHeaderMap = null;
        this._requestHeaderValuesMap = null;
        this._initParameterMap = null;
    }

    private void checkNull(Object o, String param) {
        if (o == null) {
            throw new NullPointerException(param + " can not be null.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

