/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.encoding.ser;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.logging.Logger;

public class DeferredBeanConstruction {
    private static Logger log = Logger.getLogger((String)DeferredBeanConstruction.class.getName());
    private Constructor ctor;
    private Class[] ctorParamTypes;
    private List ctorParams = new ArrayList();

    public DeferredBeanConstruction(Constructor ctor) {
        this.ctor = ctor;
        this.ctorParamTypes = ctor.getParameterTypes();
    }

    public Constructor getConstructor() {
        return this.ctor;
    }

    public Object newBeanInstance(Object ctorArg) {
        try {
            log.debug((Object)("Add constructor argument: " + ctorArg));
            int index = this.ctorParams.size();
            Class paramType = this.ctorParamTypes[index];
            if (!JavaUtils.isConvertable(ctorArg, paramType)) {
                log.debug((Object)("Ignoring parameter [" + ctorArg + "], given value is not convertable to " + paramType.getName()));
                ctorArg = null;
            } else {
                ctorArg = JavaUtils.convert(ctorArg, paramType);
            }
            this.ctorParams.add(ctorArg);
            if (this.ctorParamTypes.length == this.ctorParams.size()) {
                log.debug((Object)("Attempt to make bean with: " + this.toString()));
                Object bean = this.ctor.newInstance(this.ctorParams.toArray());
                return bean;
            }
            log.debug((Object)"Waiting for more constructor arguments");
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot construct target object with: " + this.ctorParams);
        }
    }

    public String toString() {
        return "[ctor=" + this.ctor + ",args=" + this.ctorParams + "]";
    }
}

