/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.factory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyTreeItem;
import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.repository.factory.NodeProperty;
import com.clustercontrol.repository.util.DataTable;
import com.clustercontrol.repository.util.SearchNodeProperties;
import com.clustercontrol.repository.util.SnmpPoller;
import com.clustercontrol.util.PropertyUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SearchNodeBySNMP {
    protected static Log m_log = LogFactory.getLog(SearchNodeBySNMP.class);
    private static final String OID_NAME = ".1.3.6.1.2.1.1.5.0";
    private static final String OID_DESCR = ".1.3.6.1.2.1.1.1.0";
    private static final String OID_CONTACT = ".1.3.6.1.2.1.1.4.0";
    private static final String OID_DISK_INDEX = ".1.3.6.1.4.1.2021.13.15.1.1.1";
    private static final String OID_DISK_NAME = ".1.3.6.1.4.1.2021.13.15.1.1.2";
    private static final String OID_NIC_INDEX = ".1.3.6.1.2.1.2.2.1.1";
    private static final String OID_NIC_NAME = ".1.3.6.1.2.1.2.2.1.2";
    private static final String OID_FILESYSTEM_INDEX = ".1.3.6.1.2.1.25.2.3.1.1";
    private static final String OID_FILESYSTEM_TYPE = ".1.3.6.1.2.1.25.2.3.1.2";
    private static final String OID_FILESYSTEM_NAME = ".1.3.6.1.2.1.25.2.3.1.3";

    public static Property searchNode(Hashtable pollingData, int mode, Locale locale) {
        SearchNodeProperties pollingProp = SearchNodeProperties.getProperties();
        int port = pollingProp.getPort();
        int version = pollingProp.getVersion();
        String community = pollingProp.getCommunity();
        InetAddress ipAddress = pollingProp.getAddress();
        int retries = pollingProp.getRetry();
        int timeout = pollingProp.getTimeOut();
        ArrayList oidList = pollingProp.getOidList();
        try {
            ipAddress = InetAddress.getByName((String)pollingData.get("IPAddress"));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        port = Integer.parseInt((String)pollingData.get("port"));
        community = (String)pollingData.get("community");
        version = (Integer)pollingData.get("version");
        DataTable ret = new DataTable();
        SnmpPoller poller = new SnmpPoller();
        poller.polling(ipAddress, port, version, community, retries, timeout, oidList, ret);
        return SearchNodeBySNMP.stractProperty(pollingData, ret, mode, locale);
    }

    private static Property stractProperty(Hashtable pollingData, DataTable ret, int mode, Locale locale) {
        String oidCounter;
        String oidCounter2;
        String description;
        String hostname;
        ArrayList propertyList;
        Property property = new NodeProperty().getProperty(mode, locale);
        if (ret.getValue(OID_DESCR) != null && ((String)ret.getValue(OID_DESCR).getValue()).length() != 0) {
            propertyList = PropertyUtil.getProperty((Property)property, (String)"description");
            ((Property)propertyList.get(0)).setValue((Object)("Auto detect at " + new Date().toString()));
        }
        propertyList = PropertyUtil.getProperty((Property)property, (String)"ipAddressV4");
        ((Property)propertyList.get(0)).setValue((Object)((String)pollingData.get("IPAddress")));
        propertyList = PropertyUtil.getProperty((Property)property, (String)"snmpPort");
        ((Property)propertyList.get(0)).setValue((Object)Integer.parseInt((String)pollingData.get("port")));
        propertyList = PropertyUtil.getProperty((Property)property, (String)"snmpCommunity");
        ((Property)propertyList.get(0)).setValue((Object)((String)pollingData.get("community")));
        propertyList = PropertyUtil.getProperty((Property)property, (String)"snmpVersion");
        ((Property)propertyList.get(0)).setValue((Object)SnmpVersionConstant.typeToString((Integer)((Integer)pollingData.get("version"))));
        if (ret.getValue(OID_NAME) != null && (hostname = (String)ret.getValue(OID_NAME).getValue()).length() != 0) {
            if (hostname.indexOf(".") != -1) {
                hostname = hostname.substring(0, hostname.indexOf("."));
            }
            propertyList = PropertyUtil.getProperty((Property)property, (String)"hostName");
            ((Property)propertyList.get(0)).setValue((Object)hostname);
            propertyList = PropertyUtil.getProperty((Property)property, (String)"nodeName");
            ((Property)propertyList.get(0)).setValue((Object)hostname);
        }
        propertyList = PropertyUtil.getProperty((Property)property, (String)"ipAddressVersion");
        ((Property)propertyList.get(0)).setValue((Object)"v4");
        if (ret.getValue(OID_CONTACT) != null && ((String)ret.getValue(OID_CONTACT).getValue()).length() != 0) {
            propertyList = PropertyUtil.getProperty((Property)property, (String)"administrator");
            ((Property)propertyList.get(0)).setValue((Object)((String)ret.getValue(OID_CONTACT).getValue()));
        }
        boolean isWindows = false;
        if (ret.getValue(OID_DESCR) != null && (description = (String)ret.getValue(OID_DESCR).getValue()).length() != 0) {
            String OsName = "";
            if (description.matches(".*indows.*")) {
                OsName = "Windows";
                isWindows = true;
            } else if (description.matches(".*inux.*")) {
                OsName = "Linux";
            } else if (description.matches(".*SunOS.*") || description.matches("Solaris")) {
                OsName = "Solaris";
            } else if (description.indexOf(" ") != -1) {
                OsName = description.substring(0, description.indexOf(" "));
            }
            propertyList = PropertyUtil.getProperty((Property)property, (String)"osName");
            ((Property)propertyList.get(0)).setValue((Object)OsName);
            propertyList = PropertyUtil.getProperty((Property)property, (String)"osVersion");
            ((Property)propertyList.get(0)).setValue((Object)description);
        }
        propertyList = PropertyUtil.getProperty((Property)property, (String)"device");
        Property deviceProperty = (Property)propertyList.get(0);
        int index = PropertyUtil.getPropertyIndex((Property)property, (Property)deviceProperty);
        int j = 0;
        int i = 1;
        while (ret.getValue(oidCounter2 = ".1.3.6.1.4.1.2021.13.15.1.1.1." + i) != null && ((String)ret.getValue(oidCounter2).getValue()).length() != 0) {
            String disk = (String)ret.getValue(".1.3.6.1.4.1.2021.13.15.1.1.2." + i).getValue();
            if (!disk.startsWith("ram")) {
                if (j == 0) {
                    deviceProperty.setValue((Object)((String)ret.getValue(".1.3.6.1.4.1.2021.13.15.1.1.2." + i).getValue()));
                    propertyList = PropertyUtil.getProperty((Property)deviceProperty, (String)"deviceName");
                    ((Property)propertyList.get(0)).setValue((Object)((String)ret.getValue(".1.3.6.1.4.1.2021.13.15.1.1.2." + i).getValue()));
                    propertyList = PropertyUtil.getProperty((Property)deviceProperty, (String)"deviceIndex");
                    ((Property)propertyList.get(0)).setValue((Object)Integer.parseInt((String)ret.getValue(".1.3.6.1.4.1.2021.13.15.1.1.1." + i).getValue()));
                    propertyList = PropertyUtil.getProperty((Property)deviceProperty, (String)"deviceType");
                    ((Property)propertyList.get(0)).setValue((Object)"disk");
                } else {
                    Property copy = PropertyUtil.copy((Property)deviceProperty);
                    copy.setValue((Object)((String)ret.getValue(".1.3.6.1.4.1.2021.13.15.1.1.2." + i).getValue()));
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"deviceName");
                    ((Property)propertyList.get(0)).setValue((Object)((String)ret.getValue(".1.3.6.1.4.1.2021.13.15.1.1.2." + i).getValue()));
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"deviceIndex");
                    ((Property)propertyList.get(0)).setValue((Object)Integer.parseInt((String)ret.getValue(".1.3.6.1.4.1.2021.13.15.1.1.1." + i).getValue()));
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"deviceType");
                    ((Property)propertyList.get(0)).setValue((Object)"disk");
                    property.addChildren((PropertyTreeItem)copy, index + j);
                }
                ++j;
            }
            ++i;
        }
        for (String fullOid : ret.keySet()) {
            if (!fullOid.startsWith(OID_NIC_INDEX)) continue;
            String tmpIndex = fullOid.substring(fullOid.lastIndexOf("."));
            if (((String)ret.getValue(fullOid).getValue()).length() == 0) continue;
            if (j == 0) {
                deviceProperty.setValue((Object)SearchNodeBySNMP.convString((String)ret.getValue(OID_NIC_NAME + tmpIndex).getValue(), isWindows));
                propertyList = PropertyUtil.getProperty((Property)deviceProperty, (String)"deviceName");
                ((Property)propertyList.get(0)).setValue((Object)SearchNodeBySNMP.convString((String)ret.getValue(OID_NIC_NAME + tmpIndex).getValue(), isWindows));
                propertyList = PropertyUtil.getProperty((Property)deviceProperty, (String)"deviceIndex");
                ((Property)propertyList.get(0)).setValue((Object)Integer.parseInt((String)ret.getValue(OID_NIC_INDEX + tmpIndex).getValue()));
                propertyList = PropertyUtil.getProperty((Property)deviceProperty, (String)"deviceType");
                ((Property)propertyList.get(0)).setValue((Object)"nic");
            } else {
                Property copy = PropertyUtil.copy((Property)deviceProperty);
                copy.setValue((Object)SearchNodeBySNMP.convString((String)ret.getValue(OID_NIC_NAME + tmpIndex).getValue(), isWindows));
                propertyList = PropertyUtil.getProperty((Property)copy, (String)"deviceName");
                ((Property)propertyList.get(0)).setValue((Object)SearchNodeBySNMP.convString((String)ret.getValue(OID_NIC_NAME + tmpIndex).getValue(), isWindows));
                propertyList = PropertyUtil.getProperty((Property)copy, (String)"deviceIndex");
                ((Property)propertyList.get(0)).setValue((Object)Integer.parseInt((String)ret.getValue(OID_NIC_INDEX + tmpIndex).getValue()));
                propertyList = PropertyUtil.getProperty((Property)copy, (String)"deviceType");
                ((Property)propertyList.get(0)).setValue((Object)"nic");
                property.addChildren((PropertyTreeItem)copy, index + j);
            }
            ++j;
        }
        propertyList = PropertyUtil.getProperty((Property)property, (String)"fileSystem");
        Property fileSystemProperty = (Property)propertyList.get(0);
        index = PropertyUtil.getPropertyIndex((Property)property, (Property)fileSystemProperty);
        i = 1;
        j = 0;
        while (ret.getValue(oidCounter = ".1.3.6.1.2.1.25.2.3.1.1." + i) != null && ((String)ret.getValue(oidCounter).getValue()).length() != 0) {
            String strageType = ret.getValue(".1.3.6.1.2.1.25.2.3.1.2." + i).getValue().toString();
            if (strageType.equals(".1.3.6.1.2.1.25.2.1.4")) {
                if (j == 0) {
                    fileSystemProperty.setValue((Object)SearchNodeBySNMP.convStringFilessystem((String)ret.getValue(".1.3.6.1.2.1.25.2.3.1.3." + i).getValue()));
                    propertyList = PropertyUtil.getProperty((Property)fileSystemProperty, (String)"fileSystemMountPoint");
                    ((Property)propertyList.get(0)).setValue((Object)SearchNodeBySNMP.convStringFilessystem((String)ret.getValue(".1.3.6.1.2.1.25.2.3.1.3." + i).getValue()));
                    propertyList = PropertyUtil.getProperty((Property)fileSystemProperty, (String)"fileSystemIndex");
                    ((Property)propertyList.get(0)).setValue((Object)Integer.parseInt((String)ret.getValue(".1.3.6.1.2.1.25.2.3.1.1." + i).getValue()));
                } else {
                    Property copy = PropertyUtil.copy((Property)fileSystemProperty);
                    copy.setValue((Object)SearchNodeBySNMP.convStringFilessystem((String)ret.getValue(".1.3.6.1.2.1.25.2.3.1.3." + i).getValue()));
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"fileSystemMountPoint");
                    ((Property)propertyList.get(0)).setValue((Object)SearchNodeBySNMP.convStringFilessystem((String)ret.getValue(".1.3.6.1.2.1.25.2.3.1.3." + i).getValue()));
                    propertyList = PropertyUtil.getProperty((Property)copy, (String)"fileSystemIndex");
                    ((Property)propertyList.get(0)).setValue((Object)Integer.parseInt((String)ret.getValue(".1.3.6.1.2.1.25.2.3.1.1." + i).getValue()));
                    property.addChildren((PropertyTreeItem)copy, index + j);
                }
                ++j;
            }
            ++i;
        }
        return property;
    }

    private static String convString(String str, boolean isWindows) {
        if (!isWindows) {
            String ret = str.replaceAll("/", " ");
            ret = ret.replaceAll("\\\\", " ");
            ret = ret.replaceAll(";", " ");
            ret = ret.replaceAll(",", " ");
            ret = ret.replaceAll("<", " ");
            ret = ret.replaceAll(">", " ");
            ret = ret.replaceAll("\\\\+", " ");
            ret = ret.replaceAll("\"", " ");
            return ret;
        }
        char[] chars = str.toCharArray();
        StringBuffer retStr = new StringBuffer();
        int j = 0;
        int i = 0;
        while (i < chars.length) {
            short first = (short)(chars[i] - 48);
            short second = (short)(chars[i + 1] - 48);
            if (second > 10) {
                second = (short)(second - 7);
            }
            retStr.append((char)(first * 16 + second));
            i += 3;
            ++j;
        }
        String ret = retStr.substring(0, retStr.length() - 1);
        ret = ret.replaceAll("/", " ");
        ret = ret.replaceAll("\\\\", " ");
        ret = ret.replaceAll(";", " ");
        ret = ret.replaceAll(",", " ");
        ret = ret.replaceAll("<", " ");
        ret = ret.replaceAll(">", " ");
        ret = ret.replaceAll("\\\\+", " ");
        ret = ret.replaceAll("\"", " ");
        return ret;
    }

    private static String convStringFilessystem(String str) {
        if (str.matches("/.*")) {
            return str;
        }
        if (str.matches("[A-Z]:\\\\.*")) {
            String returnString = str.substring(0, 3);
            return returnString;
        }
        System.out.println(str);
        char[] chars = str.toCharArray();
        StringBuffer ret = new StringBuffer();
        int j = 0;
        int i = 0;
        while (i < chars.length) {
            short first = (short)(chars[i] - 48);
            short second = (short)(chars[i + 1] - 48);
            if (second > 10) {
                second = (short)(second - 7);
            }
            ret.append((char)(first * 16 + second));
            i += 3;
            ++j;
        }
        return ret.substring(0, 3);
    }
}

