/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.standardInterceptors;

import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.standardInterceptors.CodeSetInfoInterceptor;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;

public class IORInterceptorInitializer
extends LocalObject
implements ORBInitializer {
    public void post_init(ORBInitInfo oRBInitInfo) {
        Configuration configuration = null;
        try {
            ORB oRB = ((ORBInitInfoImpl)oRBInitInfo).getORB();
            configuration = oRB.getConfiguration();
            int n = configuration.getAttributeAsInteger("jacorb.giop_minor_version", 2);
            if (n > 0) {
                oRBInitInfo.add_ior_interceptor(new CodeSetInfoInterceptor(oRB));
            }
        }
        catch (Exception exception) {
            if (configuration != null) {
                Logger logger = configuration.getNamedLogger("org.jacorb.interceptors.ior_init");
                if (logger.isErrorEnabled()) {
                    logger.error("During IORInterceptor.post_init(): " + exception.getMessage());
                }
            }
            exception.printStackTrace();
        }
    }

    public void pre_init(ORBInitInfo oRBInitInfo) {
    }
}

