/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public abstract class SocketWrapper {
    private Socket socket;
    private int timeout;

    public SocketWrapper(Socket socket) {
        this.socket = socket;
    }

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract InputStream getInputStream() throws IOException;

    public abstract void checkConnection() throws IOException;

    public void setTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
        if (this.socket != null) {
            this.socket.setSoTimeout(timeout);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    protected Socket getSocket() {
        return this.socket;
    }

    protected void finalize() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

